#if !defined(BRENTRYL_H) && !defined(__BEDRC__)
#define BRENTRYL_H
//========================================================================================
//
//     File:			BREntryL.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 1991
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRENTRYL_K
#include "BREntryL.k"
#endif

#ifndef BRLISTBX_H
#include "BRListBx.h"
#endif

#ifndef BREDITCO_H
#include "BREditCo.h"
#endif

#ifndef BCCOLL_H
#include "BCColl.h"
#endif


//========================================================================================
// STRUCT BR_SEntryListBoxBaseResource
//========================================================================================

struct BR_SEntryListBoxBaseResource : BR_SListBoxBaseResource
{
};

//========================================================================================
// CLASS BR_CEntryListBoxBase
//
//		Abstract class that defines the interface for fEntryArray list boxes. Implementation
//		provided by derived classes.
//========================================================================================

class BR_CEntryListBoxBase : public BR_CListBoxBase
{
public:
	enum { kPlaceHolder };

	virtual void GetEditSelection(BR_CEditControl::CharacterPosition& startPos,
								  BR_CEditControl::CharacterPosition& endPos) const = 0;
	virtual void SetEditSelection(BR_CEditControl::CharacterPosition startPos,
								  BR_CEditControl::CharacterPosition endPos) = 0;
	virtual void SetTextLimit(unsigned short textLimit) = 0;
	virtual void ShowDropDown(BR_Boolean show) = 0;

protected:
	BR_CEntryListBoxBase(BR_CView* enclosure,
						 BR_CBureaucrat* supervisor,
						 BR_CItemHelper* itemHelper,
						 BR_Distance width,
						 BR_Distance height,
						 BR_Coordinate x,
						 BR_Coordinate y,
						 ViewSizing horizontalSizing,
						 ViewSizing verticalSizing,
						 ViewId viewId,
						 ViewStyle style = kBedELSSimple | kBedLBSVerticalScroll);

	BR_CEntryListBoxBase(BR_CView* enclosure,
						 BR_CBureaucrat* supervisor,
						 const BR_CModule& module,
						 BR_SResource& viewResource);

	virtual~ BR_CEntryListBoxBase();

	BR_SETCLASSNAME(BR_CEntryListBoxBase);
};




//========================================================================================
// STRUCT BR_SEntryListBoxResource
//========================================================================================

struct BR_SEntryListBoxResource : BR_SEntryListBoxBaseResource
{
};

//========================================================================================
// CLASS BR_CEntryListBox
//
//		This class creates and maintains a list box with an added control
//		where the user can type in an fEntryArray name (basically an edit
//		control) and/or preview the fEntryArray selected in the list box
//
//========================================================================================

class BR_CEntryListBox : public BR_CEntryListBoxBase
{
	friend BR_CItemHelper;

public:
	BR_CEntryListBox(BR_CView* enclosure,
					 BR_CBureaucrat* supervisor,
					 BR_CItemHelper* itemHelper,
					 BR_Distance width,
					 BR_Distance height,
					 BR_Coordinate x,
					 BR_Coordinate y,
					 ViewSizing horizontalSizing,
					 ViewSizing verticalSizing,
					 ViewId viewId,
					 ViewStyle style = kBedELSSimple | kBedLBSVerticalScroll);

	BR_CEntryListBox(BR_CView* enclosure,
					 BR_CBureaucrat* supervisor,
					 const BR_CModule& module,
					 BR_SResource& viewResource);

	virtual~ BR_CEntryListBox();

	virtual ItemIndex AddItem(BR_CObject* item);
	virtual BR_Boolean DoCommand(CommandId commandId,
								 BR_CObject* notifier,
								 BR_Boolean callSupervisor = TRUE);
	virtual ItemIndex FindItem(const BR_CObject& item,
								 ItemIndex firstIndex = 0) const;
	virtual unsigned short GetCount() const;
	virtual ItemIndex GetCurrentSelection() const;
	virtual BR_CObject* GetItem(ItemIndex index) const;
	virtual BR_CView* GetItemEnclosure() const;
	virtual unsigned short GetNoItemsSelected() const;
	virtual ItemIndex GetSelectedItems(BC_TCollection<ItemIndex> &selectedItems) const;
	virtual void GetTextFromItem(ItemIndex index,
								 BR_TString<BR_Char>& text) const;
	virtual ItemIndex GetTopItem() const;
	virtual ItemIndex InsertItem(ItemIndex insertAt,
								   BR_CObject* item);
	virtual BR_Boolean IsItemSelected(ItemIndex itemNo) const;
	virtual ItemIndex RemoveItem(ItemIndex itemNo);
	virtual void SelectItem(ItemIndex itemNo);
	virtual void SelectRange(ItemIndex firstItem,
							 ItemIndex lastItem);
	virtual void SetCurrentSelection(ItemIndex itemNo);
	virtual void SetTopItem(ItemIndex itemNo);
	virtual void UnselectItem(ItemIndex itemNo);
	virtual void UnselectRange(ItemIndex firstItem,
							   ItemIndex lastItem);

	virtual void GetEditSelection(BR_CEditControl::CharacterPosition& startPos,
								  BR_CEditControl::CharacterPosition& endPos) const;
	virtual void SetEditSelection(BR_CEditControl::CharacterPosition startPos,
								  BR_CEditControl::CharacterPosition endPos);
	virtual void SetTextLimit(unsigned short textLimit);
	virtual void ShowDropDown(BR_Boolean show);

protected:
	enum { kListBoxId = 1, kEditControlId = 2 };

	virtual void AdoptItemHelper(BR_CItemHelper* itemHelper);
	BR_CItemHelper* GetItemHelper() const;
	virtual void SetEditControlText(const BR_TString<BR_Char>& text);

private:
	BR_CItemHelper* fItemHelper;

#ifdef BR_BUILD_MAC
private:
	void CreateSubviews(BR_CView* enclosure,
						BR_CBureaucrat* supervisor,
						BR_CItemHelper* itemHelper,
						BR_Distance width,
						BR_Distance height,
						BR_Coordinate x,
						BR_Coordinate y,
						ViewSizing horizontalSizing,
						ViewSizing verticalSizing,
						ViewId viewId,
						ViewStyle style);

	enum { kDefaultSeparationSize = 3 };

	BR_CListBox* fListBox;
	BR_CEditControl* fEditControl;
#endif

#ifdef BR_BUILD_WIN
public:
	long Dispatch(WORD wMessage,
				  WORD wParam,
				  long lParam,
				  BR_Boolean callDefaultProc = TRUE);	// ?INTERNAL?
	long DoDefaultProc(WORD wMessage,
					   WORD wParam,
					   long lParam);					// ?INTERNAL?

protected:
	void HandleDelete(ItemIndex itemNo);
	virtual void BedWinMouseDownHook(WORD message);
	HWND BedWinGetEditControl();
	HWND BedWinGetListBox();

	static HWND BedWinFromEditHandle(HWND editHwnd);
	static HWND BedWinFromListHandle(HWND listHwnd);

private:
	// In Windows, we subclass the fEntryArray list box's edit control so that we can handle
	// ESC/ENTER keys When the edit control has the focus
	
	void BedWinInitSubclassing();

	static FARPROC fgWinEditControlProc;
	static long PASCAL BedWinEditWndProc(HWND hwnd,
										 unsigned message,
										 WORD wParam,
										 long lParam);

	static FARPROC fgWinListBoxProc;
	static long PASCAL BedWinListWndProc(HWND hwnd,
										 unsigned message,
										 WORD wParam,
										 long lParam);

	static BR_Boolean fgWinMouseClick;

	long BedWinHandleCompareItemMessage(LPCOMPAREITEMSTRUCT compareData);
	long BedWinHandleDrawItemMessage(LPDRAWITEMSTRUCT drawItemStruct);
	
	void InitializeItemSize();

	BR_Boolean fHaveItemSize;
	long fWidth, fHeight;
#endif

	BR_SETCLASSNAME(BR_CEntryListBox);
};

//----------------------------------------------------------------------------------------
// BR_CEntryListBox::GetItemHelper
//----------------------------------------------------------------------------------------

inline BR_CItemHelper *BR_CEntryListBox::GetItemHelper() const
{
	BR_ASSERT(fItemHelper != NULL);
	return fItemHelper;
}

#endif
