#if !defined(BREDITTX_H) && !defined(__BEDRC__)
#define BREDITTX_H
//========================================================================================
//
//     File:		BREditTx.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/7/90
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSLTEXT_H
#include "BRSlText.h"
#endif

#ifndef BRRECT_H
#include "BRRect.h"
#endif

#ifndef BRVIEW_H
#include "BRView.h"
#endif

//========================================================================================
//	BR_CEditText
//========================================================================================

class BR_CEditText : public BR_CSelectText
{
public:
	BR_CEditText(BR_CView* enclosure,
				 BR_CBureaucrat* supervisor,
				 BR_Distance width,
				 BR_Distance height,
				 BR_Coordinate x,
				 BR_Coordinate y,
				 ViewSizing horizontalSizing,
				 ViewSizing verticalSizing,
				 ViewUnits viewUnits,
				 const BR_CRectangle& interior);

	BR_CEditText(BR_CView* enclosure,
				 BR_CBureaucrat* supervisor,
				 const BR_CModule& resourceModule,
				 BR_SResource& viewResource);

	virtual~ BR_CEditText();

	// Inherited virtual methods
	virtual BR_Boolean DoCommand(CommandId itsCommandId,
								 BR_CObject* itsNotifier,
								 BR_Boolean callSupervisor = TRUE);
	virtual void UpdateMenus(BR_CMenuBar& theMenuBar,
							 BR_Boolean callSupervisor = TRUE);
	virtual BR_Boolean DoKey(Key theKey,
							 unsigned short repeatCount,
							 BR_Boolean callSupervisor = TRUE);
	virtual BR_Boolean DoKeyDown(Key theKey,
								 unsigned short repeatCount,
								 BR_Boolean callSupervisor = TRUE);

	// New virtual methods
	virtual BR_Boolean DoPrintKey(Key theKey,
								  unsigned short repeatCount);
	virtual BR_Boolean DoReturn();
	virtual BR_Boolean DoDelete();
	virtual BR_Boolean CutClipboard();
	virtual BR_Boolean PasteClipboard();
	virtual void SetReadOnly(BR_Boolean fSetReadOnly);
	BR_Boolean IsReadOnly() const;

protected:
	virtual BR_Boolean IsClipboardTextAvailable() const;
	BR_Boolean DeleteSelection();

private:
	BR_PlatformHandle GetClipboardData() const;
	BR_Boolean InsertTextStream(BR_CTextStream& Stream,
								LineNumber lineNumber,
								ColumnNumber columnNumber);

	BR_Boolean fReadOnly;

	BR_SETCLASSNAME(BR_CEditText);
};

#endif
