#if !defined(BRDOCWIN_H) && !defined(__BEDRC__)
#define BRDOCWIN_H
//========================================================================================
//
//     File:			BRDocWin.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	August 16, 1990
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRWINDOW_H
#include "BRWindow.h"
#endif

//========================================================================================
// Forward declarations
//========================================================================================

class BR_CDocumentIcon;
class BR_CMDIAppDesktop;

//========================================================================================
//	BR_SDocWinResource
//========================================================================================
// This structure defines the document window resource information

struct BR_SDocWinResource : public BR_SWinResource
{
	BR_ResourceId fWindowIconId;
};

//========================================================================================
//	CLASS BR_CDocWindow
//========================================================================================

class BR_CDocWindow : public BR_CWindow
{
public:
	BR_CDocWindow(BR_CMDIAppDesktop* enclosure,
				  BR_CDocument* supervisor,
				  ViewStyle style = kDocumentWindow);

	BR_CDocWindow(BR_CView* enclosure,
				  BR_CBureaucrat* supervisor,
				  const BR_CModule& module,
				  BR_SResource& resource);

	virtual~ BR_CDocWindow();

	// this might need to be moved up a class 
	BR_Boolean IsIconic() const;

//-------------------------------------------------------------------------
//   Macintosh
//-------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	virtual void SetText(const BR_TString<BR_Char>& text, BR_Boolean = TRUE);		// Windows uses the BR_CView method

protected:
	BR_CWindowMenu* GetWindowMenu() const;			// ?INTERNAL?
	void AddToWindowMenu();						// ?INTERNAL?

#endif

//-------------------------------------------------------------------------
//   Windows
//-------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	// these should be supported on both platforms
	virtual void 				Zoom();
	virtual void 				Restore();

	// this might need to be moved up a class
	void 						Iconize();

	// Inherited methods
	virtual LONG 				Dispatch(WORD wMessage,
						  				WORD wParam,
						  				LONG lParam,
						  				BR_Boolean callDefaultProc = TRUE);
	virtual LONG 				DoDefaultProc(WORD wMessage,
							   					WORD wParam,
							   					LONG lParam);
	void 						SetIcon(const BR_CModule& module,
										BR_ResourceId resourceId);
	void 						SetIcon(BR_CDocumentIcon* icon);
	BR_CDocumentIcon* 			GetIcon() const;
	void 						PaintIcon();
	virtual BR_CViewHelper 	*CreateViewHelper();

protected:
	void Destroy();

private:
	BR_CDocumentIcon* 			fDocumentIcon;
	static unsigned short 	gNumberOfInstances;
	static BR_CDocumentIcon* 	gDefaultDocumentIcon;
	BR_Boolean 					fUseDefaultIcon;

	// New methods
	void InitDocWindow(BR_CMDIAppDesktop* enclosure,
					   BR_CDocument* supervisor,
					   ViewStyle style,
					   const BR_CRectangle& sizeRect);
#endif

	BR_SETCLASSNAME(BR_CDocWindow);
};

//--------------------------------------------------------------------------
//	BR_CDocWindow::IsIconic
//
//		checks if the window is iconic
//--------------------------------------------------------------------------
inline BR_Boolean BR_CDocWindow::IsIconic() const
{
#ifdef BR_BUILD_WIN
	return ::IsIconic(GetPlatformWindow());
#endif

#ifdef BR_BUILD_MAC
	return FALSE;
#endif
}

#ifdef BR_BUILD_WIN
//--------------------------------------------------------------------------
//	BR_CDocWindow::SetIcon
//--------------------------------------------------------------------------
inline void BR_CDocWindow::SetIcon(BR_CDocumentIcon* icon)
{
	fDocumentIcon = icon;
}
#endif

#ifdef BR_BUILD_WIN
//--------------------------------------------------------------------------
//	BR_CDocWindow::GetIcon
//--------------------------------------------------------------------------
inline BR_CDocumentIcon* BR_CDocWindow::GetIcon() const
{
	return fDocumentIcon;
}
#endif

#endif


