#if !defined(BRDOCDIR_H) && !defined(__BEDRC__)
#define BRDOCDIR_H
//========================================================================================
//
//     File:		BRDocDir.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	December 1991
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDOCUME_H
#include "BRDocume.h"
#endif

#ifndef BCSTOREU_H
#include "BCStoreU.h"
#endif

#ifndef BCCOLLU_H
#include "BCCollU.h"
#endif


//========================================================================================
//	CLASS BR_CDocumentDirector
//========================================================================================
class BR_CDocumentDirector : public BR_CDocument
{
public:
	BR_CDocumentDirector(BR_CDocumentDirector* itsSupervisor);
	virtual~ BR_CDocumentDirector();

	virtual void AddDocument(BR_CDocument* aDocument);

	virtual BR_Boolean Close(BR_Boolean quitting,
							 BR_Boolean confirmQuit);

	BC_Index GetDocumentCount() const;
	virtual BR_CDocument* GetActiveDocument() const;

	virtual BR_Boolean OutOfMemory(MemoryError severity);

	virtual BR_Boolean Quit();

	virtual void RemoveDocument(const BR_CDocument& aDocument);

protected:
	BR_CDocumentDirector(BR_CBureaucrat* itsSupervisor);

	BR_SETCLASSNAME(BR_CDocumentDirector);

private:
	BC_TUnboundedCollection<BR_CDocument *, BC_CUnmanaged> fDocumentList;
};



//----------------------------------------------------------------------------------------
// BR_CDocumentDirector::GetDocumentCount
//----------------------------------------------------------------------------------------

inline BC_Index BR_CDocumentDirector::GetDocumentCount() const
{
	return fDocumentList.Length();
}

#endif

