#if !defined(BRDLGDIR_H) && !defined(__BEDRC__)
#define BRDLGDIR_H
//========================================================================================
//
//     File:		BRDlgDir.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	August 16, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDIRECT_H
#include "BRDirect.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

//------------------------------------------------------------------------
// Forward declarations
//------------------------------------------------------------------------

class BR_CView;
class BR_CModule;
class BR_CWindow;
class BR_CButton;
class BR_CDialogBox;
//template<class tCharacter>
//class BR_TString;

//==========================================================================
//	CLASS BR_CDialogDirector
//==========================================================================

class BR_CDialogDirector : public BR_CDirector
{
public:
	BR_CDialogDirector(BR_CBureaucrat* itsSupervisor,
					   BR_CView* itsEnclosure,
					   const BR_CModule &itsModule,
					   BR_ResourceId resId);
	BR_CDialogDirector(BR_CBureaucrat* Supervisor);
	virtual~ BR_CDialogDirector();

	virtual void CenterDialog();			// Center the dialog within its enclosure.

	virtual BR_Boolean DoCommand(CommandId commandId,
								 BR_CObject* itsNotifier,
								 BR_Boolean callSupervisor = TRUE);
								 
	BR_CDialogBox* GetDialogBox() const;
	virtual BR_CDialogDirector* GetDialogDirector() const;
	CommandId GetResult() const;

	virtual void ShowDialog();
	
	virtual void UpdateMenus(BR_CMenuBar& theMenuBar,
							 BR_Boolean callSupervisor);

protected:
	virtual BR_Boolean CloseDialog(BR_Boolean isCommandOK);
	
	BR_CView* GetDialogEnclosure() const;
	
	BR_CDialogBox* LoadDialog(const BR_CModule &resModule,
							  BR_ResourceId resId);
							  
	void SetDialogEnclosure(BR_CView* itsEnclosure);

	void SetResult(CommandId commandId);

private:
	void InitDialogDirector(BR_CBureaucrat* itsSupervisor,
							BR_CView* itsEnclosure);

	// The following two methods are not implemented in BRDlgDir.c because we don't want
	// the default Copy constructor and default assigment to be generated by the compiler.
	BR_CDialogDirector(const BR_CDialogDirector& itsSupervisor);
	BR_CDialogDirector& operator=(const BR_CDialogDirector& itsSupervisor);

	BR_CView* fDialogEnclosure;					// our enclosure
	CommandId fResultCommand;						// result: cmdOk|cmdCancel

#ifdef BR_BUILD_MAC
public:
	virtual BR_Boolean DoCommandKey(Key theKey,
									KeyModifiers theModifiers,
									unsigned short repeatCount,
									BR_Boolean callSupervisor = TRUE);
#endif

#ifdef BR_BUILD_WIN
public:
	virtual BR_Boolean DoMnemonic(BR_StringCharacter mnemonic);
	HWND GetPreviousHandle() const;
	void SetFocusOnPreviousDialog();

private:
	BR_CView* FindNextView(const BR_CView& label) const;
	BR_CButton* FindButton(const BR_CView& view,
						   const BR_TString<BR_Char>& strMnemonic) const;

	HWND fPreviousHandle;						// HWND of the parent Dialog, NULL if none

#endif

	BR_SETCLASSNAME(BR_CDialogDirector);
};

//----------------------------------------------------------------------------------------
// BR_CDialogDirector::GetDialogBox
//----------------------------------------------------------------------------------------

inline BR_CDialogBox* BR_CDialogDirector::GetDialogBox() const
{
	return (BR_CDialogBox*)GetWindow(0);
}

//----------------------------------------------------------------------------------------
// BR_CDialogDirector::GetResult
//----------------------------------------------------------------------------------------

inline BR_CBureaucrat::CommandId BR_CDialogDirector::GetResult() const
{
	return fResultCommand;
}

//----------------------------------------------------------------------------------------
// BR_CDialogDirector::GetDialogEnclosure
//----------------------------------------------------------------------------------------

inline BR_CView* BR_CDialogDirector::GetDialogEnclosure() const
{
	return fDialogEnclosure;
}


//----------------------------------------------------------------------------------------
// BR_CDialogDirector::SetDialogEnclosure
//----------------------------------------------------------------------------------------

inline void BR_CDialogDirector::SetDialogEnclosure(BR_CView* itsEnclosure)
{
	fDialogEnclosure = itsEnclosure;
}


//----------------------------------------------------------------------------------------
// BR_CDialogDirector::SetResult
//----------------------------------------------------------------------------------------

inline void BR_CDialogDirector::SetResult(CommandId commandId)
{
	fResultCommand = commandId;
}

#ifdef BR_BUILD_WIN

//----------------------------------------------------------------------------------------
// BR_CDialogDirector::GetPreviousHandle
//----------------------------------------------------------------------------------------

inline HWND BR_CDialogDirector::GetPreviousHandle() const
{
	return fPreviousHandle;
}
#endif

#endif
