#if !defined(BRDLGBOX_H) && !defined(__BEDRC__)
#define BRDLGBOX_H
//========================================================================================
//
//     File:			BRDlgBox.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	February 12, 1990
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRWINDOW_H
#include "BRWindow.h"
#endif

#ifndef BRFONT_H
#include "BRFont.h"
#endif

#ifndef BRAPPLIC_H
#include "BRApplic.h"
#endif

#ifndef BRGRCOMM_H
#include "BRGrComm.h"
#endif

//========================================================================================
// BR_SDialogBoxRes
//========================================================================================

struct BR_SDialogBoxRes : BR_SWinResource
{
    BR_CFont::FontId 	fFontId;
    BR_CFont::FontSize 	fFontSize;
    BR_CFont::FontStyle fFontStyle;
};

//========================================================================================
//	CLASS BR_CDialogBox
//========================================================================================

class BR_CDialogBox : public BR_CWindow
{
public:
	BR_CDialogBox(BR_CView* enclosure,
				  BR_CBureaucrat* supervisor,
				  const BR_CModule& module,
				  BR_SResource& resource);

	BR_CDialogBox(BR_CView* enclosure,
				  BR_CBureaucrat* supervisor,
				  BR_Distance width,
				  BR_Distance height,
				  BR_Coordinate x,
				  BR_Coordinate y,
				  ViewStyle style,
				  ViewUnits units,
				  const BR_CFont& dialogFont);

	virtual~ BR_CDialogBox();

	virtual BR_CDialogBox* GetDialogBox() const;
	BR_CFont* GetFont();

	virtual BR_Boolean Close();
	virtual void Show(BR_Boolean show = TRUE);

protected:

	virtual void BedGetResolutionFactors(ViewUnits inUnit,
										 ViewUnits outUnit,
										 unsigned short& xNum,
										 unsigned short& xDen,
										 unsigned short& yNum,
										 unsigned short& yDen) const;	// ?INTERNAL?

	void InitFontSize();	// ?INTERNAL?

private:
	BR_CFont fDialogFont;

	unsigned short fFontWidth;	// ?INTERNAL?				// For use by BedScreenToViewUnits and BedViewToScreenUnits
	unsigned short fFontHeight;	// ?INTERNAL?

//--------------------------------------------------------------------------
// Macintosh
//--------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	void SetEventLoopContext(BR_CEventLoopContext* theEventLoopContext);

private:
	BR_CEventLoopContext* fEventLoopContext;	// If Modal dialog, the event loop. NULL for modeless.
	// Uses to notify the loop when the dialog is dismissed
#endif

//--------------------------------------------------------------------------
// Windows
//--------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	LONG Dispatch(WORD wMessage,
				  WORD wParam,
				  LONG lParam,
				  BR_Boolean callDefaultProc = TRUE);

#endif

	BR_SETCLASSNAME(BR_CDialogBox);
};

//----------------------------------------------------------------------------------------
//	BR_CDialogBox::GetFont
//----------------------------------------------------------------------------------------
inline BR_CFont* BR_CDialogBox::GetFont()
{ 
	return &fDialogFont;
}

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CDialogBox::SetEventLoopContext
//----------------------------------------------------------------------------------------
inline void BR_CDialogBox::SetEventLoopContext(BR_CEventLoopContext* theEventLoopContext)
{
	fEventLoopContext = theEventLoopContext;
}
#endif

#endif
