#if !defined(BRCONTRO_H) && !defined(__BEDRC__)
#define BRCONTRO_H
//========================================================================================
//
//     File:			BRContro.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 31, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED --
//     RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRCONTRO_K
#include "BRContro.k"
#endif

#ifndef   BRVIEW_H
#include "BRView.h"
#endif

#ifdef BR_BUILD_MAC
#include "Controls.h"
#endif


//========================================================================================
// STRUCT BR_SControlResource
//========================================================================================

struct BR_SControlResource : BR_SViewResource
{
    BR_CView::ViewStyle fControlStyle;
};


//========================================================================================
//	CLASS BR_CControl
//
// Comment: An abstract class for implementing controls. The four descendant classes,
// BR_CButton, BR_CEditControl, BR_CListBox, and BR_CScrollBar implement the standard controls.
//
//========================================================================================

class BR_CControl : public BR_CView
{
public:
	// Initialization methods for BR_CControl
	void InitControl(BR_CView* enclosure,
					 BR_CBureaucrat* supervisor,
					 BR_Distance width,
					 BR_Distance height,
					 BR_Coordinate x,
					 BR_Coordinate y,
					 ViewSizing horizontalSizing,
					 ViewSizing verticalSizing,
					 const BR_CColor &backgroundColor,
					 ViewId id);

	void InitControl(BR_CView* enclosure,
					 BR_CBureaucrat* supervisor,
					 const BR_CModule& module,
					 BR_SResource& viewResource);

	void SetValidWhenLoseFocus(BR_Boolean state);
	BR_Boolean ValidWhenLoseFocus() const;
	void SetForceValidationWhenGetFocus(BR_Boolean state);
	BR_Boolean ForceValidationWhenGetFocus() const;

	virtual BR_Boolean IsValidView();
	virtual void InvalidViewFeedback();

	virtual BR_Boolean RelinquishFocus();		// ?INTERNAL?

	// Inherited virtual methods
	virtual void DoClick(const BR_CPoint& point,
						 KeyModifiers keyFlags);
	virtual BR_Boolean IsValidToChangeFocus();

	virtual BR_Boolean DoCommand(CommandId commandId,
								 BR_CObject* notifier,
								 BR_Boolean callSupervisor = TRUE);
	virtual void Flash();

protected:
	BR_CControl();

	BR_CControl(BR_CView* enclosure,
				BR_CBureaucrat* supervisor,
				BR_Distance width,
				BR_Distance height,
				BR_Coordinate x,
				BR_Coordinate y,
				ViewSizing horizontalSizing,
				ViewSizing verticalSizing,
				const BR_CColor &backgroundColor,
				ViewId id);

	BR_CControl(BR_CView* enclosure,
				BR_CBureaucrat* supervisor,
				const BR_CModule& module,
				BR_SResource& viewResource);

	virtual~ BR_CControl();

private:
	void InitDataMembers();
	
private:
	BR_Boolean fValidWhenLoseFocus:1;			// TRUE - this Control must be valid when lose focus
	BR_Boolean fForceValidationWhenGetFocus:1;	// TRUE - current focus view must be valid when this one gets the focus
#ifdef BR_BUILD_MAC
public:
	virtual void BeInEnclosure(BR_CView *itsEnclosure);

	virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& area);
	
	virtual void SetText(const BR_TString<BR_Char>& Text, BR_Boolean redraw=TRUE);
	virtual unsigned long GetText(BR_TString<BR_Char>& Buffer) const;
	virtual unsigned long GetTextLength() const;
	
	virtual void SetMacCtlRect(const Rect& rectangle);
	virtual BR_Boolean SetFocus();
	virtual void SetEnable(BR_Boolean state);
	virtual void Show(BR_Boolean show = TRUE);

	virtual void BeginDrawing(BR_CDrawStateData& drawStateData);
	virtual void ResumeDrawing(const BR_CDrawStateData& drawStateData);

public:											// ?INTERNAL? this whole section.
	ControlHandle GetMacControl() const;
	BR_Boolean SetCtlVisibility(BR_Boolean visible) const;

	void GetCtlMargin(BR_CRectangle& margin) const;
	void SetCtlMargin(const BR_CRectangle& newMargin);

	short GetCtlHilite() const;
	void SetCtlHilite(short newHilite,
					  BR_Boolean redraw) const;
	long GetCtlValue() const;
	void SetCtlValue(long newValue,
					 BR_Boolean redraw) const;

	void GetCtlRange(long& minVal,
					 long& maxVal) const;
	void SetCtlRange(long aMin,
					 long aMax,
					 BR_Boolean redraw) const;

protected:										// ?INTERNAL? this whole section.
	BR_Boolean MakeMacControl(short procId,
							  short min = 0,
							  short max = 0,
							  short val = 0);
	void SetMacControl(ControlHandle controlHandle);

	virtual void DoCtlIndicatorDragged(long delta);
	virtual void DoCtlAction(short partCode);
	virtual void DoGoodClick(short partCode);
	void BedMacAddControl(ControlHandle controlHandle);
	void BedMacRemoveControl(ControlHandle controlHandle);

	void CalcMacCtlRect(RECT& ctlRect);

	static pascal void CtlActionProc(ControlHandle controlHandle,
									 short partCode);
private:
	ControlHandle 	fMacControl;				// if subclass uses Control Mgr
	BR_CRectangle 	fControlMargin;				// margin for Control Mgr control's rectangle
	BR_PlatformWindow	fMacControlOwner;			// the window owning this control
#endif

#ifdef BR_BUILD_WIN
public:
	virtual BR_CFont* SetViewFont(BR_CFont* newFont);
	virtual long Dispatch(WORD message,
						  WORD wParam,
						  long lParam,
						  BR_Boolean callDefaultProc = TRUE);// ?INTERNAL?

protected:
	unsigned short fWinMouseEventCount;

	virtual void DoDoubleClick(const BR_CPoint& point,
							   KeyModifiers keyFlags);
	virtual void DoMouseUp(const BR_CPoint& point,
						   KeyModifiers keyFlags);
	virtual void MouseMove(const BR_CPoint& point,
						   KeyModifiers keyFlags);

	virtual BR_CPoint GetPanePt(const long lParam) const;// ?INTERNAL?

	void BedWinEndMouseEvent();

private:
	BR_Boolean fCanDelete:1;					// can we delete the handle?
	BR_CWallPaper* fWallPaper;					// the wallpaper we're using
#endif

	BR_SETCLASSNAME(BR_CControl);
};

//----------------------------------------------------------------------------------------
// BR_CControl::SetValidWhenLoseFocus
//----------------------------------------------------------------------------------------

inline void BR_CControl::SetValidWhenLoseFocus(BR_Boolean state)
{
	fValidWhenLoseFocus = state;
}


//----------------------------------------------------------------------------------------
// BR_CControl::ValidWhenLoseFocus
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CControl::ValidWhenLoseFocus() const
{
	return fValidWhenLoseFocus;
}


//----------------------------------------------------------------------------------------
// BR_CControl::SetForceValidationWhenGetFocus
//----------------------------------------------------------------------------------------

inline void BR_CControl::SetForceValidationWhenGetFocus(BR_Boolean state)
{
	fForceValidationWhenGetFocus = state;
}


//----------------------------------------------------------------------------------------
// BR_CControl::ForceValidationWhenGetFocus
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CControl::ForceValidationWhenGetFocus() const
{
	return fForceValidationWhenGetFocus;
}


//----------------------------------------------------------------------------------------
// BR_CControl::GetMacControl
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
inline ControlHandle BR_CControl::GetMacControl() const
{
	return fMacControl;
}
#endif

//----------------------------------------------------------------------------------------
// BR_CControl::SetMacControl
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
inline void BR_CControl::SetMacControl(ControlHandle controlHandle)
{
	fMacControl = controlHandle;
}
#endif

//----------------------------------------------------------------------------------------
// BR_CControl::GetCtlMargin
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
inline void BR_CControl::GetCtlMargin(BR_CRectangle& margin) const
{
	margin = fControlMargin;
}
#endif

#ifdef BR_BUILD_MAC
//========================================================================================
// CLASS BR_CMacControlDrawingContext
//
// Comment: BR_CMacControlDrawingContext is used to automatically set up a control to draw
// in a pane's current port, establish whether the control can redraw and then restore the
// control to the previous port when drawing is complete.
//========================================================================================
class BR_CMacControlDrawingContext : public _BR_CAutoDestructObject
{
public:
	BR_CMacControlDrawingContext(const BR_CControl* control,
								 GrafPtr port,
								 BR_Boolean allowRedraw);
	virtual~ BR_CMacControlDrawingContext();

private:
	const BR_CControl* fControl;
	BR_Boolean fSavedVis;
	GrafPtr fSavedPort;
};

#endif

#endif
