#if !defined(BRCOLOR_H) && !defined(__BEDRC__)
#define BRCOLOR_H
//========================================================================================
//
//     File:			BRColor.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	December 17, 1991
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRCOLOR_K
#include "BRColor.k"
#endif

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__QUICKDRAW__)
#include <QuickDraw.h>
#endif

#if defined(BR_BUILD_WIN) && !defined(_INC_WINDOWS)
#include <windows.h>
#endif


//========================================================================================
//	Forward class declaration
//========================================================================================

class BR_CStream;


//========================================================================================
// CLASS BR_CColor
//========================================================================================

class BR_CColor : public BR_CObject
{
public:
#ifdef BR_BUILD_MAC
	typedef unsigned long int RGBValue;
#endif

#ifdef BR_BUILD_WIN
	typedef COLORREF RGBValue;
#endif

public:
	BR_CColor();
	BR_CColor(RGBValue rgb);
	BR_CColor(const BR_CColor& clr);
	BR_CColor(BR_CStream& stream);

	virtual~ BR_CColor();

	RGBValue GetRGB() const;

	// Comparison operators
	// Note that these only compare the significant part of each component

	BR_Boolean operator==(const BR_CColor& clr) const;
	BR_Boolean operator==(RGBValue rgb) const;
	BR_Boolean operator!=(const BR_CColor& clr) const;
	BR_Boolean operator!=(RGBValue rgb) const;

	// Assignment operator
	BR_CColor& operator=(RGBValue rgb);
	BR_CColor& operator=(const BR_CColor& color);

	operator RGBValue() const;

	// Arithmetic, by another color

	BR_CColor operator+(const BR_CColor& color) const;
	BR_CColor operator-(const BR_CColor& color) const;
	BR_CColor operator*(const BR_CColor& color) const;
	BR_CColor operator/(const BR_CColor& color) const;

	BR_CColor& operator+=(const BR_CColor& color);
	BR_CColor& operator-=(const BR_CColor& color);
	BR_CColor& operator*=(const BR_CColor& color);
	BR_CColor& operator/=(const BR_CColor& color);

	// Arithmetic by a scalar

	BR_CColor operator+(unsigned short a) const;
	BR_CColor operator-(unsigned short a) const;
	BR_CColor operator*(unsigned short a) const;
	BR_CColor operator/(unsigned short a) const;

	BR_CColor& operator+=(unsigned short a);
	BR_CColor& operator-=(unsigned short a);
	BR_CColor& operator*=(unsigned short a);
	BR_CColor& operator/=(unsigned short a);

	void Grayer();

	BR_Boolean IsDarkerThan(const BR_CColor& color) const;
	BR_Boolean IsLighterThan(const BR_CColor& color) const;

	BR_Boolean IsSystemColor();

	// Stream I/O methods

	friend BR_CStream& operator>>(BR_CStream& stream,
								  BR_CColor& color);
	friend BR_CStream& operator<<(BR_CStream& stream,
								  BR_CColor& color);
	void ReadFrom(BR_CStream& stream);
	void WriteTo(BR_CStream& stream);

	BR_Boolean IsTransparent() const;

private:

	void UpdateIfSystemColor();
	unsigned long Brightness() const;

	void SyncRGBValue();						// update internal RGBValue to match components
	void SyncRGBComponents();					// update internal RGB components

	RGBValue fRGBValue;							// The RGB Value of this instance's color
	unsigned short fRed;						// stone-agers don't correctly capitalize their first names
	unsigned short fGreen;
	unsigned short fBlue;

#ifdef BR_BUILD_MAC
public:
	BR_CColor(const RGBColor rgb);
	void GetMacColor(RGBColor& c) const;
#endif

	BR_SETCLASSNAME(BR_CColor);
};


//========================================================================================
//	INLINES BR_CColor
//========================================================================================

//----------------------------------------------------------------------------------------
//	BR_CColor::IsSystemColor
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CColor::IsSystemColor()
{
	return (fRGBValue < 0);
}

//----------------------------------------------------------------------------------------
//	BR_CColor::IsTransparent
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CColor::IsTransparent() const
{
	return fRGBValue == kRGBTransparent;
}

//----------------------------------------------------------------------------------------
//	BR_CColor::operator==
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CColor::operator==(const BR_CColor& clr) const
{
	return GetRGB() == clr.GetRGB();
}

//----------------------------------------------------------------------------------------
//	BR_CColor::operator==
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CColor::operator==(RGBValue rgb) const
{
	return (fRGBValue == rgb) || (GetRGB() == rgb);
}

//----------------------------------------------------------------------------------------
//	BR_CColor::operator!=
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CColor::operator!=(const BR_CColor& clr) const
{
	return !(*this == clr);
}

//----------------------------------------------------------------------------------------
//	BR_CColor::operator!=
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CColor::operator!=(RGBValue rgb) const
{
	return !(*this == rgb);
}

//----------------------------------------------------------------------------------------
//	BR_CColor::operator RGBValue
//----------------------------------------------------------------------------------------
inline BR_CColor::operator RGBValue(void) const
{
	return GetRGB();
}

#endif


