#if !defined(BRBUREAU_H) && !defined(__BEDRC__)
#define BRBUREAU_H

//========================================================================================
//
//     File:		BRBureau.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	August 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CAction;
class BR_CMenuBar;
class BR_CApplication;
class BR_CSystem;
class BR_CDirector;
class BR_CDialogDirector;
class BR_CDocument;
class BR_CHelp;
class BR_CMessanger;


//========================================================================================
// CLASS BR_CError
//========================================================================================

class BR_CError : public BR_CObject
{
public:
	typedef unsigned short int ErrorId;
	
	~BR_CError();
	BR_CError(ErrorId itsErrorId);
	virtual ErrorId GetId() const;

private:
	ErrorId fErrorId;

	BR_SETCLASSNAME(BR_CError);
};


//========================================================================================
// CLASS BR_CBureaucrat
//========================================================================================

class BR_CBureaucrat : public BR_CObject
{
public:
	typedef unsigned short int CommandId;
	typedef unsigned short int Key;
	typedef long int KeyModifiers;

	virtual BR_CApplication* GetApplication() const;
	virtual BR_CDialogDirector* GetDialogDirector() const;
	virtual BR_CDirector* GetDirector() const;
	virtual BR_CDocument* GetDocument();
	virtual BR_CHelp* GetHelp() const;
//	virtual CommandId GetId() const;
	BR_CBureaucrat* GetSupervisor() const;
	virtual BR_CSystem* GetSystem() const;

	virtual BR_Boolean DoCommand(CommandId itsCommandId,
								 BR_CObject* itsNotifier,
								 BR_Boolean callSupervisor = TRUE);

	virtual BR_Boolean DoError(BR_CObject* itsSender,
								   BR_CError* theError,
								   BR_Boolean& errorCorrected,
								   BR_Boolean callSupervisor = TRUE);

	virtual BR_Boolean DoKey(Key theKey,
							 unsigned short repeatCount,
							 BR_Boolean callSupervisor = TRUE);

	virtual BR_Boolean DoKeyDown(Key thekey,
								 unsigned short repeatCount,
								 BR_Boolean callSupervisor = TRUE);

	virtual BR_Boolean DoKeyUp(Key thekey,
							   unsigned short repeatCount,
							   BR_Boolean callSupervisor = TRUE);

	virtual BR_Boolean DoMessage(BR_CMessanger &messanger);

	virtual void Notify(BR_CAction* theAction,
							BR_Boolean callSupervisor = TRUE);

	void SetSupervisor(BR_CBureaucrat* itsSupervisor);

	virtual void UpdateMenus(BR_CMenuBar& theMenuBar,
							 BR_Boolean callSupervisor = TRUE);

	virtual void SetEnable(BR_Boolean state);
		// Enables based on 'state'

	virtual BR_Boolean IsEnabled() const;
		// Returns the enabled state.
	
protected:
	BR_CBureaucrat();
	BR_CBureaucrat(BR_CBureaucrat* theSupervisor);
	virtual~ BR_CBureaucrat();
	void InitBureaucrat(BR_CBureaucrat* theSupervisor);

private:
	BR_CBureaucrat* fSupervisor;
	BR_Boolean fInitialized:1;
	BR_Boolean fEnabled:1;						// enabled flag

#ifdef BR_BUILD_MAC
public:
	virtual BR_Boolean DoCommandKey(Key theKey,
									KeyModifiers theModifiers,
									unsigned short repeatCount,
									BR_Boolean callSupervisor = TRUE);
#endif

	BR_SETCLASSNAME(BR_CBureaucrat);
};


//----------------------------------------------------------------------------------------
// BR_CBureaucrat::SetSupervisor
//----------------------------------------------------------------------------------------

inline void BR_CBureaucrat::SetSupervisor(BR_CBureaucrat* itsSupervisor)
{
	fSupervisor = itsSupervisor;
}

//----------------------------------------------------------------------------------------
// BR_CBureaucrat::GetSupervisor
//----------------------------------------------------------------------------------------

inline BR_CBureaucrat* BR_CBureaucrat::GetSupervisor() const
{
	return fSupervisor;
}

#endif
