#if !defined(BRBFM_H) && !defined(__BEDRC__)
#define BRBFM_H
//========================================================================================
//
//     File:		BRBFM.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	7/30/92
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#if defined(BR_BUILD_MAC) && !defined(BRMACWIN_H)
#include "BRMacWin.h"
#endif

#ifndef BREXCEPT_H
#include "BRExcept.h"
#endif

#ifndef BRBEDEXC_H
#include "BRBedExc.h"
#endif

#ifndef BRFILE_H
#include "BRFile.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(FILES_H)
#include <Files.h>
#endif


//========================================================================================
// Forward class declarations
//========================================================================================
class BR_CFileSpecification;




//========================================================================================
//	BR_XFile
//
//	Base class for file exceptions.
//========================================================================================
class BR_XFile : public BR_XBedException
{
public:
	_BR_EXCEPTION_DEFINE(BR_XFile);
	
	typedef unsigned long int NumberOfBytes;
	
protected:
	BR_XFile();
	BR_XFile(const BR_CFileSpecification* aDataFile);
	BR_XFile(const BR_CFileSpecification* aDataFile,
			 const PlatformError fError);
	virtual ~BR_XFile();
	
	const BR_CFileSpecification *GetDataFile() const;

private:
	const BR_CFileSpecification	*fDataFile;
};




//========================================================================================
//	BR_XEndOfFile
//========================================================================================

class BR_XEndOfFile : public BR_XFile
{
public:	
	BR_CFile::FileMarkPosition GetAttemptedPosition();
	_BR_EXCEPTION_DEFINE(BR_XFile);
	
protected:
	BR_XEndOfFile(const BR_CFileSpecification* aDataFile,
				  const BR_CFile::FileMarkPosition attemptedPosition);
	virtual ~BR_XEndOfFile();
	
private:
	const BR_CFile::FileMarkPosition fAttemptedPosition;
};




//========================================================================================
//	BR_XAttemptToPositionBeforeStartOfFile
//========================================================================================

class BR_XAttemptToPositionBeforeStartOfFile : public BR_XEndOfFile
{
public:
	BR_XAttemptToPositionBeforeStartOfFile(const BR_CFileSpecification* aDataFile,
										   const long attemptedPosition);
	virtual ~BR_XAttemptToPositionBeforeStartOfFile();
	
	_BR_EXCEPTION_DEFINE(BR_XAttemptToPositionBeforeStartOfFile);
};




//========================================================================================
//	BR_XAttemptToPositionAfterEndOfFile
//========================================================================================

class BR_XAttemptToPositionAfterEndOfFile : public BR_XEndOfFile
{
public:
	BR_XAttemptToPositionAfterEndOfFile(const BR_CFileSpecification* aDataFile,
										const long attemptedPosition);
	virtual ~BR_XAttemptToPositionAfterEndOfFile();
	
	_BR_EXCEPTION_DEFINE(BR_XAttemptToPositionAfterEndOfFile);
};


//========================================================================================
//	BR_XAttemptToReadAfterEndOfFile
//========================================================================================

class BR_XAttemptToReadAfterEndOfFile : public BR_XEndOfFile
{
public:
	BR_XAttemptToReadAfterEndOfFile(const BR_CFileSpecification* aDataFile,
									const long attemptedPosition,
									const NumberOfBytes amountRead);
	virtual ~BR_XAttemptToReadAfterEndOfFile();
	NumberOfBytes GetAmountRead();
	
	_BR_EXCEPTION_DEFINE(BR_XAttemptToReadAfterEndOfFile);

private:
	const NumberOfBytes fAmountRead;
};


//========================================================================================
//	BR_XPathNotFound
//========================================================================================

class BR_XPathNotFound : public BR_XFile
{
public:
	BR_XPathNotFound(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XPathNotFound();
	
	_BR_EXCEPTION_DEFINE(BR_XPathNotFound);
};


//========================================================================================
//	BR_XFileNotFound
//========================================================================================

class BR_XFileNotFound : public BR_XPathNotFound
{
public:
	BR_XFileNotFound(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XFileNotFound();
	
	_BR_EXCEPTION_DEFINE(BR_XFileNotFound);
};


//========================================================================================
//	BR_XDirectoryNotFound
//========================================================================================

class BR_XDirectoryNotFound : public BR_XPathNotFound
{
public:
	BR_XDirectoryNotFound(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XDirectoryNotFound();
	
	_BR_EXCEPTION_DEFINE(BR_XDirectoryNotFound);
};


//========================================================================================
//	BR_XVolumeNotFound
//========================================================================================

class BR_XVolumeNotFound : public BR_XPathNotFound
{
public:
	BR_XVolumeNotFound(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XVolumeNotFound();
	
	_BR_EXCEPTION_DEFINE(BR_XVolumeNotFound);
};


//========================================================================================
//	BR_XTooManyFilesOpen
//========================================================================================

class BR_XTooManyFilesOpen : public BR_XFile
{
public:
	BR_XTooManyFilesOpen(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XTooManyFilesOpen();
	
	_BR_EXCEPTION_DEFINE(BR_XTooManyFilesOpen);
};


//========================================================================================
//	BR_XAccessDenied
//========================================================================================

class BR_XAccessDenied : public BR_XFile
{
public:
	BR_XAccessDenied(const BR_CFileSpecification* aDataFile,
					 const BR_CAccessPermission::Access accessMode,
					 const BR_CAccessPermission::Deny shareMode);
	BR_CAccessPermission::Access GetAttemptedAccessMode();
	BR_CAccessPermission::Deny GetAttemptedShareMode();

	virtual ~BR_XAccessDenied();
	
	_BR_EXCEPTION_DEFINE(BR_XAccessDenied);
	
private:
	const BR_CAccessPermission::Access fAccessMode;
	const BR_CAccessPermission::Deny fShareMode;

};


//========================================================================================
//	BR_XFileAlreadyOpenForWriting
//========================================================================================

class BR_XFileAlreadyOpenForWriting : public BR_XAccessDenied
{
public:
	BR_XFileAlreadyOpenForWriting(const BR_CFileSpecification* aDataFile,
								  const BR_CAccessPermission::Access accessMode,
								  const BR_CAccessPermission::Deny shareMode);

	virtual ~BR_XFileAlreadyOpenForWriting();
	
	_BR_EXCEPTION_DEFINE(BR_XFileAlreadyOpenForWriting);
};


//========================================================================================
//	BR_XCantOpenLockedFileForWriting
//========================================================================================

class BR_XCantOpenLockedFileForWriting : public BR_XAccessDenied
{
public:
	BR_XCantOpenLockedFileForWriting(const BR_CFileSpecification* aDataFile,
									 const BR_CAccessPermission::Access accessMode,
									 const BR_CAccessPermission::Deny shareMode);

	virtual ~BR_XCantOpenLockedFileForWriting();
	
	_BR_EXCEPTION_DEFINE(BR_XCantOpenLockedFileForWriting);
};


//========================================================================================
//	BR_XUserDoesNotHaveAccessPrivilege
//========================================================================================

class BR_XUserDoesNotHaveAccessPrivilege : public BR_XAccessDenied
{
public:
	BR_XUserDoesNotHaveAccessPrivilege(const BR_CFileSpecification* aDataFile,
									   const BR_CAccessPermission::Access accessMode,
									   const BR_CAccessPermission::Deny shareMode);

	virtual~ BR_XUserDoesNotHaveAccessPrivilege();

	_BR_EXCEPTION_DEFINE(BR_XUserDoesNotHaveAccessPrivilege);
};


//========================================================================================
//	BR_XCantDenyOthersAccessBecauseOfExistingAccess
//========================================================================================

class BR_XCantDenyOthersAccessBecauseOfExistingAccess : public BR_XAccessDenied
{
public:
	BR_XCantDenyOthersAccessBecauseOfExistingAccess(const BR_CFileSpecification* aDataFile,
													const BR_CAccessPermission::Access accessMode,
													const BR_CAccessPermission::Deny shareMode);

	virtual ~BR_XCantDenyOthersAccessBecauseOfExistingAccess();
	
	_BR_EXCEPTION_DEFINE(BR_XCantDenyOthersAccessBecauseOfExistingAccess);
};


//========================================================================================
//	BR_XIOFailed
//========================================================================================

class BR_XIOFailed : public BR_XFile
{
public:
	BR_XIOFailed(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XIOFailed();
	
	_BR_EXCEPTION_DEFINE(BR_XIOFailed);
};


//========================================================================================
//	BR_XFileClosed
//========================================================================================

class BR_XFileClosed : public BR_XFile
{
public:
	BR_XFileClosed(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XFileClosed();
	
	_BR_EXCEPTION_DEFINE(BR_XFileClosed);
};


//========================================================================================
//	BR_XCantCloseAlreadyClosedFile
//========================================================================================

class BR_XCantCloseAlreadyClosedFile : public BR_XFileClosed
{
public:
	BR_XCantCloseAlreadyClosedFile(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XCantCloseAlreadyClosedFile();
	
	_BR_EXCEPTION_DEFINE(BR_XCantCloseAlreadyClosedFile);
};


//========================================================================================
//	BR_XCantResizeClosedFile
//========================================================================================

class BR_XCantResizeClosedFile : public BR_XFileClosed
{
public:
	BR_XCantResizeClosedFile(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XCantResizeClosedFile();
	
	_BR_EXCEPTION_DEFINE(BR_XCantResizeClosedFile);
};



//========================================================================================
//	BR_XCantReadClosedFile
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XCantReadClosedFile : public BR_XFileClosed
{
public:
	BR_XCantReadClosedFile(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XCantReadClosedFile();
	
	_BR_EXCEPTION_DEFINE(BR_XCantReadClosedFile);
};



//========================================================================================
//	BR_XFileNotOpenForWriting
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XFileNotOpenForWriting : public BR_XFile
{
public:
	BR_XFileNotOpenForWriting(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XFileNotOpenForWriting();
	
	_BR_EXCEPTION_DEFINE(BR_XFileNotOpenForWriting);
};



//========================================================================================
//	BR_XNoDefaultVolume
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XNoDefaultVolume : public BR_XFile
{
public:
	BR_XNoDefaultVolume(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XNoDefaultVolume();
	
	_BR_EXCEPTION_DEFINE(BR_XNoDefaultVolume);
};



//========================================================================================
//	BR_XDiskFull
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XDiskFull : public BR_XFile
{
public:
	BR_XDiskFull(const BR_CFileSpecification* aDataFile,
				 NumberOfBytes desiredSize);
	virtual ~BR_XDiskFull();

	NumberOfBytes GetDesiredSize();
	
	_BR_EXCEPTION_DEFINE(BR_XDiskFull);

private:
	NumberOfBytes fDesiredSize;
};



//========================================================================================
//	BR_XBadParameter
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XBadParameter : public BR_XFile
{
public:
	BR_XBadParameter(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XBadParameter();
	
	_BR_EXCEPTION_DEFINE(BR_XBadParameter);
};



//========================================================================================
//	BR_XBadAccessMode
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XBadAccessMode : public BR_XBadParameter
{
public:
	BR_XBadAccessMode(const BR_CFileSpecification* aDataFile);
	virtual ~BR_XBadAccessMode();
	
	_BR_EXCEPTION_DEFINE(BR_XBadAccessMode);
};



//========================================================================================
//	BR_XBadFileSpecification
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XBadFileSpecification : public BR_XBadParameter
{
public:
	BR_XBadFileSpecification(const BR_CFileSpecification* aDataFile);
	virtual~ BR_XBadFileSpecification();
	
	_BR_EXCEPTION_DEFINE(BR_XBadFileSpecification);
};



//========================================================================================
//	BR_XBadFileName
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XBadFileName : public BR_XBadParameter
{
public:
	BR_XBadFileName(const BR_CFileSpecification* aDataFile);
	virtual~ BR_XBadFileName();
	
	_BR_EXCEPTION_DEFINE(BR_XBadFileName);
};



//========================================================================================
//	BR_XBadPosition
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XBadPosition : public BR_XBadParameter
{
public:
	BR_XBadPosition(const BR_CFileSpecification* aDataFile);
	virtual~ BR_XBadPosition();
	
	_BR_EXCEPTION_DEFINE(BR_XBadPosition);
};



//========================================================================================
//	BR_XUnknownFile
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XUnknownFile : public BR_XFile
{
public:
	BR_XUnknownFile(const BR_CFileSpecification* aDataFile,
					const PlatformError fError);
	virtual~ BR_XUnknownFile();
	
	_BR_EXCEPTION_DEFINE(BR_XUnknownFile);
};



//========================================================================================
//	BR_XLocked
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XLocked : public BR_XFile
{
public:
	BR_XLocked(const BR_CFileSpecification* aDataFile);
	virtual~ BR_XLocked();
	
	_BR_EXCEPTION_DEFINE(BR_XLocked);
};



//========================================================================================
//	BR_XFileLocked
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XFileLocked : public BR_XLocked
{
public:
	BR_XFileLocked(const BR_CFileSpecification* aDataFile);
	virtual~ BR_XFileLocked();
	
	_BR_EXCEPTION_DEFINE(BR_XFileLocked);
};



//========================================================================================
//	BR_XVolumeLocked
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XVolumeLocked : public BR_XLocked
{
public:
	BR_XVolumeLocked(const BR_CFileSpecification* aDataFile);
	virtual~ BR_XVolumeLocked();
	
	_BR_EXCEPTION_DEFINE(BR_XVolumeLocked);
};



//========================================================================================
//	BR_XHardwareLocked
//
//	<comments>
//	<Invariants>
//========================================================================================
class BR_XHardwareLocked : public BR_XLocked
{
public:
	BR_XHardwareLocked(const BR_CFileSpecification* aDataFile);
	virtual~ BR_XHardwareLocked();
	
	_BR_EXCEPTION_DEFINE(BR_XHardwareLocked);
};








//----------------------------------------------------------------------------------------
//	BR_XFile::GetDataFile
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline const BR_CFileSpecification* BR_XFile::GetDataFile() const
{
	return fDataFile;
}


//----------------------------------------------------------------------------------------
//	BR_XAttemptToPositionBeforeStartOfFile::BR_XAttemptToPositionBeforeStartOfFile
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XAttemptToPositionBeforeStartOfFile::BR_XAttemptToPositionBeforeStartOfFile
												(const BR_CFileSpecification* aDataFile,
												 const long attemptedPosition) :
	BR_XEndOfFile(aDataFile, attemptedPosition)
{
}


//----------------------------------------------------------------------------------------
//	BR_XAttemptToReadAfterEndOfFile::BR_XAttemptToReadAfterEndOfFile
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XAttemptToReadAfterEndOfFile::BR_XAttemptToReadAfterEndOfFile
												(const BR_CFileSpecification* aDataFile,
												 const long attemptedPosition,
												 const unsigned long amountRead) :
	BR_XEndOfFile(aDataFile, attemptedPosition),
	fAmountRead(amountRead)
{
}

//----------------------------------------------------------------------------------------
//	BR_XAttemptToReadAfterEndOfFile::GetAmountRead
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XFile::NumberOfBytes BR_XAttemptToReadAfterEndOfFile::GetAmountRead()
{
	return fAmountRead;
}

//----------------------------------------------------------------------------------------
//	BR_XAttemptToPositionAfterEndOfFile::BR_XAttemptToPositionAfterEndOfFile
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XAttemptToPositionAfterEndOfFile::BR_XAttemptToPositionAfterEndOfFile
												(const BR_CFileSpecification* aDataFile,
												 const long attemptedPosition) :
	BR_XEndOfFile(aDataFile, attemptedPosition)
{
}


//----------------------------------------------------------------------------------------
//	BR_XFileNotFound::BR_XFileNotFound
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XFileNotFound::BR_XFileNotFound(const BR_CFileSpecification * aDataFile) :
	BR_XPathNotFound(aDataFile)
{
}



//----------------------------------------------------------------------------------------
//	BR_XDirectoryNotFound::BR_XDirectoryNotFound
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XDirectoryNotFound::BR_XDirectoryNotFound(const BR_CFileSpecification * aDataFile) :
	BR_XPathNotFound(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XVolumeNotFound::BR_XVolumeNotFound
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XVolumeNotFound::BR_XVolumeNotFound(const BR_CFileSpecification * aDataFile) :
	BR_XPathNotFound(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XTooManyFilesOpen::BR_XTooManyFilesOpen
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XTooManyFilesOpen::BR_XTooManyFilesOpen(const BR_CFileSpecification * aDataFile) :
	BR_XFile(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XFileAlreadyOpenForWriting::BR_XFileAlreadyOpenForWriting
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XFileAlreadyOpenForWriting::BR_XFileAlreadyOpenForWriting
												(const BR_CFileSpecification* aDataFile,
												 const BR_CAccessPermission::Access accessMode,
												 const BR_CAccessPermission::Deny shareMode) :
	BR_XAccessDenied(aDataFile, accessMode, shareMode)
{
}


//----------------------------------------------------------------------------------------
//	BR_XCantOpenLockedFileForWriting::BR_XCantOpenLockedFileForWriting
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XCantOpenLockedFileForWriting::BR_XCantOpenLockedFileForWriting
												(const BR_CFileSpecification* aDataFile,
												 const BR_CAccessPermission::Access accessMode,
												 const BR_CAccessPermission::Deny shareMode) :
	BR_XAccessDenied(aDataFile, accessMode, shareMode)
{
}


//----------------------------------------------------------------------------------------
//	BR_XUserDoesNotHaveAccessPrivilege::BR_XUserDoesNotHaveAccessPrivilege
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XUserDoesNotHaveAccessPrivilege::BR_XUserDoesNotHaveAccessPrivilege
												(const BR_CFileSpecification* aDataFile,
												 const BR_CAccessPermission::Access accessMode,
												 const BR_CAccessPermission::Deny shareMode) :
	BR_XAccessDenied(aDataFile, accessMode, shareMode)
{
}

//----------------------------------------------------------------------------------------
//  BR_XCantDenyOthersAccessBecauseOfExistingAccess::
//     BR_XCantDenyOthersAccessBecauseOfExistingAccess
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XCantDenyOthersAccessBecauseOfExistingAccess::
 	   BR_XCantDenyOthersAccessBecauseOfExistingAccess(const BR_CFileSpecification* aDataFile,
													   const BR_CAccessPermission::Access accessMode,
													   const BR_CAccessPermission::Deny shareMode) :
	BR_XAccessDenied(aDataFile, accessMode, shareMode)
{
}

//----------------------------------------------------------------------------------------
//	BR_XIOFailed::BR_XIOFailed
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XIOFailed::BR_XIOFailed(const BR_CFileSpecification* aDataFile) :
	BR_XFile(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XCantCloseAlreadyClosedFile::BR_XCantCloseAlreadyClosedFile
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XCantCloseAlreadyClosedFile::BR_XCantCloseAlreadyClosedFile
													(const BR_CFileSpecification* aDataFile) :
	BR_XFileClosed(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XCantResizeClosedFile::BR_XCantResizeClosedFile
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XCantResizeClosedFile::BR_XCantResizeClosedFile(const BR_CFileSpecification* aDataFile) :
	BR_XFileClosed(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XCantReadClosedFile::BR_XCantReadClosedFile
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XCantReadClosedFile::BR_XCantReadClosedFile(const BR_CFileSpecification* aDataFile) :
	BR_XFileClosed(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XFileNotOpenForWriting::BR_XFileNotOpenForWriting
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XFileNotOpenForWriting::BR_XFileNotOpenForWriting(const BR_CFileSpecification* aDataFile) :
	BR_XFile(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XNoDefaultVolume::BR_XNoDefaultVolume
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XNoDefaultVolume::BR_XNoDefaultVolume(const BR_CFileSpecification* aDataFile) :
	BR_XFile(aDataFile)
{
}

//----------------------------------------------------------------------------------------
//	BR_XDiskFull::BR_XDiskFull
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XDiskFull::BR_XDiskFull(const BR_CFileSpecification* aDataFile,
								  BR_XFile::NumberOfBytes desiredSize) :
	BR_XFile(aDataFile),
	fDesiredSize(desiredSize)
{
}

//----------------------------------------------------------------------------------------
//	BR_XDiskFull::GetDesiredSize
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XFile::NumberOfBytes BR_XDiskFull::GetDesiredSize()
{
	return fDesiredSize;
}


//----------------------------------------------------------------------------------------
//	BR_XBadAccessMode::BR_XBadAccessMode
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XBadAccessMode::BR_XBadAccessMode(const BR_CFileSpecification* aDataFile) :
	BR_XBadParameter(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XBadFileSpecification::BR_XBadFileSpecification
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XBadFileSpecification::BR_XBadFileSpecification(const BR_CFileSpecification* aDataFile) :
	BR_XBadParameter(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XBadFileName::BR_XBadFileName
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XBadFileName::BR_XBadFileName(const BR_CFileSpecification* aDataFile) :
	BR_XBadParameter(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XBadPosition::BR_XBadPosition
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XBadPosition::BR_XBadPosition(const BR_CFileSpecification* aDataFile) :
	BR_XBadParameter(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XUnknownFile::BR_XUnknownFile
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XUnknownFile::BR_XUnknownFile(const BR_CFileSpecification* aDataFile,
										const PlatformError fError) :
	BR_XFile(aDataFile, fError)
{
}


//----------------------------------------------------------------------------------------
//	BR_XFileLocked::BR_XFileLocked
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XFileLocked::BR_XFileLocked(const BR_CFileSpecification* aDataFile) :
	BR_XLocked(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XVolumeLocked::BR_XVolumeLocked
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XVolumeLocked::BR_XVolumeLocked(const BR_CFileSpecification* aDataFile) :
	BR_XLocked(aDataFile)
{
}


//----------------------------------------------------------------------------------------
//	BR_XHardwareLocked::BR_XHardwareLocked
//
//	<comments>
//	<Preconditions>
//	<Postconditions>
//----------------------------------------------------------------------------------------
inline BR_XHardwareLocked::BR_XHardwareLocked(const BR_CFileSpecification* aDataFile) :
	BR_XLocked(aDataFile)
{
}


#endif
