#if !defined(BRAPPDES_H) && !defined(__BEDRC__)
#define BRAPPDES_H

//========================================================================================
//
//     File:			BRAppDes.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/8/91
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include "BRView.h"
#endif

#ifndef BRCANVAS_H
#include "BRCanvas.h"
#endif

#ifndef BRPULLDM_H
#include "BRPullDM.h"
#endif

#if defined(BR_BUILD_WIN) && !defined(BRICON_H)
#include "BRIcon.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__WINDOWS__)
#include <Windows.h>
#endif

#if defined(BR_BUILD_MAC) && !defined(__MENUS__)
#include <Menus.h>
#endif

//========================================================================================
//	Forward class declarations
//========================================================================================

class BR_CView;									// declare classes we use
class BR_CUrgentChore;
class BR_CAppDesktop;

//========================================================================================
//	CLASS BR_CDesktopCanvas
//========================================================================================

class BR_CDesktopCanvas : public BR_CCanvas
{
public:
	BR_CDesktopCanvas(BR_CAppDesktop *theDesktop);
	virtual 		~BR_CDesktopCanvas();
	
	virtual void 	GetDrawArea(BR_CRectangle& area) const;
	
//----------------------------------------------------------------------------------------
//	Windows
// ---------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	virtual HDC 	BedWinCreateDC(BR_CView& view);
	virtual void 	BedWinDeleteDC(BR_CView& view,
						  			HDC hDC);
#endif

//----------------------------------------------------------------------------------------
//	Macintosh
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	virtual GrafPtr	BedMacGetGrafPort() const;
	virtual void 		BedMacViewToCanvasOwner(BR_CPoint &aPoint) const;
#endif

	BR_SETCLASSNAME(BR_CDesktopCanvas);
};

//========================================================================================
//	CLASS BR_CAppDesktop
//========================================================================================

class BR_CAppDesktop : public BR_CView
{
public:
	typedef unsigned short int DesktopPane;
	
	enum DesktopPaneConstants
	{
		kTopPane = 0,
		kLeftPane = 1,
		kBottomPane = 2,
		kRightPane = 3
	};

public:
	BR_CAppDesktop(BR_CApplication* application);
	virtual~ BR_CAppDesktop();

	virtual BR_Boolean 		Close();
	virtual void 				Show(BR_Boolean show = TRUE);
	virtual BR_Boolean 		IsVisible() const;

	// Menu methods
	virtual BR_CMenuBar* 		SetMenuBar(BR_CMenuBar* newMenuBar);
	BR_CMenuBar* 				GetMenuBar() const;
	void 						DrawMenuBar();
	BR_CHelpMenu* 				GetHelpMenu() const;
	
	virtual void 				GetFrame(BR_CRectangle& rect) const;
	
	virtual BR_CAppDesktop* 	GetAppDesktop() const;
	virtual BR_CWindow* 		GetActiveWindow() const;

	// Sizing and Size info methods
	BR_Boolean IsZoomed() const;
	BR_Boolean IsRestored() const;
	void Zoom();
	void Restore();

	void SetCapture(BR_CView* pane);
	BR_CView* GetCapture() const;

	void InitMenuBar();							// ?INTERNAL?

protected:
	void BedSetMenuBar(BR_CMenuBar* newMenuBar);
	virtual BR_CCanvas *BedLookForDrawingCanvas() const;
	virtual BR_CView	*BedGetViewWithCanvas() const;

private:
	BR_CDesktopCanvas *fCanvas;
	BR_CMenuBar* fMenuBar;						// our menu bar
	BR_CHelpMenu* fHelpMenu;					// the Help menu
	BR_CView* 	fCaptureView;

	BR_CMenuBar* MakeMenuBar();

	//----------------------------------------------------------------
	//	macintosh
	//----------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	virtual void DispatchClick(const BR_CPoint& cursorPos,
							   EventRecord& macEvent);
	virtual void DispatchCursor(const BR_CPoint& where,
								RgnHandle mouseRgn);
	BR_CPullDownMenu* GetAppleMenu() const;
	void DoChore(BR_CUrgentChore* chore);
	void DoInMenuBar(BR_CApplication& theApp,
					 		const EventRecord& macEvent);
	void InitAppDesktop(BR_CApplication* supervisor);// ?INTERNAL?
	#endif

	//----------------------------------------------------------------
	//	windows
	//----------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	// Focus-handling methods
	LONG Dispatch(WORD wMessage,
				  WORD wParam,
				  LONG lParam,
				  BR_Boolean callDefaultProc = TRUE);
	LONG DoDefaultProc(WORD wMessage,
					   WORD wParam,
					   LONG lParam);
	void DoDefCommand(WORD commandId);
	
	virtual BR_Boolean 	IsInMenuBar(BR_PlatformMenuHandle menuHandle) const;
	virtual void 			UpdateSpecialMenu(BR_CPullDownMenu& menu);
	virtual BR_Boolean 	IsValidMessage(HANDLE hAccel,
									  		MSG& msg);

	virtual void BedWinAdjustDesktopClientArea();

	// Notification
	virtual void 			SubviewHasBeenShown(BR_CView &subview,
									 BR_Boolean newState);
	virtual void 			DoChore(BR_CUrgentChore* chore);
	void 					InitAppDesktop(BR_CApplication* application,
											BedWinClassId classId);	// ?INTERNAL?
											
	void					BedWinCacheInterior();
	virtual void			GetInterior(BR_CRectangle& interior) const;
	
	virtual void 			RemoveSubview(BR_CView& subview);

	// For use by desktop panes
	void 					SetDesktopPane(DesktopPane whichPane, BR_CView* pane);
	BR_CView* 				GetDesktopPane(DesktopPane whichPane);

protected:
	BR_CAppDesktop(BR_CApplication* application,
				   BedWinClassId classId);		// ?INTERNAL?

private:
	BR_CDocumentIcon 	fApplicationIcon;					// icon when iconified
	BR_CPoint			fFrameSize;							// to test if the interior has changed
	BR_CRectangle	 	fInterior;							// we need to cache the interior
	
	void PaintIcon();

private:
	BR_CView* fDesktopPane[4];

#endif

	BR_SETCLASSNAME(BR_CAppDesktop);
};


//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::GetMenuBar
//----------------------------------------------------------------------------------------
inline BR_CMenuBar* BR_CAppDesktop::GetMenuBar() const
{
	return fMenuBar;
}

//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::GetHelpMenu
//----------------------------------------------------------------------------------------
inline BR_CHelpMenu* BR_CAppDesktop::GetHelpMenu() const
{
	return fHelpMenu;
}

//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::BedSetMenuBar
//----------------------------------------------------------------------------------------
inline void BR_CAppDesktop::BedSetMenuBar(BR_CMenuBar* newMenuBar)
{
	fMenuBar = newMenuBar;
}

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::GetLeftPane
//----------------------------------------------------------------------------------------
inline BR_CView* BR_CAppDesktop::GetDesktopPane(DesktopPane whichPane)
{
	return fDesktopPane[whichPane];
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::GetAppleMenu
//----------------------------------------------------------------------------------------
inline BR_CPullDownMenu* BR_CAppDesktop::GetAppleMenu() const
{
	return GetMenuBar()->GetSubMenu(0);
}
#endif

//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::GetCapture
//----------------------------------------------------------------------------------------
inline BR_CView* BR_CAppDesktop::GetCapture() const
{
	return fCaptureView;
}

//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::IsZoomed
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CAppDesktop::IsZoomed() const
{
#ifdef BR_BUILD_WIN
	return (::IsZoomed(GetPlatformWindow()));
#endif

#ifdef BR_BUILD_MAC
	return FALSE;
#endif
}

//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::IsRestored
//	Checks if application Desktop has normal size
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CAppDesktop::IsRestored() const
{
#ifdef BR_BUILD_WIN
	return (!(IsZoomed() || ::IsIconic(GetPlatformWindow())));
#endif

#ifdef BR_BUILD_MAC
	return (TRUE);
#endif
}

//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::Zoom
//	Zooms application Desktop to full screen
//----------------------------------------------------------------------------------------
inline void BR_CAppDesktop::Zoom()
{
#ifdef BR_BUILD_WIN
	::SendMessage(GetPlatformWindow(), WM_SYSCOMMAND, SC_MAXIMIZE, LONG(0));
#endif
}

//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::Restore
//	Restores application Desktop to its normal size
//----------------------------------------------------------------------------------------
inline void BR_CAppDesktop::Restore()
{
#ifdef BR_BUILD_WIN
	::SendMessage(GetPlatformWindow(), WM_SYSCOMMAND, SC_RESTORE, LONG(0));
#endif
}

//----------------------------------------------------------------------------------------
//	BR_CAppDesktop::DrawMenuBar
//	Update the menu bar
//----------------------------------------------------------------------------------------
inline void BR_CAppDesktop::DrawMenuBar()
{
#ifdef BR_BUILD_MAC
	::DrawMenuBar();
#endif

#ifdef BR_BUILD_WIN
	::DrawMenuBar(GetPlatformWindow());
#endif
}

#endif


