#if !defined(BRALERT_H) && !defined(__BEDRC__)
#define BRALERT_H

//========================================================================================
//
//     File:			BRAlert.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	March 2, 1991
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#if defined(BR_BUILD_MAC) && !defined(BRMACWIN_H)
#include "BRMacWin.h"
#endif

#if defined(BR_BUILD_WIN) && !defined(_INC_WINDOWS)
#include <Windows.h>
#endif

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================
//template<class tCharacter>
//class BR_TString;

//========================================================================================
// Type definitions
//========================================================================================
typedef short BR_MesssageBoxCommandID;

//========================================================================================
// Constants
//========================================================================================
enum BR_MessageBoxFlags
{
	kOKButton = MB_OK,
	kOKCancelButtons = MB_OKCANCEL,
	kAbortRetryIgnoreButtons = MB_ABORTRETRYIGNORE,
	kYesNoCancelButtons = MB_YESNOCANCEL,
	kYesNoButtons = MB_YESNO,
	kRetryCancelButtons = MB_RETRYCANCEL,
	
	kHandIcon = MB_ICONHAND,
	kQuestionMarkIcon = MB_ICONQUESTION,
	kExclamationIcon = MB_ICONEXCLAMATION,
	kAsteriskIcon = MB_ICONASTERISK,
	kInformationIcon = MB_ICONASTERISK,
	kStopIcon = MB_ICONHAND,
	
	kDefaultButton = MB_DEFBUTTON1,
	kApplicationModal = MB_APPLMODAL,
	kSystemModal = MB_SYSTEMMODAL,
	kTaskModal = MB_TASKMODAL
};

enum BR_MesssageBoxCommandIDConstants
{
	kOKButtonPressed = IDOK ,
	kCancelButtonPressed = IDCANCEL,
	kAbortButtonPressed = IDABORT ,
	kRetryButtonPressed = IDRETRY,
	kIgnoreButtonPressed = IDIGNORE,
	kYesButtonPressed = IDYES,
	kNoButtonPressed = IDNO
};

//========================================================================================
// Global procedure declarations
//========================================================================================



//----------------------------------------------------------------------------------------
//	DoMessage
//----------------------------------------------------------------------------------------
BR_MesssageBoxCommandID DoMessage(const BR_TString<BR_Char>& message,
								  const BR_TString<BR_Char>& caption,
								  const BR_MessageBoxFlags dialogFlags);


//----------------------------------------------------------------------------------------
//	DoNote
//----------------------------------------------------------------------------------------
inline BR_MesssageBoxCommandID DoNote(const BR_TString<BR_Char>& Message,
									  const BR_TString<BR_Char>& Caption,
									  const BR_MessageBoxFlags buttonType = kOKButton)
{
	return (DoMessage(Message, Caption, kInformationIcon | buttonType));
}




//----------------------------------------------------------------------------------------
//	DoAlert
//----------------------------------------------------------------------------------------
inline BR_MesssageBoxCommandID DoAlert(const BR_TString<BR_Char>& Message,
									   const BR_TString<BR_Char>& Caption,
									   const BR_MessageBoxFlags buttonType = kOKButton)
{
	return (DoMessage(Message, Caption, kExclamationIcon | buttonType));
}




//----------------------------------------------------------------------------------------
//	DoQuestion
//----------------------------------------------------------------------------------------
inline BR_MesssageBoxCommandID DoQuestion(const BR_TString<BR_Char>& Message,
										  const BR_TString<BR_Char>& Caption,
										  const BR_MessageBoxFlags buttonType = kYesNoButtons)
{
	return (DoMessage(Message, Caption, kQuestionMarkIcon | buttonType));
}




//----------------------------------------------------------------------------------------
//	DoCaution
//----------------------------------------------------------------------------------------
inline BR_MesssageBoxCommandID DoCaution(const BR_TString<BR_Char>& Message,
										 const BR_TString<BR_Char>& Caption,
										 const BR_MessageBoxFlags buttonType = kOKButton)
{
	return (DoMessage(Message, Caption, kQuestionMarkIcon | buttonType));
}




//----------------------------------------------------------------------------------------
//	DoError
//----------------------------------------------------------------------------------------
inline BR_MesssageBoxCommandID DoError(const BR_TString<BR_Char>& Message,
									   const BR_TString<BR_Char>& Caption,
									   const BR_MessageBoxFlags buttonType = kOKButton)
{
	return (DoMessage(Message, Caption, kHandIcon | buttonType));
}

#endif
