#if !defined(BRADORN1_H) && !defined(__BEDRC__)
#define BRADORN1_H
//========================================================================================
//
//     File:			BRAdorn1.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	2/25/93
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BCTYPE_H
#include "BCType.h"
#endif

#ifndef BRADORN_K
#include "BRAdorn.k"
#endif

#ifndef BRPEN_H
#include "BRPen.h"
#endif

#ifndef BRGRHELP_H
#include "BRGrHelp.h"
#endif

#ifndef BRFONT_H
#include "BRFont.h"
#endif

#ifndef BRCOLOR_H
#include "BRColor.h"
#endif

#ifndef BRRESOUR_H
#include "BRResour.h"
#endif

#ifndef BRRECT_H
#include "BRRect.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

//========================================================================================
//	Forward class declarations
//========================================================================================

class BR_CView;
class BR_CIcon;
class BR_CBitmap;
class BR_CBedAdornerHandle;

//========================================================================================
//	class BR_CAdorner
//========================================================================================

class BR_CAdorner : public BR_CObject
{
	friend class BR_CBedAdornerHandle;
	
public:
	typedef BC_Index AdornPriority;
	typedef short int AdornerId;
	
public:	
	virtual				~BR_CAdorner();

	// ----- Drawing method
	void 					BedDrawAdorner(BR_CView *view, const BR_CRectangle &area);
	
	virtual void 			Draw(BR_CView *view, const BR_CRectangle &area) = 0;
	virtual void 			PreDraw(BR_CView *view);
	virtual void 			PostDraw(BR_CView *view);

	// ----- Adorner identifier
	AdornerId 				GetAdornerId();

	// ----- Notification
	virtual void 			AddedToView(BR_CView* itsView);
	virtual void 			RemovedFromView(BR_CView* itsView);

	// ----- Reference count
	short					GetReferenceCount();
	
	// ----- Auto Delete
	BR_Boolean				IsAutoDelete();
	void					SetAutoDelete(BR_Boolean state);
	
	// ----- Sharing
	BR_Boolean				IsSharedAdorner();	
	static BR_CAdorner*	GetSharedAdorner(const BR_CCharString255 &className);
	
protected:
	BR_CAdorner(AdornerId adornerId, 
				BR_Boolean autoDelete,
				BR_Boolean sharedAdorner);
	BR_CAdorner(const BR_CModule& module,
				BR_SResource& resource);
				
	void 		InitAdorner(AdornerId adornerId, 
							BR_Boolean autoDelete,
							BR_Boolean sharedAdorner);

	BR_SETCLASSNAME(BR_CAdorner);

private:
	void			SetReferenceCount(short newCount);
	void			LinkToSharedAdornerList();
	void			DeleteOfSharedAdornerList();
	
private:
	AdornerId 				fAdornerId;
	BR_Boolean				fAutoDelete;
	short					fReferenceCount;
	BR_Boolean				fSharedAdorner;
	BR_CAdorner				*fNextSharedAdorner;
	static BR_CAdorner		*gFirstSharedAdorner;
};

//----------------------------------------------------------------------------------------
// BR_CAdorner::GetAdornerId
//----------------------------------------------------------------------------------------
inline BR_CAdorner::AdornerId BR_CAdorner::GetAdornerId()
{
	return fAdornerId;
}

//----------------------------------------------------------------------------------------
// BR_CAdorner::IsAutoDelete
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CAdorner::IsAutoDelete()
{
	return fAutoDelete;
}

//----------------------------------------------------------------------------------------
// BR_CAdorner::SetAutoDelete
//----------------------------------------------------------------------------------------
inline void BR_CAdorner::SetAutoDelete(BR_Boolean state)
{
	fAutoDelete = state;
}

//----------------------------------------------------------------------------------------
// BR_CAdorner::GetReferenceCount
//----------------------------------------------------------------------------------------
inline short BR_CAdorner::GetReferenceCount()
{
	return fReferenceCount;
}

//----------------------------------------------------------------------------------------
// BR_CAdorner::SetAutoDelete
//----------------------------------------------------------------------------------------
inline void BR_CAdorner::SetReferenceCount(short newCount)
{
	fReferenceCount = newCount;
}

//----------------------------------------------------------------------------------------
// BR_CAdorner::IsSharedAdorner
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CAdorner::IsSharedAdorner()
{
	return fSharedAdorner;
}

//========================================================================================
//	structure BR_SAdornerResource
//========================================================================================

struct BR_SAdornerResource : BR_SResource
{
	BR_CAdorner::AdornerId 		fAdornerId;
	BR_CAdorner::AdornPriority 	fPriority;
	BR_Boolean					fAutoDelete;
	BR_Boolean					fSharedAdorner;
};

//========================================================================================
//	class BR_CBedAdornerHandle
//========================================================================================

class BR_CBedAdornerHandle : public BR_CObject
{
public:
	BR_CBedAdornerHandle(BR_CAdorner *adorner, BR_CAdorner::AdornPriority priority);
	virtual ~BR_CBedAdornerHandle();
	
	BR_CAdorner::AdornPriority					GetPriority() const;
	BR_CAdorner*								GetAdorner() const;
	
	static BR_CAdorner::AdornPriority AdornPriorityOrderFunction
												(const BR_CBedAdornerHandle* &adorner);
	
private:
	BR_CAdorner					*fAdorner;
	BR_CAdorner::AdornPriority	fPriority;	
};

//----------------------------------------------------------------------------------------
// BR_CBedAdornerHandle::GetPriority
//----------------------------------------------------------------------------------------
inline BR_CAdorner::AdornPriority BR_CBedAdornerHandle::GetPriority() const
{
	return fPriority;
}

//----------------------------------------------------------------------------------------
// BR_CBedAdornerHandle::IsAutoDelete
//----------------------------------------------------------------------------------------
inline BR_CAdorner* BR_CBedAdornerHandle::GetAdorner() const
{
	return fAdorner;
}

//========================================================================================
//	class BR_CBaseShapeAdorner
//========================================================================================

class BR_CBaseShapeAdorner : public BR_CAdorner
{
public:
	virtual void PreDraw(BR_CView *view);
	virtual void PostDraw(BR_CView *view);

	virtual ~BR_CBaseShapeAdorner();

protected:
	BR_CBaseShapeAdorner(AdornerId adornerId,
						BR_Boolean autoDelete,
						BR_Boolean sharedAdorner,
					 	BR_CPen::PenThickness penThickness,
					 	const BR_CColor& penColor,
					 	BR_CPen::PenStyle penStyle);

	BR_CBaseShapeAdorner(const BR_CModule& module,
					 	BR_SResource& resource);

private:
	BR_CDeferredPen fPen;
	BR_CGraphicsToolSelector fPenSelector;		// Use this to Select the default pen in PreDraw

	BR_SETCLASSNAME(BR_CBaseShapeAdorner);
};

//========================================================================================
//	structure BR_SBaseShapeAdornerRes
//========================================================================================

struct BR_SBaseShapeAdornerRes : BR_SAdornerResource
{
	BR_CPen::PenThickness 	fPenThickness;
	BR_CColor::RGBValue 	fPenColor;
	BR_CPen::PenStyle 		fPenStyle;
};

//========================================================================================
//	class BR_CLineAdorner
//========================================================================================

class BR_CLineAdorner : public BR_CBaseShapeAdorner
{
public:
	BR_CLineAdorner(AdornerId adornerId,
					BR_Boolean autoDelete,
					BR_Boolean sharedAdorner,
					const BR_CPoint& startPoint,
					const BR_CPoint& endPoint,
					BR_CPen::PenThickness penThickness,
					const BR_CColor& penColor,
					BR_CPen::PenStyle penStyle);

	BR_CLineAdorner(const BR_CModule& module,
					BR_SResource& resource);

	virtual~ BR_CLineAdorner();

	virtual void Draw(BR_CView *view, const BR_CRectangle &area);

	BR_SETCLASSNAME(BR_CLineAdorner);

private:
	BR_CPoint fStartPoint;
	BR_CPoint fEndPoint;
};

//========================================================================================
//	structure BR_SLineAdornerRes
//========================================================================================

struct BR_SLineAdornerRes : BR_SBaseShapeAdornerRes
{
	BR_SPoint fStartPoint;
	BR_SPoint fEndPoint;
};

//========================================================================================
//	class BR_CTextAdorner
//========================================================================================
// BR_CTextAdorner can't be shared

class BR_CTextAdorner : public BR_CAdorner
{
public:
	BR_CTextAdorner(AdornerId adornerId,
					BR_Boolean autoDelete,
					BR_Coordinate x,
					BR_Coordinate y,
					const BR_TString<BR_Char>& text,
					const BR_CModule& module,
					BR_CFont::FontId fontId,
					BR_CFont::FontSize fontSize,
					BR_CFont::FontStyle fontStyle,
					BR_Boolean addToViewList = TRUE);// This param is for internal use

	BR_CTextAdorner(AdornerId adornerId,
					BR_Boolean autoDelete,
					const BR_CRectangle& bounds,
					const BR_TString<BR_Char>& text,
					const BR_CModule& module,
					BR_CFont::FontId fontId,
					BR_CFont::FontSize fontSize,
					BR_CFont::FontStyle fontStyle,
					BR_DrawTextFlags drawTextFlags);

	BR_CTextAdorner(const BR_CModule& module,
					BR_SResource& resource);

	virtual~ BR_CTextAdorner();

	unsigned short GetFontHeight(BR_CView *view);
	void SetColor(const BR_CColor& textColor, BR_Boolean redraw);

	virtual void 			AddedToView(BR_CView* itsView);
	virtual void 			RemovedFromView(BR_CView* itsView);

	void GetTextBounds(BR_CRectangle& bounds) const;
	virtual void SetTextBounds(const BR_CRectangle& bounds, BR_Boolean redraw);

	virtual void 		SetText(const BR_TString<BR_Char>& text, BR_Boolean redraw);
	unsigned long 	GetText(BR_TString<BR_Char>& buffer) const;

	// Inherited virtual methods
	virtual void 		Draw(BR_CView *view, const BR_CRectangle &area);
	virtual void 		PreDraw(BR_CView *view);
	virtual void 		PostDraw(BR_CView *view);

	BR_Boolean			IsGrayedOut() const;
	void				GrayOutText(BR_Boolean state, BR_Boolean redraw);

private:
	BR_CFont* 			BedGetFont(BR_CView *view);

	void InitFont(const BR_CModule& module,
				  BR_CFont::FontId fontId,
				  BR_CFont::FontSize fontSize,
				  BR_CFont::FontStyle fontStyle);
				  
private:
	BR_CRectangle 		fTextBounds;
	BR_CDynamicCharString fText;
	BR_CColor 			fTextColor;				// Text color, overrides whatever pMyFont's is
	BR_DrawTextFlags 	fDrawTextFlags;			// Text justification fFlags (only valid if frame rectangle was specified)
	BR_Boolean			fGrayedOut;
	
	BR_CGraphicsToolSelector fFontSelector;		// Used to Select the default font
	BR_CFont* 			fFont;
	BR_Boolean 			fDeleteFont;					// TRUE if we created a font and not used some other object's
	
	BR_CView			*fEnclosure;
	
	BR_SETCLASSNAME(BR_CTextAdorner);
};

//----------------------------------------------------------------------------------------
// BR_CTextAdorner::IsGrayedOut
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CTextAdorner::IsGrayedOut() const
{
	return fGrayedOut;
}

//----------------------------------------------------------------------------------------
// BR_CTextAdorner::GetTextBounds
//----------------------------------------------------------------------------------------
inline void BR_CTextAdorner::GetTextBounds(BR_CRectangle& bounds) const
{
	bounds = fTextBounds;
}

//========================================================================================
//	structure BR_STextAdornerRes
//========================================================================================

struct BR_STextAdornerRes : BR_SAdornerResource
{
	BR_SRectangle fFrame;
	char fText[128];
	BR_CFont::FontId fFontId;
	BR_CFont::FontSize fFontSize;
	BR_CFont::FontStyle fFontStyle;
	BR_CColor::RGBValue fRGBTextColor;
	BR_DrawTextFlags fDrawTextFlags;
};

//========================================================================================
//	class BR_CImageAdorner
//========================================================================================

class BR_CImageAdorner : public BR_CAdorner
{
protected:
	BR_CImageAdorner(AdornerId adornerId,
					BR_Boolean autoDelete,
					BR_Boolean sharedAdorner,
					 const BR_CPoint& location);
	BR_CImageAdorner(const BR_CModule& module,
					 BR_SResource& resource);

	virtual~ BR_CImageAdorner();

	void GetLocation(BR_CPoint& location) const;

private:
	BR_CPoint fLocation;

	BR_SETCLASSNAME(BR_CImageAdorner);
};

//----------------------------------------------------------------------------------------
// BR_CImageAdorner::GetLocation
//----------------------------------------------------------------------------------------
inline void BR_CImageAdorner::GetLocation(BR_CPoint& location) const
{
	location = fLocation;
}

//========================================================================================
//	structure BR_SIconAdornerRes
//========================================================================================

struct BR_SImageAdornerRes : BR_SAdornerResource
{
	BR_SPoint fLocation;
};


//========================================================================================
//	class BR_CIconAdorner
//========================================================================================

class BR_CIconAdorner : public BR_CImageAdorner
{
public:
	BR_CIconAdorner(const BR_CModule& module,
					BR_SResource& resource);

	// Note that if you use this ctor, the icon will be deleted
	// by the dtor, so you should SetIcon(NULL) if the icon is
	// shared.
	BR_CIconAdorner(AdornerId adornerId,
					BR_Boolean autoDelete,
					BR_Boolean sharedAdorner,
					const BR_CPoint& location,
					BR_CIcon* icon);

	virtual~ BR_CIconAdorner();

	virtual void Draw(BR_CView *view, const BR_CRectangle &area);

	// Note that a BR_CIconAdorner owns its icon and dtor will delete it!
	virtual void SetIcon(BR_CIcon* icon);
	BR_CIcon* GetIcon() const;

private:
	BR_CIcon* fIcon;

	BR_SETCLASSNAME(BR_CIconAdorner);
};

//----------------------------------------------------------------------------------------
//	BR_CIconAdorner::GetIcon
//----------------------------------------------------------------------------------------
inline BR_CIcon* BR_CIconAdorner::GetIcon() const
{
	return fIcon;
}

//========================================================================================
//	structure BR_SIconAdornerRes
//========================================================================================

struct BR_SIconAdornerRes : BR_SImageAdornerRes
{
	BR_ResourceId fIconResourceId;
};

//========================================================================================
//	class BR_CBitmapAdorner
//========================================================================================

class BR_CBitmapAdorner : public BR_CImageAdorner
{
public:
	BR_CBitmapAdorner(const BR_CModule& module,
					  BR_SResource& resource);

	BR_CBitmapAdorner(AdornerId adornerId,
					  BR_Boolean autoDelete,
					  BR_Boolean sharedAdorner,
					  BR_Coordinate x,
					  BR_Coordinate y,
					  const BR_CModule& module,
					  BR_ResourceId resourceId);

	// Note that if you use this ctor, the bitmap will be deleted by the dtor
	BR_CBitmapAdorner(AdornerId adornerId,
					  BR_Boolean autoDelete,
					  BR_Boolean sharedAdorner,
					  BR_Coordinate x,
					  BR_Coordinate y,
					  BR_CBitmap* bitmap);

	virtual~ BR_CBitmapAdorner();

	virtual void Draw(BR_CView *view, const BR_CRectangle &area);

	// Note that a BR_CBitmapAdorner owns its bitmap and dtor will delete it!
	BR_CBitmap* GetBitmap() const;
	virtual void SetBitmap(BR_CBitmap* bitmap);

	BR_SETCLASSNAME(BR_CBitmapAdorner);

private:
	BR_CBitmap* fBitmap;
};

//----------------------------------------------------------------------------------------
//	BR_CBitmapAdorner::GetBitmap
//----------------------------------------------------------------------------------------
inline BR_CBitmap* BR_CBitmapAdorner::GetBitmap() const
{
	return fBitmap;
}

//========================================================================================
//	structure BR_SBitmapAdornerRes
//========================================================================================

struct BR_SBitmapAdornerRes : BR_SImageAdornerRes
{
	BR_ResourceId fBitmapResourceId;
};

#endif


