typedef DWORD           HMSC;    // Message Store Handle.
typedef DWORD           HCBC;    // Browse Context Handle.
typedef HCBC __far *    PHCBC;
typedef unsigned long   ULONG;
typedef DWORD           OID;     // Object Id.

#define oidIPMHierarchy    ((OID) 0x4D504981)   // Folder Hierarchy
#define oidInbox           ((OID) 0x626E4982)   // Inb
#define oidOutbox          ((OID) 0x74754F82)   // Out
#define oidWastebasket     ((OID) 0x74735782)   // Wst
#define oidSentMail        ((OID) 0x74685382)   // Snt


#define fwOpenNull            ((WORD) 0x0000)
#define hcbcNull              ((HCBC) 0x0000)

#define ecNone                0
#define ecMemory              0x0400
#define ecPoidNotFound        0x1001
#define ecMessageNotFound     0x1008
#define ecFolderNotFound      0x1009
#define ecElementEOD          0x1014
#define ecContainerEOD        0x1005   // end of browse context reached

typedef struct _dtr
{
   int      yr;
   int      mon;
   int      day;
   int      hr;
   int      mn;
   int      sec;
   int      dow;     // day of week: 0=Sun, 1=Mon, etc.
} DTR, __far *PDTR;

typedef struct
{
   HMSC        hmsc;
   BYTE        bReserved[0x30];
   WORD        wVersion;         //     This is a PARAMBLK.
   WORD        wCommand;         //
   LPSTR       szDllCmdLine;     //
   LPSTR       szMessageIDList;  //
   WORD        wMessageIDCount;  //
   HWND        hwndMail;         //
   HANDLE      hinstMail;        //
   LPSTR       szHelpPath;       //
   ULONG       hlp;              //
}
SMAPIBLK, __far *PSMAPIBLK;

#define  PsmapiblkFromPparamblk(pparamblk)        \
	 ((PSMAPIBLK) (((char *) (pparamblk)) +   \
	       sizeof(PARAMBLK) - sizeof(SMAPIBLK)))
/*
The elemdata structure contains the oid and variable size information.
The pbValue array is cast to a structure whose type depends on the kind
of object being browsed.
*/
typedef struct
{
   OID      oid;
   ULONG    lcbValue;
   BYTE     pbValue[];
} ELEMDATA, __far *PELEMDATA;

typedef struct
{
   WORD     fil;           // folder indent level
   char     grsz[];        // "name\0comment\0\0"
} FOLDDATA, __far *PFOLDDATA;
#define cchMaxFolderName      128   // max values for grsz strings
#define cchMaxFolderComment   128

typedef BYTE MS;              // message status
#define fmsNull               ((MS) 0x00)
#define fmsModified           ((MS) 0x01)
#define fmsLocal              ((MS) 0x02)
#define fmsSubmitted          ((MS) 0x04)
#define fmsReadAckReq         ((MS) 0x08)
#define fmsReadAckSent        ((MS) 0x10)
#define fmsRead               ((MS) 0x20)
#define fmsFromMe             ((MS) 0x40)
#define fmsHasAttach          ((MS) 0x80)
#define fmsReadOnlyMask       ((MS) 0xCF)
#define fmsReadOnlyLocalMask  ((MS) 0xC7)
#define msDefault             ((MS) (fmsLocal | fmsFromMe))

typedef struct
{
   DTR      dtr;           // date of the message
   MS       ms;            // message status flags
   WORD     mc;            // message class
   short    nPriority;     // message priority
   DWORD    dwCached;
   OID      oidFolder;     // oid of folder containing message
   char     grsz[];        // "sender\0subject\0folder name\0\0"
} MSGDATA, __far *PMSGDATA;
#define cchMaxSubject      128     // max values for grsz strings
#define cchMaxSender       128
// folder name in MSGDATA.grsz is only valid in searches.  So make room for it
// but don't rely on it being correct.

/*
Opens a new Container Browsing Context, returning a handle to it. The callback 
function is called when the browsing context code receives notification of a 
change to the container; if it is Null, no callbacks are attempted (so pass 
NULL in for pvCallbackContext and pfnncb). WFlags contains flags about how 
the container should be browsed.
*/
int FAR PASCAL  EcOpenPhcbc(HMSC hmsc, OID __far *poid, WORD wFlags,
	       PHCBC phcbcReturned, LPVOID pfnncb, LPVOID pvCallbackContext);
int FAR PASCAL  EcClosePhcbc(PHCBC phcbcToClose);


/*
Get the ELEMDATA structure for the current element into buffer pelemdata with
size *plcbElemdata. The current position is left to point beyond the element
retrieved. The number of bytes actually copied is returned in *plcbElemdata --
this number will always reflect the amount of data that has been copied, even
when an error is returned (i.e., some errors will read the element anyway). An
error is returned if the buffer size was not large enough for the base ELEMDATA
structure (returns ecMemory and doesn't read any data), or if the size asked
for is bigger than the element (returns ecElementEOD, but does read the data).
*/
int FAR PASCAL  EcGetPelemdata(HCBC hcbc, PELEMDATA pelemdata, 
	       ULONG __far * plcbElemData);

/*
Moves or copies, depending on fMove(TRUE = move), the *pcoid messages 
specified by pargoidMessage(array of oids) from oidFolderSrc to oidFolderDst.
The number of messages actually moved/copied is returned in *pcoid.
*/
int FAR PASCAL  EcMoveCopyMessages(HMSC hmsc, OID oidSrc, OID oidDst, 
	       OID __far *pargoidMsgs, short __far *pcoid, BOOL fMove);

