/*' Schedule+ Access Libraries Sample Application
'   This application is an example of how to use some of
'   the Schedule+ Access Libraries functions
' Copyright(C) 1992-1993 Microsoft Corporation
'
' You have a royalty-free right to use, modify, reproduce
' and distribute this sample application (and/or any modified version)
' in any way you find useful, provided that you agree that
' Microsoft has no warranty, obligations or liability for
' this sample application 
*/             
/* Programming environment used: Microsoft Visual C++*/
#include <windows.h>
#include <string.h>
#include <stdio.h>
#include "mapi.h"  
#include "splus.h"

/*do not redefine  global variable*/
#define ISMAIN
#include "salmain.h"
#undef ISMAIN

#define MAIN 1

extern void vReadResponse_Service();
extern void vReadRqst_Service();

/* dlg box procedures */
extern BOOL FAR PASCAL dlgCAProc( HWND, unsigned, UINT, LONG);
extern BOOL FAR PASCAL dlgCTProc( HWND, unsigned, UINT, LONG);
extern BOOL FAR PASCAL dlgUIProc( HWND, unsigned, UINT, LONG);
extern BOOL FAR PASCAL About(HWND, unsigned, WORD, LONG);

HINSTANCE hInst;
HWND hWndMain;
HANDLE hLibrary;
LHANDLE lhSPLUSSession=0;
LHANDLE lhMAPISession=0;

/****************************************************************************

    FUNCTION: OutOfMemory(void)

    PURPOSE:  Displays warning message

****************************************************************************/
void OutOfMemory(void)
{
    MessageBox(
        GetFocus(),
        "Out of Memory",
        NULL,
        MB_ICONHAND | MB_SYSTEMMODAL);
    return;
}


/************************************************************************/
/*                                                                      */
/* Windows 3.0 Main Program Body                                        */
/*                                                                      */
/* The following routine is the Windows Main Program.  The Main Program */
/* is executed when a program is selected from the Windows Control      */
/* Panel or File Manager.  The WinMain routine registers and creates    */
/* the program's main window and initializes global objects.  The       */
/* WinMain routine also includes the applications message dispatch      */
/* loop.  Every window message destined for the main window or any      */
/* subordinate windows is obtained, possibly translated, and            */
/* dispatched to a window or dialog processing function. The dispatch   */
/* loop is exited when a WM_QUIT message is obtained.  Before exiting   */
/* the WinMain routine should destroy any objects created and free      */
/* memory and other resources.                                          */
/*                                                                      */
/************************************************************************/

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
 /***********************************************************************/
 /* HANDLE hInstance;       handle for this instance                    */
 /* HANDLE hPrevInstance;   handle for possible previous instances      */
 /* LPSTR  lpszCmdLine;     long pointer to exec command line           */
 /* int    nCmdShow;        Show code for main window display           */
 /***********************************************************************/

 MSG        msg;           /* MSG structure to store your messages        */
 int        nRc;           /* return value from Register Classes          */
 long       nWndunits;     /* window units for size and location          */
 int        nWndx;         /* the x axis multiplier                       */
 int        nWndy;         /* the y axis multiplier                       */
 int        nX;            /* the resulting starting point (x, y)         */
 int        nY;
 int        nWidth;        /* the resulting width and height for this     */
 int        nHeight;       /* window                                      */

 strcpy(szAppName, "SALAPP");
 hInst = hInstance;
 if(!hPrevInstance)
   {
    /* register window classes if first instance of application         */
    if ((nRc = nCwRegisterClasses()) == -1)
      {
       /* registering one of the windows failed                         */
       LoadString(hInst, IDS_ERR_REGISTER_CLASS, szString, sizeof(szString));
       MessageBox(NULL, szString, "SAL SAMPLE APPLICATION", MB_ICONEXCLAMATION);
       return nRc;
      }
   }

 /* Create a device independant size and location                       */
 nWndunits = GetDialogBaseUnits();
 nWndx = LOWORD(nWndunits);
 nWndy = HIWORD(nWndunits);
 nX = ((60 * nWndx) / 4);
 nY = ((60 * nWndy) / 8);
 nWidth = ((197 * nWndx) / 4);
 nHeight = ((138 * nWndy) / 8);

 /* create application's Main window                                    */
 hWndMain = CreateWindow(
                szAppName,               /* Window class name           */
                "SAL Sample App",       /* Window's title              */
                WS_CAPTION      |        /* Title and Min/Max           */
                WS_SYSMENU      |        /* Add system menu box         */
                WS_MINIMIZEBOX  |        /* Add minimize box            */
                WS_MAXIMIZEBOX  |        /* Add maximize box            */
                WS_BORDER       |        /* thin frame                  */
                WS_CLIPCHILDREN |         /* don't draw in child windows areas */
                WS_OVERLAPPED,
                nX, nY,                  /* X, Y                        */
                nWidth, nHeight,         /* Width, Height of window     */
                NULL,                    /* Parent window's handle      */
                NULL,                    /* Default to Class Menu       */
                hInst,                   /* Instance of window          */
                NULL);                   /* Create struct for WM_CREATE */



//  InitMessage(&mmMapiMessage);

 if(hWndMain == NULL)
   {
    LoadString(hInst, IDS_ERR_CREATE_WINDOW, szString, sizeof(szString));
    MessageBox(NULL, szString, "SAL SAMPLE APPLICATION", MB_ICONEXCLAMATION);
    return IDS_ERR_CREATE_WINDOW;
   }

 EnableMenuItem(GetMenu(hWndMain), IDM_A_LOGOFF, MF_DISABLED | MF_GRAYED);

 ShowWindow(hWndMain, nCmdShow);            /* display main window      */

 while(GetMessage(&msg, NULL, 0, 0))        /* Until WM_QUIT message    */
   {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
   }

 /* Do clean up before exiting from the application                     */
 CwUnRegisterClasses();
 return msg.wParam;
} /*  End of WinMain                                                    */
/************************************************************************/
/*                                                                      */
/* Main Window Procedure                                                */
/*                                                                      */
/* This procedure provides service routines for the Windows events      */
/* (messages) that Windows sends to the window, as well as the user     */
/* initiated events (messages) that are generated when the user selects */
/* the action bar and pulldown menu controls or the corresponding       */
/* keyboard accelerators.                                               */
/*                                                                      */
/* The SWITCH statement shown below distributes the window messages to  */
/* the respective message service routines, which are set apart by the  */
/* CASE statements. The window procedures must provide an appropriate   */
/* service routine for its end user initiated messages, as well as the  */
/* general Windows messages (ie. WM_CLOSE message). If a message is     */
/* sent to this procedure for which there is no programmed CASE clause  */
/* (i.e., no service routine), the message is defaulted to the          */
/* DefWindowProc function, where it is handled by Windows               */
/*                                                                      */
/* For the end-user initiated messages, this procedure is concerned     */
/* principally with the WM_COMMAND message. The menu control ID (or the */
/* corresponding accelerator ID) is communicated to this procedure in   */
/* the first message parameter (wParam). The window procedure provides  */
/* a major CASE statement for the WM_COMMAND message and a subordinate  */
/* SWITCH statement to provide CASE clauses for the message service     */
/* routines for the various menu item's, identified by their ID values. */
/*                                                                      */
/* The message service routines for the individual menu items are the   */
/* main work points in the program. These service routines contain the  */
/* units of work performed when the end user select one of the menu     */
/* controls. The required application response to a menu control is     */
/* programmed in its associated CASE clause. The service routines may   */
/* contain subroutine calls to separately compiled and libraried        */
/* routines, in-line calls to subroutines to be embodied in this source */
/* code module, or program statements entered directly in the CASE      */
/* clauses. Program control is switched to the appropriate service      */
/* routine when Windows recognizes the end user event and sends a WM_COMMAND */
/* message to the window procedure. The service routine provides the    */
/* appropriate application-specific response to the end user initiated  */
/* event, then breaks to return control to the WinMain() routine which  */
/* continues to service the message queue of the window(s).             */
/*                                                                      */
/************************************************************************/

LONG FAR PASCAL WndProc(HWND hWnd, WORD Message, WORD wParam, LONG lParam)
{
 HMENU      hMenu=0;            /* handle for the menu                 */
 HBITMAP    hBitmap=0;          /* handle for bitmaps                  */
 HDC        hDC;                /* handle for the display device       */
 PAINTSTRUCT ps;                /* holds PAINT information             */
 int        nRc=0;              /* return code                         */
 FLAGS flFlag = 0L;
 ULONG ulResult;
  char szBuf[200];

 switch (Message) {
   case WM_COMMAND:
     /* The Windows messages for action bar and pulldown menu items */
     /* are processed here.                                         */
     /* The WM_COMMAND message contains the message ID in its first */
     /* parameter (wParam). This routine is programmed to SWITCH on */
     /* the #define values generated by CASE:W for the menu items   */
     /* in the application's header (*.H) file. The ID values have  */
     /* the format, IDM_itemname. The service routines for the      */
     /* various menu items follow the CASE statements up to the     */
     /* generated BREAK statements.                                 */

     switch (wParam) {
       case IDM_A_LOGON:    
      /* in this application we only allow one session at one time  */
        {
            flFlag=MAPI_NEW_SESSION | MAPI_LOGON_UI;
            if (!(ulResult=MAPILogon(hWnd, NULL, NULL, 
                                     flFlag, 0L, 
                                     &lhMAPISession)))
            /* if the function success (ulResult=0) 
               call SPLUSBeginSession*/
                if (ulResult=SPLUSBeginSession(lhMAPISession,
                                               0,0,0,&lhSPLUSSession))
                { 
                 /* display error message if the function 
                    fails (ulResult<>0)*/
                    sprintf(szBuf,
                            "Error Starting Session. Error Returned = %lu",
                            ulResult);
                    MessageBox(hWndMain,szBuf,
                               "SAL SAMPLE APPLICATION",
                               MB_ICONEXCLAMATION|MB_OK);
                } 
                else   
                {
                    EnableMenuItem(GetMenu(hWndMain), 
                                   IDM_A_LOGON, 
                                   MF_DISABLED | MF_GRAYED);
                    EnableMenuItem(GetMenu(hWndMain), 
                                   IDM_A_LOGOFF, 
                                   MF_ENABLED);
                }
        }    
       break;

       case IDM_A_LOGOFF:
       {
            if (!(ulResult=MAPILogoff(lhMAPISession, hWnd, 0L, 0L)))
                /* if the function success (ulResult=0) call SPLUSEndSession*/
                if (ulResult=SPLUSEndSession(lhSPLUSSession,0,0,0))
                {
                    /* display error message if the function fails (ulResult<>0)*/
                    sprintf(szBuf,"Error Ending Session. Error Returned = %lu",ulResult);
                    MessageBox(hWndMain,szBuf,
                               "SAL SAMPLE APPLICATION",
                               MB_ICONEXCLAMATION|MB_OK);
                }
                else
                {
                    EnableMenuItem(GetMenu(hWndMain), 
                                   IDM_A_LOGOFF, 
                                   MF_DISABLED | MF_GRAYED);
                    EnableMenuItem(GetMenu(hWndMain), 
                                   IDM_A_LOGON, 
                                   MF_ENABLED);
                }
                lhMAPISession=0;
                lhSPLUSSession=0; 
                /* Destroy child windows, modeless dialogs, then, this window  */
                DestroyWindow(hWnd);
                if (hWnd == hWndMain)
                    PostQuitMessage(0);  /* Quit the application                 */
        }  
       break;

       case IDM_S_CREATEAPPT:   
       /*Create dlg box for New Appt*/
        {   
            FARPROC fnpdlgproc = MakeProcInstance ( dlgCAProc, hInst );                                                                                                                       
            DialogBox(hInst, 
                      MAKEINTRESOURCE(NEWAPP), 
                      hWndMain, 
                      fnpdlgproc);
            FreeProcInstance(fnpdlgproc);   
        }
       break;

       case IDM_S_CREATETASK:
       /* Create dlg box for New Task */
        {
            FARPROC fnpdlgproc = MakeProcInstance ( dlgCTProc, hInst );                                                               
            DialogBox(hInst, 
                      MAKEINTRESOURCE(NEWTASK), 
                      hWndMain , 
                      fnpdlgproc);
            FreeProcInstance(fnpdlgproc);   
        }
       break;

       case IDM_M_READRQST:
       /* go directly to the service routine */
            vReadRqst_Service();
       break;

       case IDM_M_READRESP:   
        vReadResponse_Service();
       break;

       case IDM_M_READUSERINFO:
       /* Create dlg box for User Info */
        {
        FARPROC fnpdlgproc = MakeProcInstance ( dlgUIProc, hInst );                                                               
        DialogBox( hInst, 
                    MAKEINTRESOURCE(USERINFO), 
                    hWndMain , 
                    fnpdlgproc);
        FreeProcInstance(fnpdlgproc);   
        }
       break;
       
       case IDM_ABOUT:
 
        /*   Create dlg box for About..*/
        {
            FARPROC lpProcAbout = MakeProcInstance(About, hInst);
            DialogBox(hInst, 
                      MAKEINTRESOURCE(ABOUTBOX), 
                      hWndMain, 
                      lpProcAbout);
            FreeProcInstance(lpProcAbout);
        }
       break;

       default:
         return DefWindowProc(hWnd, Message, wParam, lParam);
     }
   break;        /* End of WM_COMMAND                             */

   case WM_CREATE:
     /* The WM_CREATE message is sent once to a window when the     */
     /* window is created.  The window procedure for the new window */
     /* receives this message after the window is created, but      */
     /* before the window becomes visible.                          */
     /*                                                             */
     /* Parameters:                                                 */
     /*                                                             */
     /*    lParam  -  Points to a CREATESTRUCT structure with       */
     /*               the following form:                           */
     /*                                                             */
     /*    typedef struct                                           */
     /*              {                                              */
     /*               LPSTR     lpCreateParams;                     */
     /*               HANDLE    hInst;                              */
     /*               HANDLE    hMenu;                              */
     /*               HWND      hwndParent;                         */
     /*               int       cy;                                 */
     /*               int       cx;                                 */
     /*               int       y;                                  */
     /*               int       x;                                  */
     /*               LONG      style;                              */
     /*               LPSTR     lpszName;                           */
     /*               LPSTR     lpszClass;                          */
     /*               DWORD     dwExStyle;                          */
     /*              }  CREATESTRUCT;                               */



   break;       /*  End of WM_CREATE                              */

   case WM_MOVE:     /*  code for moving the window                    */
   break;

   case WM_SIZE:     /*  code for sizing client area                   */
        /* wParam contains a code indicating the requested sizing      */
        /* lParam contains the new height and width of the client area */
   break;       /* End of WM_SIZE                                 */

   case WM_PAINT:    /* code for the window's client area              */
     /* Obtain a handle to the device context                       */
     /* BeginPaint will sends WM_ERASEBKGND if appropriate          */
     memset(&ps, 0x00, sizeof(PAINTSTRUCT));
     hDC = BeginPaint(hWnd, &ps);

     /* Included in case the background is not a pure color         */
     SetBkMode(hDC, TRANSPARENT);

     /* Application should draw on the client window using          */
     /* the GDI graphics and text functions.  'ps' the PAINTSTRUCT  */
     /* returned by BeginPaint contains a rectangle to the          */
     /* area that must be repainted.                                */

     /* Inform Windows painting is complete                         */
     EndPaint(hWnd, &ps);
   break;       /*  End of WM_PAINT                               */

   case WM_CLOSE:  /* close the window                                 */
       /* if there is a SPLUS Session, end it*/
        if (lhSPLUSSession)
        {
            if (!(ulResult=MAPILogoff(lhMAPISession, hWnd, 0L, 0L))) 
                /*  if the function success (ulResult=0) call SPLUSEndSession*/
                if (ulResult = SPLUSEndSession(lhSPLUSSession,0,0,0))
                {
                 /* display error message if the function fails (ulResult<>0)*/
                    sprintf(szBuf,"Error Ending Session. Error Returned = %lu",ulResult);
                    MessageBox(hWndMain,szBuf,"SAL SAMPLE APPLICATION",MB_ICONEXCLAMATION|MB_OK);
                } 
                else
                {
                    lhMAPISession=0;
                    lhSPLUSSession=0;    
                }
        }
     /* Destroy child windows, modeless dialogs, then, this window  */
     DestroyWindow(hWnd);
     if (hWnd == hWndMain)
       PostQuitMessage(0);  /* Quit the application                 */
   break;

   default:
        /* For any message for which you don't specifically provide a  */
        /* service routine, you should return the message to Windows   */
        /* for default message processing.                             */
     return DefWindowProc(hWnd, Message, wParam, lParam);
 }
 return 0L;
}     /* End of WndProc                                         */

/************************************************************************/
/*                                                                      */
/* nCwRegisterClasses Function                                          */
/*                                                                      */
/* The following function registers all the classes of all the windows  */
/* associated with this application. The function returns an error code */
/* if unsuccessful, otherwise it returns 0.                             */
/*                                                                      */
/************************************************************************/

int nCwRegisterClasses(void)
{
 WNDCLASS   wndclass;    /* struct to define a window class             */
 memset(&wndclass, 0x00, sizeof(WNDCLASS));


 /* load WNDCLASS with window's characteristics                         */
 wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNWINDOW;
 wndclass.lpfnWndProc = WndProc;
 /* Extra storage for Class and Window objects                          */
 wndclass.cbClsExtra = 0;
 wndclass.cbWndExtra = 0;
 wndclass.hInstance = hInst;
 wndclass.hIcon = LoadIcon(hInst, "SALAPP");
 wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
 /* Create brush for erasing background                                 */
 wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
 wndclass.lpszMenuName = szAppName;   /* Menu Name is App Name */
 wndclass.lpszClassName = szAppName; /* Class Name is App Name */
 if(!RegisterClass(&wndclass))
   return -1;


 return(0);
} /* End of nCwRegisterClasses                                          */

/************************************************************************/
/*  CwUnRegisterClasses Function                                        */
/*                                                                      */
/*  Deletes any refrences to windows resources created for this         */
/*  application, frees memory, deletes instance, handles and does       */
/*  clean up prior to exiting the window                                */
/*                                                                      */
/************************************************************************/

void CwUnRegisterClasses(void)
{
 WNDCLASS   wndclass;    /* struct to define a window class             */
 memset(&wndclass, 0x00, sizeof(WNDCLASS));

 UnregisterClass(szAppName, hInst);
}    /* End of CwUnRegisterClasses                                      */

