#include <windows.h>
#include <windowsx.h>
#include "mapi.h"
#include "SPLUS.h"
#include <stdio.h>   
#include <string.h> 
#include "salmain.h"
 
ULONG SLSALSendMeeting(lpSPlusAppt,LPSTR);

extern void FreeRecipients(lpMapiRecipDesc far *,ULONG);
extern void FreeMessage(lpSPlusMessage far *);
extern void FreeAppointment(lpSPlusAppt far *);
extern HANDLE CopyRecipients(lpMapiRecipDesc, lpMapiRecipDesc far *,ULONG);
extern HANDLE CopyMessage(lpSPlusMessage, lpSPlusMessage far *);
extern HANDLE CopyAppointment(lpSPlusAppt, lpSPlusAppt far *);
extern BOOL FAR PASCAL dlgDUIProc( HWND, unsigned, UINT, LONG);
extern BOOL FAR PASCAL dlgRMProc( HWND, unsigned, UINT, LONG);

/* ulSaveAppt_Service
 * Purpose:
 *  Receives the imput from the dlg box procedure and fill in the 
 *  needed structures to create a new appt.
 *  Then it checks if it has attendees, and in this case, modify 
 *  the attendee status and send the meeting request
 * Parameters: 
 *  lpszText: Appointment text (enterd by the user)
 *  lpszDateStart: Appointment Start Date (entered by the user)
 *  lpszDateEnd: Appointment end Date (entered by the user)
 *  fAddAttButton : indicates if the user wants to create a regular 
 *  appt, or a meeting with attendees
 * Functionality Description: 
 *  This Function does not validate the date format. It just passes
 *  it to SAL.
 *  If it is invalid, SAL will return an error message.
 *  To get the attendees we call MAPIAdrress, and let it to fill the 
 *  attendee structure
 */

ULONG ulSaveAppt_Service(char far * lpszText,char far * lpszDateStart, 
                         char far * lpszDateEnd, 
                         BOOL fAddAttButton)
{
ULONG ulResult;
int i=0;
ULONG nAttendees=0;  

MapiRecipDesc FAR * lpAttendees;
lpMapiRecipDesc FAR * lppAttendees=&lpAttendees;   

MapiRecipDesc FAR * lpAttendeesTemp;
lpMapiRecipDesc FAR * lppAttendeesTemp=&lpAttendeesTemp;

HANDLE hRecips;

SPlusAppt Appt;
lpSPlusAppt lpAppt = &Appt;

char szBuf[50+20*MAX_ATTENDEES]="";
SPlusAttendeeDesc rgSPLUSAttendee[MAX_ATTENDEES];
LPSTR lpszMessageType;
char buf[64]="";
LPSTR lpszItemID = &buf[0]; 

/* If the Add Attendees button has been pressed then call 
 * MAPIAddress to select attendees */

    if (fAddAttButton)
        if (ulResult=MAPIAddress(lhMAPISession,
                                 0L,
                                 "Select Users",
                                 1L,
                                 "User:",
                                 0L,NULL,0L,0L,
                                 &nAttendees,
                                 lppAttendeesTemp))
        {
            sprintf(szBuf,
                    "Error Selecting Attendees. Error Returned = %lu",
                    ulResult);
            MessageBox(hWndMain,szBuf,
                       "SAL SAMPLE APPLICATION",
                       MB_ICONEXCLAMATION|MB_OK);
            return (ulResult);
        }                                     
        else 
         /* Copy the recipients in a new structure. */
        if (nAttendees!=0)
        {
            if (!(hRecips=CopyRecipients((*lppAttendeesTemp),
                                    lppAttendees,
                                    nAttendees)))
            {   
            /*display error message if the function returns NULL */
                _fstrcpy(szBuf,"Error Allocating Memory for Recipients");
                MessageBox(hWndMain,szBuf,
                           "SAL SAMPLE APPLICATION",
                           MB_ICONEXCLAMATION|MB_OK); 
                return(ulResult);
            } 
            /* Free memory allocated by MAPIAddress */
            ulResult=MAPIFreeBuffer(lpAttendeesTemp);
        }
    
/* Initialize the appt structure */

    lpAppt->ulReserved=0;
    lpAppt->lpszItemType="SimpleAppt";
    lpAppt->flFlags=0;
    lpAppt->lpCreator=NULL;
    lpAppt->nAssocCount=0;
    lpAppt->lpAssoc=NULL;
    lpAppt->lpOrganizer=NULL;
    lpAppt->lpszOrganizerItemID=NULL;
    lpAppt->nAttendeeCount=nAttendees;
    if (nAttendees)
    {
        for (i=0;i<(int)nAttendees;i++)
        {
            rgSPLUSAttendee[i].ulReserved=0;
            rgSPLUSAttendee[i].lpszUserType="Individual";
            rgSPLUSAttendee[i].lpUser=&(lpAttendees[i]);
            rgSPLUSAttendee[i].ulStatus=SPLUS_NO_RESPONSE;
        }
        lpAppt->lpszItemType="OrganizedMeeting";
        lpAppt->lpAttendees=&rgSPLUSAttendee[0];
    }
    else
        lpAppt->lpAttendees=NULL; 
        
    lpAppt->lpszText=lpszText;
    lpAppt->lpszBody=NULL;
    lpAppt->lpszRecurrence=NULL;
    lpAppt->lpszDateStart=lpszDateStart;
    lpAppt->lpszDateEnd=lpszDateEnd;

/* new appt: flFlags=0 and lpszItemID=NULL */
/* Save the appt */ 
                                                         
    if (ulResult=SPLUSSaveAppt(lhSPLUSSession, 0L, 
                           NULL, lpAppt, 
                           0L, 0L, 
                           lpszItemID))
    {
    /* display error message and exit if the function fails (ulResult<>0)*/
        sprintf(szBuf,
                "Error Saving Appointment. Error Returned = %lu",
                ulResult);
        MessageBox(hWndMain,szBuf,
                   "SAL SAMPLE APPLICATION",
                   MB_ICONEXCLAMATION|MB_OK); 
        return(ulResult);
    }

/*  if the appt was created and it has attendees, 
    then send meeting request.
    lpAppt->lpszOrganizer ItemID should be a valid 
    ID obtained from the previous SaveAppt call.
*/
    if (nAttendees)
    {
        if(ulResult == 0) 
        {  
            /* compose message box text : meeting time and attendees */
            sprintf(szBuf,
                    "Meeting created on %s\n\n Attendees:", 
                    lpAppt->lpszDateStart);
            for (i=0;i< (int)nAttendees; i++) 
            {
                _fstrcat((char far *)szBuf,(char far *)"\n      ");  
                _fstrcat((char far *)szBuf,
                         (char far *)lpAttendees[i].lpszName);  
            }
            MessageBox(hWndMain,szBuf,
                       "SAL SAMPLE APPLICATION",
                       MB_ICONINFORMATION |MB_OK);
            lpAppt->lpszOrganizerItemID=lpszItemID;
            lpszMessageType="IPM.Microsoft Schedule.MtgReq";
            SLSALSendMeeting(lpAppt,lpszMessageType);
        }
        FreeRecipients(lppAttendees,nAttendees);  
    }   
    else  
        if (ulResult==0)
        {
            sprintf(szBuf,
                    "Appointment created on %s",
                    lpAppt->lpszDateStart);
            MessageBox(hWndMain,szBuf,
                       "SAL SAMPLE APPLICATION",
                       MB_ICONINFORMATION |MB_OK);
        }               
        return(ulResult);
}


/* ulSaveTask_Service
 * Purpose:
 *  Receives the imput from the dlg box procedure and fill in 
 *  the needed structures to create a new task.
 * Parameters:
 *  lpszText: Task name (entered by the user)
 *  lpszProjectName: Project name (entered by the user)
 *  lpszPriority : task priority (entered by the user)
 * Functionality Description: 
 *  This Function does not validate the Priority. It just passes
 *  it to SAL.
 *  If it is invalid, SAL will return an error message.
 */  
ULONG ulSaveTask_Service(char far * lpszText, 
                   char far * lpszProjectName, 
                   char far * lpszPriority)
{   

ULONG ulResult;
int i=0;
SPlusTask Task;
lpSPlusTask lpTask = &Task;
char szBuf[200]="";
char buf[64]="";
LPSTR lpszItemID = &buf[0]; 

/* Initialize the task structure */
    lpTask->ulReserved=0;
    lpTask->lpszItemType="SimpleTask";
    lpTask->flFlags=0;
    lpTask->lpCreator=NULL;
    lpTask->nAssocCount=0;
    lpTask->lpAssoc=NULL;
    lpTask->lpOrganizer=NULL;
    lpTask->lpszOrganizerItemID=NULL;
    lpTask->nAttendeeCount=0;
    lpTask->lpAttendees=NULL; 
        
    lpTask->lpszText=lpszText;
    lpTask->lpszBody=NULL;
    lpTask->lpszRecurrence=NULL;
    lpTask->lpszDateDue=NULL;
    lpTask->lpszDurationActive=NULL;  
    lpTask->lpszProjectName=lpszProjectName;
    lpTask->lpszPriority=lpszPriority;
/* new task: flFlags=0 and lpszItemID=NULL */
/* Save the task */
    if (ulResult=SPLUSSaveTask(lhSPLUSSession, 0L, 
                           NULL, 
                           lpTask, 
                           0L, 0L, 
                           lpszItemID))
    {  
        /* display error message and exit if the function fails (ulResult<>0)*/
        sprintf(szBuf,
                "Error Saving Task. Error Returned = %lu",
                ulResult);
        MessageBox(hWndMain,szBuf,
                   "SAL SAMPLE APPLICATION",
                   MB_ICONEXCLAMATION|MB_OK); 
    }

    else
    {
        lstrcpy(szBuf,"New task created.\n Task name: ");
        _fstrcat((char far *)szBuf,(char far *)lpTask->lpszText);  
        _fstrcat((char far *)szBuf,(char far *)"\nProject name: ");  
        _fstrcat((char far *)szBuf,(char far *)lpTask->lpszProjectName);  
        _fstrcat((char far *)szBuf,(char far *)"\nPriority: ");  
        _fstrcat((char far *)szBuf,(char far *)lpTask->lpszPriority);  
        MessageBox(hWndMain,szBuf,
                   "SAL SAMPLE APPLICATION",
                   MB_ICONINFORMATION |MB_OK);
     }                            
                                  
return(ulResult);
}

/* ulReadUserInfo_Service
 * Purpose:
 *  Calls and fill in the needed structures to get information
 *  for the specified user.
 * Parameters:
 *  lpszName: user name (entered by the user)
 *  lpszAddress: full user address (entered by the user)
 * Functionality Description: 
 *  This Function does not validate the Address. It just passes it to SAL.
 *  If it is invalid, SAL will return an error message.
 */
ULONG ulReadUserInfo_Service(char far * lpszName, 
                             char far * lpszAddress)
{
ULONG ulResult; 

MapiRecipDesc User;
lpMapiRecipDesc lpUser = &User;

SPlusUserInfo FAR * lpUserInfo;
lpSPlusUserInfo * lppUserInfo=&lpUserInfo;  

char szBuf[200]=""; 
    
    lpUser->lpszName=lpszName;
    lpUser->lpszAddress=lpszAddress;   
    lpUser->ulReserved=0;
    lpUser->ulRecipClass = MAPI_ORIG;
    lpUser->ulEIDSize=0;
    lpUser->lpEntryID=NULL;

    if (ulResult=SPLUSReadUserInfo(lhSPLUSSession,0,lpUser,0,0,lppUserInfo))
    {
     /* display error message if the function fails (ulResult<>0)*/
        sprintf(szBuf,
                "Error Reading User Information. Error Returned = %lu",
                ulResult);
        MessageBox(hWndMain,szBuf,
                   "SAL SAMPLE APPLICATION",
                   MB_ICONEXCLAMATION|MB_OK); 
    }
    else                         
    { 
     /*Create dlg box to display User Info */
     
        FARPROC fnpdlgproc = MakeProcInstance ( dlgDUIProc, hInst );
                                                                
        DialogBoxParam( hInst, 
                MAKEINTRESOURCE(GUSERINFO), 
                hWndMain , 
                fnpdlgproc, 
                (LPARAM)lpUserInfo);

        FreeProcInstance(fnpdlgproc);   
        /*free memory allocated by SPLUSReadUserInfo */
        ulResult=MAPIFreeBuffer(lpUserInfo);
    }
return(ulResult);
}


/* vReadResponse_Service
 * Purpose:
 *  Service routine for the Read Response menu item. 
 *  This function will read the first available meeting response 
 *  (we only treat the cases of positive or negative responses) 
 *  in the user's inbox.
 *  It there is any, it will modify the attendee status in the 
 *  original appt
 * Parameters:
 *   none
 * Restrictions: we do not treat alarms. If reading a response to a meeting sent
 * with Bandit, it only works if the appt does not have any alarm associated to it.
 * If it has one this function will return an error message.
*/
void vReadResponse_Service()
{
/* local variables */  
    int i;
    ULONG ulStatus; /* new confirmation status of the attendees*/
    ULONG ulResult;
    char szBuf[200]="";
    char buf1[64];
    char buf2[64];
    
    SPlusMessage FAR * lpMessage;
    lpSPlusMessage * lppMessage=&lpMessage;
    
    SPlusAppt FAR * lpRMAppt;
    lpSPlusAppt * lppRMAppt=&lpRMAppt;

    SPlusAppt FAR * lpRAAppt;
    lpSPlusAppt * lppRAAppt=&lpRAAppt;
    int different;

/* Message ID must be able to accomodate at least 64 characters */

    LPSTR lpszMessageID=&buf1[0];
    LPSTR lpszItemID=&buf2[0];

    /* we only consider the cases of positive and negative responses */

    ulStatus=SPLUS_POSITIVE_RESPONSE;
    if (ulResult=MAPIFindNext(lhMAPISession,0,
                          "IPM.Microsoft Schedule.MtgRespP",
                          NULL,0L,0L,
                          lpszMessageID))
    {
    /* if does not find positive response (ulResult<>0)
       search for a nevative response*/
        ulStatus=SPLUS_NEGATIVE_RESPONSE;
        if (ulResult=MAPIFindNext(lhMAPISession,0,
                    "IPM.Microsoft Schedule.MtgRespN",
                              NULL,0L,0L,
                              lpszMessageID))
        {
        /* display error message if the function fails (ulResult<>0)*/
          sprintf(szBuf,
                  "Error Reading Message.Error Returned = %lu",
                  ulResult);
          MessageBox(hWndMain,szBuf,
                     "SAL SAMPLE APPLICATION",
                     MB_ICONEXCLAMATION|MB_OK);
        }
    }
    if (ulResult==0L)
    {                
     /* if it found a response (positive or negative),
        read it and update attendees' status */
        if (!(ulResult=SPLUSReadMeeting(lhMAPISession,0L,
                                  lpszMessageID,0L,0L,
                                  lppMessage,
                                  lppRMAppt)))
        {   
            /* if the function success (ulResult=0) update attendees status*/
            lpszItemID=lpRMAppt->lpszOrganizerItemID; 
            
            /*  find position of the attendee who responded 
                in the appt attendees*/  
            /* lpRMAppt->Organizer has the name of the person who owns the calendar in which the meeting resides 
            */
                  
            if (!(ulResult=SPLUSReadAppt(lhSPLUSSession,0,
                                   lpRMAppt->lpOrganizer,
                                   lpszItemID,0,0,
                                   lppRAAppt)))
            {   
             /* if the function returned successfully search the 
             recipient in the appt attendees  */    
             /* lpMessge->lpSentFor has the name of the attendee to the meeting  */
                i=0;
                while ((i<(int)lpRAAppt->nAttendeeCount) && 
                    (different=_fstrcmp(lpRAAppt->lpAttendees[i].lpUser->lpszAddress,
                                        lpMessage->lpSentFor->lpszAddress)))
                     i++;
                i--;
                lpRAAppt->lpAttendees[i].ulStatus=ulStatus;
        
                /*  modify attendees status of existing appointment: 
                    flFlags=SPLUS_MODIFY_ATTENDEES and lpszItemID=apptID */
                if (!(ulResult=SPLUSSaveAppt(lhSPLUSSession, 0L, 
                                       lpRMAppt->lpOrganizer, lpRAAppt, 
                                       SPLUS_MODIFY_ATTENDEES, 0L, 
                                       lpszItemID)))
                {
                    /*  if the appt has been saved compose message box text : 
                        meeting time and attendees */ 
                    lstrcpy(szBuf,"Meeting response from ");
                    _fstrcat((char far *)szBuf,
                             (char far *)lpMessage->lpSentFor->lpszName);  
                    _fstrcat((char far *)szBuf,
                             (char far *)"\nSent by ");  
                    _fstrcat((char far *)szBuf,
                             (char far *)lpMessage->lpOriginator->lpszName);  
                    _fstrcat((char far *)szBuf,
                             (char far *)"\nto ");  
                    _fstrcat((char far *)szBuf,
                             (char far *)lpRMAppt->lpOrganizer->lpszName);  
                    _fstrcat((char far *)szBuf,
                             (char far *)"\nto meeting on ");  
                    _fstrcat((char far *)szBuf,
                             (char far *)lpRAAppt->lpszDateStart);  
                    _fstrcat((char far *)szBuf,
                             (char far *)"\n\n Response: \n    ");  
                    _fstrcat((char far *)szBuf,
                             (char far *)lpMessage->lpszSubject);  
                     MessageBox(hWndMain,szBuf,
                                "SAL SAMPLE APPLICATION",
                                MB_ICONINFORMATION |MB_OK);
                }  
                else
                {   
                    /* problem saving appt */
                    sprintf(szBuf,
                            "Error Saving Attendee's Status. Error Returned = %lu",
                            ulResult);
                    MessageBox(hWndMain,szBuf,
                               "SAL SAMPLE APPLICATION",
                               MB_ICONEXCLAMATION|MB_OK);
                }
                /* free the memory allocated by SPLUSReadAppt*/
                ulResult=MAPIFreeBuffer(lpRAAppt);
            }
            else  
            {   
                /*error reading appointment */
                sprintf(szBuf,
                        "Error Reading Associated Appointment. Error Returned = %lu",
                        ulResult);
                MessageBox(hWndMain,szBuf,
                           "SAL SAMPLE APPLICATION",
                           MB_ICONEXCLAMATION|MB_OK);
            }   
            /*free memory allocated by SPLUSReadMeeting */
            ulResult=MAPIFreeBuffer(lpRMAppt);
            ulResult=MAPIFreeBuffer(lpMessage);
        } 
        else
        {  
            /*error reading meeting */
            sprintf(szBuf,
                    "Error Reading Meeting Response. Error Returned = %lu",
                    ulResult);
            MessageBox(hWndMain,szBuf,
                       "SAL SAMPLE APPLICATION",
                       MB_ICONEXCLAMATION|MB_OK);
        }
    }    
}


/* SLSALSendMeeting
 * Purpose:
 *  Call SPLUSSendMeeting
 * Parameters: 
 *  lpAppt: pointer to appt structure
 *  lpszMessageType: Message class
 */

ULONG SLSALSendMeeting(lpSPlusAppt lpAppt,LPSTR lpszMessageType)
{
/* local variables  */
    ULONG ulResult;
    char szBuf[200];
/* local variables used to call the DLL */
    SPlusMessage Message;
    lpSPlusMessage lpMessage = &Message;
 
/* initialize the message structure */   
    lpMessage->ulReserved=0; 
    /* set message subject to be the same the the appt description*/
    lpMessage->lpszSubject=lpAppt->lpszText;   
    /*in this sample app we do not allow the user to send any text 
    in the message body*/
    lpMessage->lpszNoteText="";
    lpMessage->lpszMessageType=lpszMessageType;
    lpMessage->lpszDateReceived=NULL;
    lpMessage->lpszConversationID=NULL;
    lpMessage->flFlags=SPLUS_RESPONSE_REQUESTED;
    lpMessage->lpOriginator=NULL;
    lpMessage->nRecipCount=lpAppt->nAttendeeCount;
    lpMessage->lpRecips=lpAppt->lpAttendees[0].lpUser;
    lpMessage->nFileCount=0;
    lpMessage->nSentForCount=0;
    lpMessage->lpSentFor=NULL;

    if (ulResult=SPLUSSendMeeting(lhMAPISession,0L,
                              lpMessage,
                              lpAppt,0L, 0L))
    { 
    /*error sending meeting request */
        sprintf(szBuf,
                "Error sending Meeting Request. Error Returned = %lu",
                ulResult);
        MessageBox(hWndMain,szBuf,
                   "SAL SAMPLE APPLICATION",
                   MB_ICONEXCLAMATION|MB_OK);
    }
return (ulResult);
}



/***********************************************

vReadRqst_Service:

PURPOSE:
 Service routine for the Read Request menu item. This function
 will read the first available meeting request, display it and
 let the user ACCEPT or DECLINE it for him/her self AND for each
 person the user is designated as assistant for (depending on who
 has been invited to the meeting). Responses are sent and appointments
 are saved based on the users choice.

INPUT:
    None.

RETURN:
    Void.

************************************************/




VOID vReadRqst_Service()
{

int     i;
ULONG   ulResult;
ULONG   ulDialogResult;
LPSTR   lpszMessageType;
LPSTR   lpszMessageID;
LPSTR   lpszItemID;
char    szMsgBoxBuf[256] = "";
LPSTR   lpszMsgBoxBuf = &szMsgBoxBuf[0];
char    TmpBuf[256] = "";
LPSTR   lpTmpBuf = &TmpBuf[0];
HANDLE  hMsg;
HANDLE  hAppt;
HANDLE  hglb;
HANDLE  hSentFor;

SPlusMessage FAR *lpTempMessage;
lpSPlusMessage FAR *lppTempMessage = &lpTempMessage;

SPlusMessage FAR *lpMessage;
lpSPlusMessage FAR *lppMessage = &lpMessage;

SPlusAppt FAR *lpTempAppt;
lpSPlusAppt FAR *lppTempAppt = &lpTempAppt;

SPlusAppt FAR *lpAppt;
lpSPlusAppt FAR *lppAppt = &lpAppt;

MapiRecipDesc FAR *lpTempSentFor;
lpMapiRecipDesc FAR *lppTempSentFor = &lpTempSentFor;
ULONG   ulTempSentForCount;

/* First get the message (meeting request) if any!! (use MAPIFindNext to enumerate the message) */

    lpszMessageType = "IPM.Microsoft Schedule.MtgReq";
    lpszMessageID = &TmpBuf[0];

    if ( ulResult=MAPIFindNext(lhMAPISession, hWndMain, lpszMessageType, NULL, 0L, 0L, lpszMessageID)) {

        sprintf(szMsgBoxBuf,
            "Error enumerating meeting request!. Error Returned = %lu", ulResult);
        MessageBox (hWndMain,
            szMsgBoxBuf,
            "SAL SAMPLE APPLICATION",
            MB_ICONEXCLAMATION | MB_OK);
    return;
    }

    /* use SAL to read the meeting request */      

    if ( ulResult=SPLUSReadMeeting(lhMAPISession, hWndMain, lpszMessageID,0L,0L, lppTempMessage,lppTempAppt)) {

        sprintf(szMsgBoxBuf,
            "Error reading meeting request!. Error Returned = %lu", ulResult);
        MessageBox (hWndMain,
            szMsgBoxBuf,
            "SAL SAMPLE APPLICATION",
            MB_ICONEXCLAMATION | MB_OK);
    return;
    }


/* if we successfully read the request, make a copy of the appt and message to use */ 

    /* copy the message */

    if (!(hMsg = CopyMessage(*lppTempMessage, lppMessage))) {

        (_fstrcpy(szMsgBoxBuf,"Error Allocating Memory for Message"));
        MessageBox(hWndMain,szMsgBoxBuf,
            "SAL SAMPLE APPLICATION",
            MB_ICONEXCLAMATION|MB_OK); 

        /* If copy fails free memory allocated by ReadMeeting before returning */
        ulResult=MAPIFreeBuffer(lpTempMessage);
        ulResult = MAPIFreeBuffer(lpTempAppt);    
        return;
    } 

    /* copy the appt*/

    if (!(hAppt = CopyAppointment(*lppTempAppt, lppAppt))) {
       (_fstrcpy(szMsgBoxBuf,"Error Allocating Memory for Appointment"));
        MessageBox(hWndMain,szMsgBoxBuf,
                    "SAL SAMPLE APPLICATION",
                    MB_ICONEXCLAMATION|MB_OK); 
        /* If copy fails free memory allocated by ReadMeeting and CopyMessage before returning*/
        ulResult=MAPIFreeBuffer(lpTempMessage);
        ulResult = MAPIFreeBuffer(lpTempAppt);
        FreeMessage(lppMessage);
        return;
    } 
        
/* Build the response (manipulate the copied message from ReadMeeting) */

    lpMessage->ulReserved = 0L;
    lpMessage->flFlags = 0L;
    lpMessage->nFileCount = 0L;
    lpMessage->lpFiles =  NULL;

    /* need to set lpszDateRecieved to NULL so 1st free associated memory allocated by CopyMessage */

    hglb=GlobalPtrHandle((LPSTR)((*lppMessage)->lpszDateReceived));
    GlobalUnlock(hglb);
    GlobalFree(hglb); 
    lpMessage->lpszDateReceived = NULL;

    /* need to set lpOriginator to NULL so 1st free associated memory allocated by CopyMessage */

    FreeRecipients (&(lpMessage->lpOriginator),1L);
    lpMessage->lpOriginator = NULL;

    /* need to change Recipients returned by ReadMeeting, so free associated memory allocated by CopyMessage */

    FreeRecipients (&(lpMessage->lpRecips), lpMessage->nRecipCount);

    /* The appointment ORGANIZER becomes the recipient (this is the meeting Owner) */

    CopyRecipients(lpAppt->lpOrganizer , &(lpMessage->lpRecips), 1L);
    lpMessage->lpRecips->ulRecipClass = MAPI_TO;              /* Change from type MAPI_ORIG to MAPI_TO  */
    lpMessage->nRecipCount = 1L;

    /* we are responsible for responding to EVERYONE listed in the SentFor field (includes everyone
        invited that we are the assistant for, and may or may not include us (if we were invited))
        Make a copy of the SentFor field and SentForCount (from the original Meeting Request) and loop
        through each person and give a choice of ACCEPT DECLINE or CANCEL */

    ulTempSentForCount = lpMessage->nSentForCount;

    if (!(hSentFor = CopyRecipients( lpMessage->lpSentFor, lppTempSentFor, ulTempSentForCount))) {
       (_fstrcpy(szMsgBoxBuf,"Error Allocating Memory for Recipients"));
        MessageBox(hWndMain,szMsgBoxBuf,
                    "SAL SAMPLE APPLICATION",
                    MB_ICONEXCLAMATION|MB_OK); 

        /* If copy fails free memory allocated by ReadMeeting, CopyMessage and CopyAppointment before returning*/
        ulResult=MAPIFreeBuffer(lpTempMessage);
        ulResult = MAPIFreeBuffer(lpTempAppt);
        FreeMessage(lppMessage);
        FreeAppointment(lppAppt);
    }

    /* free original SentFor field to make room for SentFor field of the response */
    
    FreeRecipients (&(lpMessage->lpSentFor), lpMessage->nSentForCount);
    lpMessage->nSentForCount = 1L;

/* Now we will loop through each person from the original meeting request's lpSentFor field, displaying the 
    meeting request and giving the user a chance to ACCEPT, DECLINE or CANCEL on behalf of each person and
    then send responses and save appointments as appropriate */

    for (i=0; i < (int) ulTempSentForCount; i++) {
    
        /* create the SentFor field for this particular response */        

        CopyRecipients((lpTempSentFor + i) , &(lpMessage->lpSentFor), 1L);
    
    /* Create and display dlg box for Read Meeting Request  */
        {
        FARPROC fnpdlgproc = MakeProcInstance ( dlgRMProc, hInst );
    
        /* create structure with all info needed to display the dialog and pass as DialogBoxParam lParam */

        ApptMsg TempApptMsg;
        lpApptMsg lpTempApptMsg = &TempApptMsg;
        TempApptMsg.lpMsg = lpTempMessage;
        TempApptMsg.lpAppt = lpAppt;
        TempApptMsg.lpSentFor = lpMessage->lpSentFor;
    
        /* Return of the dialog function is the button that the user pressed */

        ulDialogResult = DialogBoxParam( hInst,
                                   MAKEINTRESOURCE(READMTGRQST),
                                   hWndMain ,
                                   fnpdlgproc,
                                   (LPARAM)lpTempApptMsg);
    
        FreeProcInstance(fnpdlgproc);
        }

    /* now take action based on which button was pressed */
    
        switch (ulDialogResult) {
    
        case (ACCEPT):

        /* Send the positive response */

            /* add response status (YES) to the front of the message subject and
                create the proper type of response type */
    
            (_fstrcpy(lpTmpBuf , (char far *) "Yes: "));
            if (lpMessage->lpszSubject)                         /* pointer can be NULL to denote no subject */
                (_fstrcat(lpTmpBuf , lpTempMessage ->lpszSubject));
            (_fstrcpy(lpMessage->lpszSubject , lpTmpBuf));

            (_fstrcpy(lpMessage->lpszMessageType ,(char far *) "IPM.Microsoft Schedule.MtgRespP"));
      
            if (ulResult = SPLUSSendMeeting(lhMAPISession, hWndMain, lpMessage, lpAppt, 0L, 0L)) {

                sprintf(szMsgBoxBuf, "Error sending meeting request! Error Returned = %lu", ulResult);
                MessageBox (hWndMain,
                    szMsgBoxBuf,
                    "SAL SAMPLE APPLICATION",
                    MB_ICONEXCLAMATION | MB_OK);
                break;
    
            } else {
                (_fstrcpy(lpszMsgBoxBuf , (char far *) "Positive response successfully sent on behalf of " ));
                (_fstrcat(lpszMsgBoxBuf , lpMessage ->lpSentFor->lpszName));
                MessageBox (hWndMain,
                    szMsgBoxBuf,
                    "SAL SAMPLE APPLICATION",
                    MB_ICONINFORMATION | MB_OK);
            }
    
        /* Save the appt (in the appt book of user specified by the current SentFor field)  */
    
            lpszItemID = &TmpBuf[0];   /* Appt ID must be able to accomodate at least 64 characters */
            *(lpszItemID) = 0;
                
            if (ulResult = SPLUSSaveAppt(lhSPLUSSession, hWndMain, (lpMessage->lpSentFor), lpAppt, 0L, 0L, lpszItemID)) {
    
                sprintf(szMsgBoxBuf, "Error creating appointment! Error Returned = %lu", ulResult);
                MessageBox (hWndMain,
                    szMsgBoxBuf,
                    "SAL SAMPLE APPLICATION",
                    MB_ICONEXCLAMATION | MB_OK);
    
            } else {
                (_fstrcpy(lpszMsgBoxBuf , (char far *) "Appt successfully saved for " ));
                (_fstrcat(lpszMsgBoxBuf , lpMessage ->lpSentFor->lpszName));
                MessageBox (hWndMain,
                    szMsgBoxBuf,
                    "SAL SAMPLE APPLICATION",
                    MB_ICONINFORMATION | MB_OK);
            }   

            break;
            
        case (DECLINE):        /* if DECLINE just send message */
            
        /* Send the negative response */

            /* add response status (NO) to the front of the message subject and
                create the proper type of response */
    
            (_fstrcpy(lpTmpBuf , (char far *) "No: "));
            if (lpMessage->lpszSubject)                         /* pointer can be NULL to denote no subject */
                (_fstrcat(lpTmpBuf , lpTempMessage ->lpszSubject));
            (_fstrcpy(lpMessage->lpszSubject , lpTmpBuf));
    
            (_fstrcpy(lpMessage->lpszMessageType ,(char far *) "IPM.Microsoft Schedule.MtgRespN"));
    
    
            if (ulResult = SPLUSSendMeeting(lhMAPISession, hWndMain, lpMessage, lpAppt, 0L, 0L)) {

                sprintf(szMsgBoxBuf, "Error sending meeting request!. Error Returned = %lu", ulResult);
                MessageBox (hWndMain,
                    szMsgBoxBuf,
                    "SAL SAMPLE APPLICATION",
                    MB_ICONEXCLAMATION | MB_OK);
                break;
    
            } else {
                (_fstrcpy(lpszMsgBoxBuf , (char far *) "Negative response successfully sent on behalf of " ));
                (_fstrcat(lpszMsgBoxBuf , lpMessage ->lpSentFor->lpszName));
                MessageBox (hWndMain,
                    szMsgBoxBuf,
                    "SAL SAMPLE APPLICATION",
                    MB_ICONINFORMATION | MB_OK);
            }
    
            break;
    
        case  ( CANCEL ):
            break;
    
        default:
            break;
    
        }
    
    /* now free the response SentFor field so the next one can be copied in */

    FreeRecipients (&(lpMessage->lpSentFor) , 1L);
    
    }

/* Free memory allocated by CopyMessage and CopyAppointment */
lpMessage->lpSentFor = NULL;                /* already freed in the for loop  */
FreeMessage(lppMessage);
FreeAppointment(lppAppt);

/* Free Message and Appt memory allocated by ReadMeeting */
ulResult = MAPIFreeBuffer(lpTempMessage);
ulResult = MAPIFreeBuffer(lpTempAppt);    

return;

}