@echo off

REM FP.BAT, Copyright (c) 1993 Data Fellows Oy
REM This batch file simplifies automating the use of F-PROT.

REM If F-PROT is installed in a different directory than C:\F-PROT,
REM please specify it in the next statement. Also the directory
REM to output the report into can be configured.

set FPDIR=C:\F-PROT\
set FPREPORT=C:\F-PROT.REP

REM FP.BAT will scan all the hard disks in the machine. If only one
REM directory is ment to be checked, replace the switch /HARD
REM with the directory name. For example, C:\DOS.

REM Switch /REPORT will produce an ASCII file which will contain
REM a report of the results of the scanning. By including the
REM switch /APPEND, you can store all the reports in the same file.
REM This way every new report is appended to the end of the old ones.

REM If you want to maximize the security of the scan, you can add
REM switch /ALL to the command line. This way F-PROT will search
REM through all files, including documents and data files. Normally
REM files with extension COM, EXE, SYS, OV?, APP and PGM are scanned.

REM If external sign have been added to F-PROT, you can include them
REM in the search by adding /USER to the command line.

REM If you wish to increase the speed of the scanning, you can add
REM the switches /QUICK and /NOMEM. Please note that this will
REM result in some loss of the protection.

REM Scan can be made uninterrupuble by including /NOBREAK to the
REM command line. Remember to change the note also, as ESC will
REM not abort the scan.

echo.
echo F-PROT is checking the system for viruses, please wait. Press ESC to abort.
echo.

%FPDIR%F-PROT.EXE /HARD /SILENT /BEEP /REPORT=%FPREPORT%

REM Scan is over, now the errorlevels are checked

REM Out of memory
if errorlevel 7 goto OUT-OF-MEM

REM F-PROT was aborted early
if errorlevel 5 goto ABORT

REM A virus was found in the memory
if errorlevel 4 goto MEMORY

REM A virus was found in a file or in the boot sectors
if errorlevel 3 goto VIRUS

REM F-PROT.EXE is corrupted
if errorlevel 2 goto CORRUPTED

REM Abort with an error
if errorlevel 1 goto ERROR

REM Everythings OK
if errorlevel 0 goto OK

goto END

REM Additional functions can be added under the following labels.
REM For example, a sound can be included under label VIRUS or
REM a halt of the machine under the label MEMORY.

:OUT-OF-MEM
echo Virus check aborted - not enough memory.
goto loppu

:ABORT
echo F-PROT was aborted, scanning was not completed.
goto END

:MEMORY
REM  A large message screen can be added here or the
REM  command CTTY NUL, which will freeze the machine
echo F-PROT found an active virus from the computers memory!
echo Power down immediatly and contact PC support!
goto END

:VIRUS
REM  A large message screen can be added here or the
REM  command CTTY NUL, which will freeze the machine
echo F-PROT found a virus from a file or from the boot sector of
echo this machine!
echo Contact PC support immediatly.
echo More information will be found from the created report, %FPREPORT%.
goto END

:CORRUPTED
echo F-PROT.EXE has been corrupted! This may be caused by
echo a disk error or a virus.
echo Contact PC support immediatly.
goto END

:ERROR
echo System error, F-PROT cannot check the system for viruses.
echo Please check that all F-PROT's files are present.
goto END

:OK
echo The machine is checked, no viruses found.
goto end

:END
set FPDIR=
set FPREPORT=
echo.
