	TITLE	SNIFHELP - LANprobe Packet Sniffing Routines.

;***	SNIFHELP -- LANprobe Packet Sniffing Routines.
;
;1.	Functional Description.
;	This module implements routines for the network analyzer that
;	could not be otherwise implemented in C.  Mostly, we handle
;	code to talk to the FTP Software Packet Driver Interface (v1.09).
;
;2.	Modification History.
;	S. E. Jones	92/03/16.	Original for The Snooper.
;	S. E. Jones	92/05/09.	Used in LANprobe.
;	S. E. Jones	93/01/02.	#2.0, added send & get address functions.
;
;3.	NOTICE: Copyright (C) 1992-1993 General Software, Inc.
;
;4.	Build Environment.
;	MASM 5.10, no special switches.

DefApi	MACRO	lab
	DefProc lab, PUBLIC, FAR
	ENDM

EndApi	MACRO	lab
	EndProc lab
	ENDM

P0	EQU	bp+6
P1	EQU	bp+8
P2	EQU	bp+10
P3	EQU	bp+12
P4	EQU	bp+14
P5	EQU	bp+16
P6	EQU	bp+18
P7	EQU	bp+20
P8	EQU	bp+22
P9	EQU	bp+24

;	Packet driver status codes.

PDSTATUS_SUCCESS	=	0
PDSTATUS_BAD_HANDLE	=	1	; invalid handle.
PDSTATUS_NO_CLASS	=	2	; no interfaces of specified class found.
PDSTATUS_NO_TYPE	=	3	; no interfaces of specified type found.
PDSTATUS_NO_NUMBER	=	4	; no interfaces of specified number found.
PDSTATUS_BAD_TYPE	=	5	; bad packet type specified.
PDSTATUS_NO_MULTICAST	=	6	; interface does not support multicast.
PDSTATUS_CANT_TERM	=	7	; packet driver cannot terminate.
PDSTATUS_BAD_MODE	=	8	; receiver mode invalid or not supported.
PDSTATUS_NO_SPACE	=	9	; no resources.
PDSTATUS_TYPE_IN_USE	=	10	; the specified type is in use.
PDSTATUS_BAD_COMMAND	=	11	; command invalid or not implemented.
PDSTATUS_CANT_SEND	=	12	; packet could not be sent (hdwr).
PDSTATUS_CANT_SET	=	13	; MAC address could not be changed.
PDSTATUS_BAD_ADDRESS	=	14	; MAC address has bad length or format.
PDSTATUS_CANT_RESET	=	15	; interface could not be reset.

	include ..\inc\defines.inc
	include ..\inc\umacros.inc

DOUBLE		STRUC
lo		dw	?
hi		dw	?
DOUBLE		ENDS

;	The following structures are passed by callers to the _intdosx call.

REGS		STRUC
regs_ax         dw	?
regs_bx         dw	?
regs_cx         dw	?
regs_dx         dw	?
regs_si         dw	?
regs_di         dw	?
regs_cflag	dw	?		; carry flag.
REGS		ENDS

SREGS		STRUC
sregs_es	dw	?
sregs_cs	dw	?
sregs_ss	dw	?
sregs_ds	dw	?
SREGS		ENDS

UCODE	SEGMENT WORD PUBLIC 'CODE'
UCODE	ENDS

	include ..\inc\usegs.inc

_DATA	SEGMENT
_DATA	ENDS

UCODE	SEGMENT

SaveSs	dw	?
SaveSp	dw	?

Flags	dw	0			; bitflags, as follows.
FLAGS_IN_ISR	=	0001h		; we are already receiving a pkt.

;	Statistics we maintain.

Statistics	label	dword		; start of statistics buffer.
DroppedPackets	dd	0		; 32-bit counter of packets we drop.

;	User pointers.

UserCopyComplete dw	OFFSET CGROUP:NullRtn, CGROUP ; FWA, user rcv cmplt rtn.
UserGetBuf	dw	OFFSET CGROUP:NullRtn, CGROUP ; FWA, user getbuf rtn.

;	The following structure and table is used to maintain a virtual
;	handle to packet drivers and their associated handles.	This way
;	the application never sees the ugly idea of an interrupt number.

PDHTE		STRUC			; packet driver handle table entry.
pdhte_ept	dd	?		; FAR FWA, packet driver entrypoint.
pdhte_pdhandle	dw	?		; handle assigned by packet driver.
PDHTE		ENDS

PDHTBL_SIZE	= 32
PdhTbl	db	(PDHTBL_SIZE*(SIZE PDHTE)) dup (0) ; packet driver handle table.

;	Stuff for PdOpen.

PktDrvrTxt db	'PKT DRVR', 0		; packet driver signature.
TypeSpec   db	  32 dup (0)

UCODE	ENDS

ISRSTACK SEGMENT PARA PUBLIC 'ISRX'
Stack1	db	4096 dup ('$')		; stack for use in ISR.
STACK_LENGTH =	($-Stack1)
ISRSTACK ENDS

UCODE	SEGMENT

;***	Delay - Delay Between Back-To-Back I/O Port Access.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine kills some time so we can let a peripheral
;	recover after an access to an I/O port.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	92/07/03.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Delay
	jmp	Delay_1
Delay_1:
	jmp	Delay_2
Delay_2:
	jmp	Delay_3
Delay_3:
	jmp	Delay_4
Delay_4:
EndProc Delay

;***	_tick - Tick speaker to indicate packet arrival.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called to cause the speaker to "tick", indicating
;	the arrival of an incoming packet on the network.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_tick
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

	cli				; ENTER BIGTIME CRITICAL SECTION.
	in	al, 61h                 ; read port B of the 8255 chip.
	and	al, 0feh		; turn off the 8253 timer bit.
	or	al, 2			; turn on the speaker bit.
	out	61h, al                 ; write back to port B.

	mov	cx, 30
tick_loop:
	loop	tick_loop		; timed delay (ugly, but fine for a tick).

	and	al, 0fdh		; turn off the speaker bit.
	out	61h, al                 ; write back to port B.
	sti				; LEAVING BIGTIME CRITICAL SECTION.

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_tick

;***	_readtime - Return time in ticks.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine returns the BIOS timestamp in 100us units.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;	S. E. Jones	92/07/03.	Added Delay calls.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	DX:AX	- time since midnite in 100us counts.
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_readtime
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es
	mov	ax, 40h
	mov	ds, ax			; (DS) = seg FWA, BIOS DATA AREA.

;	Now read the 8253's channel 0 timer value, which is in 0.8380966us units.

	cli				; don't allow latency here.
	mov	al, 00000000b		; (AL) = latch command.
	out	43h, al                 ; latch the data.
	Pcall	Delay			; allow I/O port to recover.
	in	al, 40h                 ; now read the ports.
	Pcall	Delay			; allow I/O port to recover.
	mov	ah, al
	in	al, 40h
	xchg	ah, al			; (AX) = 16-bit timer 0 data.
	neg	ax			; count-up, not down.
	mov	si, ax			; save fast 16-bit timer value (T0).

;	Read the 55ms timestamp in low memory (counter of timer 0 timeouts).

	mov	ax, word ptr ds:[006ch+0] ; get low 16-bits of this number.
	mov	dx, word ptr ds:[006ch+2] ; get high 16-bits of this number.
	sti				; reallow interrupt latency.

;	We now have a 48-bit number:  DX:AX:SI.  What we need to do is
;	divide this whole thing by (1193/100).	That gives us 100us units.
;	Because the high 10 bits of DX are 0, and because we will be dividing
;	by nearly 8 bits of precision, this number can be stored in a 32-bit
;	result (DX:AX).

	mov	cx, 119
	div	cx			; (AX) = 16-bit high half of number.
	push	ax			; save high quotient.
	mov	ax, si			; (DX:AX) = low 32-bits of dividend.
	div	cx			; (AX) = 16-bit low half of number.
	pop	dx			; (DX:AX) = 32-bit quotient.

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_readtime

;***	_PdSetEventHandler - Set Event Handler.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine sets the event handler for the specified event type.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	[P0]	- event type: (0=GETBUF, 1=COPY COMPLETE).
;	[P1,P2] - FAR FWA, event service routine.
;
;   EXIT.
;	AX	- status code (0=success).
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_PdSetEventHandler
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es
	les	di, [P1]		; (ES:DI) = FWA, user routine.

;	If he specified a NULL pointer, then point to a dummy routine.

	mov	ax, es			; (AX) = segment value.
	or	ax, ax			; is it zero?
	jnz	@f			; if not, this isn't a NULL rtn.
	mov	ax, CGROUP
	mov	es, ax
	lea	di, CGROUP:NullRtn	; (ES:DI) = FWA, null routine.
@@:

	sub	ax, ax			; assume success.
	mov	bx, [P0]		; (BX) = MAC number.
	or	bx, bx			; is it GETBUF?
	jz	PdSetEventHandler_GetBuf; if so.

	cmp	bx, 1			; is it COPY COMPLETE?
	je	PdSetEventHandler_CopyComplete ; if so.

	mov	ax, PDSTATUS_BAD_COMMAND; if event type not in range.
	jmp	SHORT PdSetEventHandler_Exit

PdSetEventHandler_GetBuf:
	cli				; BEGIN CRITICAL SECTION.
	mov	cs:[UserGetBuf.lo], di
	mov	cs:[UserGetBuf.hi], es
	sti				; END CRITICAL SECTION.
	jmp	SHORT PdSetEventHandler_Exit

PdSetEventHandler_CopyComplete:
	cli				; BEGIN CRITICAL SECTION.
	mov	cs:[UserCopyComplete.lo], di
	mov	cs:[UserCopyComplete.hi], es
	sti				; END CRITICAL SECTION.

;	Return with status in (AX).

PdSetEventHandler_Exit:
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_PdSetEventHandler

;***	_PdResetStatistics - Reset Interface Statistics.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine resets our own interface statistics.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	AX	- status code (0=success).
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_PdResetStatistics
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

	mov	cs:[DroppedPackets.lo], 0
	mov	cs:[DroppedPackets.hi], 0

;	Return with status in (AX).

PdResetStatistics_Exit:
	sub	ax, ax			; indicate success.
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_PdResetStatistics

;***	_PdGetStatistics - Get Interface Statistics.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine reads our interface statistics.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	[P0,P1] - FWA, buffer to store statistics into.
;	[P2]	- length of statistics buffer in bytes.
;
;   EXIT.
;	AX	- status code (0=success).
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_PdGetStatistics
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

	cld				; forward string copy.
	les	di, [P0]		; (ES:DI) = destination statistics buffer.
	push	cs
	pop	ds
	lea	si, CGROUP:Statistics	; (DS:SI) = source statistics buffer.
	mov	cx, [P2]		; (CX) = # bytes to copy.
	shr	cx, 1
	rep	movsw			; copy words at a time.
	rcl	cx, 1
	rep	movsb			; copy remaining byte.

;	Return with status in (AX).

PdGetStatistics_Exit:
	sub	ax, ax			; indicate success.
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_PdGetStatistics

;***	_PdOpen - Open Packet Driver and Return Handle.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine opens the underlying packet driver and returns a
;	virtual handle to that driver.	Multiple handles may be opened
;	to the same driver.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	[P0]	- MAC number (0-32).
;	[P1,P2] - FAR FWA, location to store handle if successful.
;
;   EXIT.
;	AX	- status code (0=success).
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_PdOpen
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

;	Now open the MAC.

	mov	bx, [P0]		; (BX) = MAC number.
	mov	ax, PDSTATUS_BAD_HANDLE ; if MAC number invalid.
	cmp	bx, 32			; is it too big?
	jb	@f			; if not, continue.
	jmp	PdOpen_Exit		; if so.

@@:	add	bx, 60h                 ; (BX) = interrupt vector number.
	add	bx, bx
	add	bx, bx			; (BX) = index into real-mode IVT.
	sub	ax, ax
	mov	es, ax			; (ES:BX) = FWA, vector table entry.
	les	bx, es:[bx]		; (ES:BX) = FWA, driver header.
	lea	di, [bx+3]		; (ES:DI) = FWA, "PKT DRVR" if valid.
	push	cs
	pop	ds
	ASSUME	DS:CGROUP
	lea	si, CGROUP:PktDrvrTxt	; (DS:SI) = FWA, "PKT DRVR" string.
	mov	cx, 8
	repe	cmpsb
	mov	ax, PDSTATUS_BAD_HANDLE ; (AX) = status code if failure.
	jne	PdOpen_Exit		; if invalid driver.

;	Scan our handle table looking for a free handle table entry.

	lea	si, CGROUP:PdhTbl	; (CS:SI) = FWA, 1st entry in table.
	mov	cx, PDHTBL_SIZE         ; (CX) = # entries to scan.
	cli				; BEGIN CRITICAL SECTION.
@@:	cmp	word ptr cs:pdhte_ept.hi.[si], 0 ; is this entry in use?
	je	@f			; if not, we found a free entry.
	add	si, (SIZE PDHTE)	; (CS:SI) = FWA, next entry.
	loop	@b
	mov	ax, PDSTATUS_NO_SPACE	; indicate no resources.
	jmp	SHORT PdOpen_Exit	; return with failure.

;	Save FWA, MAC interface entrypoint.

@@:	mov	cs:pdhte_ept.lo.[si], bx
	mov	cs:pdhte_ept.hi.[si], es
	sti				; END CRITICAL SECTION.
	push	si			; save FWA, PDHTE around call.

;	Build INTERRUPT RETURN FRAME on stack to call packet driver.

	pushf
	push	cs
	lea	ax, CGROUP:PdOpen_Ret
	push	ax			; push FAR return address on stack.

;	Save FAR pointer to packet driver entrypoint so we can RETF, below.

	push	es
	push	bx

;	Load parameters into registers.

	mov	ah, 2			; ACCESS TYPE function code.
	mov	al, 1			; CLASS = 1, meaning 802.3/Ethernet.
	mov	bx, 0ffffh		; TYPE = wildcard (any type).
	mov	dl, 0			; INTERFACE = first available interface.
	lea	si, CGROUP:TypeSpec	; (DS:SI) = FWA, type buffer.
	mov	cx, 0			; (CX) = match packets of all types.
	push	cs
	pop	es
	lea	di, CGROUP:PacketReceiver ; (ES:DI) = FWA, packet receiver rtn.
	retf				; call packet driver.
PdOpen_Ret:				; back from packet driver.
	pop	si			; (SI) = saved FWA, PDHTE.
	jc	PdOpen_TranError	; if failure.

;	Store packet driver handle in our handle table.  Then return
;	the OFFSET of our HANDLE TABLE ENTRY.

	mov	word ptr cs:pdhte_pdhandle.[si], ax ; store MAC handle.

	les	di, [P1]		; (ES:DI) = FWA, storage for handle.
	mov	word ptr es:[di], si	; store OUR handle in user space.
	sub	ax, ax			; indicate success.
	jmp	SHORT PdOpen_Exit	; return with success.

PdOpen_TranError:
	mov	word ptr cs:pdhte_ept.hi.[si], 0 ; clear handle table entry.
	mov	word ptr cs:pdhte_ept.lo.[si], 0
	mov	al, dh
	mov	ah, 0			; (AX) = error code, because CY set.

;	Return with status in (AX).

PdOpen_Exit:
	sti				; END CRITICAL SECTION.
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
EndApi	_PdOpen

;***	_PdClose - Close Packet Driver Handle.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine closes the packet driver interface attached to
;	the specified handle.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	[P0]	- handle.
;
;   EXIT.
;	AX	- status code (0=success).
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_PdClose
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es
	mov	si, [P0]		; (SI) = handle number (OFS FWA, PDHTE).

;	Build INTERRUPT RETURN FRAME on stack to call packet driver.

	pushf
	push	cs
	lea	cx, CGROUP:PdClose_Ret
	push	cx			; push FAR return address on stack.

;	Save FAR address of pkt driver entrypoint on stack.

	push	cs:pdhte_ept.hi.[si]
	push	cs:pdhte_ept.lo.[si]

;	Load parameters into registers.

	mov	ah, 3			; RELEASE TYPE function code.
	mov	bx, cs:pdhte_pdhandle.[si] ; (BX) = MAC handle.
	retf				; call packet driver.
PdClose_Ret:				; back from packet driver.
	jc	PdClose_TranError	; if failure.
	mov	si, [P0]		; (CS:SI) = FWA, PDHTE to close.
	mov	word ptr cs:pdhte_ept.lo.[si], 0 ; CLEAR OUT THIS PDHTE.
	mov	word ptr cs:pdhte_ept.hi.[si], 0 ; DITTO.
	sub	ax, ax			; indicate success.

;	Return with status in (AX).

PdClose_Exit:
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret				; return to caller.

PdClose_TranError:
	mov	al, dh
	mov	ah, 0			; (AX) = error code, because CY set.
	jmp	SHORT PdClose_Exit	; return with failure.
EndApi	_PdClose

;***	_PdGetAddress - Get Our Own Ethernet Address.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine instructs the underlying MAC to return the burned-in
;	Ethernet address of the adapter.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/07/25.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	[P0]	- open handle to MAC interface.
;	[P1,P2] - FWA, buffer to store address in.
;	[P3]	- length of buffer in bytes (should be 6 for Ethernet).
;
;   EXIT.
;	AX	- status code (0=success).
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_PdGetAddress
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

	mov	si, [P0]		; (SI) = handle number (OFS FWA, PDHTE).

;	Build INTERRUPT RETURN FRAME on stack to call packet driver.

	pushf
	push	cs
	lea	cx, CGROUP:PdGetAddress_Ret
	push	cx			; push FAR return address on stack.

;	Save FAR address of pkt driver entrypoint on stack.

	push	cs:pdhte_ept.hi.[si]
	push	cs:pdhte_ept.lo.[si]

;	Load parameters into registers.

	mov	ah, 6			; GET ADDRESS function code.
	mov	bx, cs:pdhte_pdhandle.[si] ; (BX) = MAC handle.
	les	di, [P1]		; (ES:DI) = FWA, address buffer.
	mov	cx, [P3]		; (CX) = length of packet in bytes.
	retf				; call packet driver.
PdGetAddress_Ret:			; back from packet driver.
	jc	PdGetAddress_Error	; if failure.
	sub	ax, ax			; indicate success.

;	Return with status in (AX).

PdGetAddress_Exit:
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret				; return to caller.

PdGetAddress_Error:
	mov	al, dh
	mov	ah, 0			; (AX) = error code, because CY set.
	jmp	SHORT PdGetAddress_Exit ; return with failure.
EndApi	_PdGetAddress

;***	_PdSend - Send Packet.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine instructs the underlying MAC to send a packet.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/07/25.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	[P0]	- open handle to MAC interface.
;	[P1,P2] - FWA, buffer to transmit as a packet.
;	[P3]	- length of packet in bytes (octets).
;
;   EXIT.
;	AX	- status code (0=success).
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_PdSend
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

	mov	si, [P0]		; (SI) = handle number (OFS FWA, PDHTE).

;	Build INTERRUPT RETURN FRAME on stack to call packet driver.

	pushf
	push	cs
	lea	cx, CGROUP:PdSend_Ret
	push	cx			; push FAR return address on stack.

;	Save FAR address of pkt driver entrypoint on stack.

	push	cs:pdhte_ept.hi.[si]
	push	cs:pdhte_ept.lo.[si]

;	Load parameters into registers.

	mov	ah, 4			; SEND PACKET function code.
	mov	bx, cs:pdhte_pdhandle.[si] ; (BX) = MAC handle.
	lds	si, [P1]		; (DS:SI) = FWA, packet buffer.
	mov	cx, [P3]		; (CX) = length of packet in bytes.
	retf				; call packet driver.
PdSend_Ret:				; back from packet driver.
	jc	PdSend_Error		; if failure.
	sub	ax, ax			; indicate success.

;	Return with status in (AX).

PdSend_Exit:
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret				; return to caller.

PdSend_Error:
	mov	al, dh
	mov	ah, 0			; (AX) = error code, because CY set.
	jmp	SHORT PdSend_Exit	; return with failure.
EndApi	_PdSend

;***	_PdSetRcvMode - Set MAC's Receive Mode.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine instructs the underlying MAC to change the receive
;	filter used to catch incoming packets.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	[P0]	- open handle to MAC interface.
;	[P1]	- desired receive mode, as follows:
;		  1 - turn off receiver.
;		  2 - receive only directed packets.
;		  3 - mode 2 plus broadcast packets.
;		  4 - mode 3 plus limited multicast packets.
;		  5 - mode 3 plus all multicast packets.
;		  6 - all packets (PROMISCUOUS).
;
;   EXIT.
;	AX	- status code (0=success).
;
;   USES.
;	All but SI, DI, DS, ES, and BP.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	_PdSetRcvMode
	push	bp
	mov	bp, sp
	push	si
	push	di
	push	ds
	push	es

	mov	si, [P0]		; (SI) = handle number (OFS FWA, PDHTE).

;	Build INTERRUPT RETURN FRAME on stack to call packet driver.

	pushf
	push	cs
	lea	cx, CGROUP:PdSetRcvMode_Ret
	push	cx			; push FAR return address on stack.

;	Save FAR address of pkt driver entrypoint on stack.

	push	cs:pdhte_ept.hi.[si]
	push	cs:pdhte_ept.lo.[si]

;	Load parameters into registers.

	mov	ah, 20			; SET RCV MODE function code.
	mov	bx, cs:pdhte_pdhandle.[si] ; (BX) = MAC handle.
	mov	cx, [P1]		; (CX) = new packet reception mode.
	retf				; call packet driver.
PdSetRcvMode_Ret:			; back from packet driver.
	jc	PdSetRcvMode_TranError	; if failure.
	sub	ax, ax			; indicate success.

;	Return with status in (AX).

PdSetRcvMode_Exit:
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret				; return to caller.

PdSetRcvMode_TranError:
	mov	al, dh
	mov	ah, 0			; (AX) = error code, because CY set.
	jmp	SHORT PdSetRcvMode_Exit ; return with failure.
EndApi	_PdSetRcvMode

;***	PacketReceiver - Packet Receive Routine (Called by Packet Drivers).
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by the packet driver(s) to notify the upper
;	layer of a received packet.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;
;   WARNINGS.
;	This routine is called as an interrupt routine and may be reentered.
;
;   ENTRY.
;	AX	- 0 for buffer query call, 1 to indicate copy completed.
;	BX	- handle from MAC.
;	CX	- length of buffer in bytes.
;	DS:SI	- if AX=1, this is the FWA, buffer that was copied.
;
;   EXIT.
;	CY	- set if failure, else clear if success.
;	DH	- returned status if failure.
;
;   USES.
;	Some.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefApi	PacketReceiver
	cli				; BEGIN HARD CRITICAL SECTION.
	test	Flags, FLAGS_IN_ISR	; are we already inside this routine?
	jnz	PacketReceiver_Drop	; if so.
	or	Flags, FLAGS_IN_ISR	; now we are.

;	Switch over to our own stack.

	mov	SaveSs, ss
	mov	SaveSp, sp		; save caller's stack.
	mov	bx, ISRSTACK
	mov	ss, bx
	mov	sp, (STACK_LENGTH-2)
	sti				; ENABLE INTERRUPTS FROM HERE ON OUT.

	push	ds
	cld				; forward direction.
	or	ax, ax			; is this a "query buffer" indication?
	jnz	PacketReceiver_Complete ; if not, it's a copy complete.

	mov	ax, DGROUP
	mov	ds, ax			; (DS) = DGROUP.
	cld				; forward string moves.
	push	cx			; pass length of buffer in bytes.
	call	dword ptr cs:[UserGetBuf] ; call C's getbuf routine.
	add	sp, 2			; dump length of buffer.
	mov	es, dx
	mov	di, ax			; (ES:DI) = new buffer FWA, (or 0L).
	sub	dh, dh			; (DH) = 0 (indicating success).
	pop	ds

;	Restore interrupted routine's stack.

PacketReceiver_Exit:
	cli				; BEGIN HARD CRITICAL SECTION.
	mov	ss, SaveSs		; restore user's stack.
	mov	sp, SaveSp
	and	Flags, NOT FLAGS_IN_ISR ; we're out of the ISR.
	sti				; END HARD CRITICAL SECTION.

;	Return with success.

	clc				; indicate success.
	retf				; return to MAC.

PacketReceiver_Complete:
	push	ds
	push	si			; pass FWA, filled user buffer.
	mov	ax, DGROUP
	mov	ds, ax			; (DS) = DGROUP.
	cld				; forward string moves.
	call	dword ptr cs:[UserCopyComplete] ; call C's getbuf routine.
	add	sp, 4			; dump buffer FWA.
	sub	dh, dh			; (DH) = 0 (indicating success).
	pop	ds
	jmp	SHORT PacketReceiver_Exit

;	Come here because we're dropping a packet on the floor.  We can't
;	reenter this routine as our C code is non-reentrant.

PacketReceiver_Drop:
	add	cs:[DroppedPackets.lo], 1
	adc	cs:[DroppedPackets.hi], 0 ; increment dropped packets.
	sub	di, di
	mov	es, di			; (ES:DI) = 0:0, meaning no space.
	sub	dh, dh			; (DH) = 0, meaning success.
	mov	ah, 0eh                 ; (AH) = WRITE TTY function.
	mov	al, 7			; (AL) = BELL.
	mov	bx, 7			; active page/attribute.
	sti				; END HARD CRITICAL SECTION.
	int	10h			; call VIDEO BIOS to BEEP.
	stc				; indicate FAILURE.
	retf				; return to MAC.
EndApi	PacketReceiver

;***	NullRtn - Dummy Receive Complete Routine/GetBuf Routine.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is called by PacketReceiver because there is no getbuf
;	routine specified by the user yet.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	91/12/16.	Original.
;
;   WARNINGS.
;	This routine is called as an interrupt routine and may be reentered.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	DX:AX	- 0.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc NullRtn
	sub	dx, dx
	sub	ax, ax
EndProc NullRtn

;***	_Breakpoint() - Perform INT 03 breakpoint instruction.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine performs an INT 03 breakpoint.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/01/11.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc _Breakpoint, PUBLIC, FAR
	int	3
EndProc _Breakpoint
UCODE	ENDS
	END
