//***	IPCP.H -- IPC Protocol Definitions.
//
//1.	Functional Description.
//	This include file contains frame formats for the inter-
//	process communication (IPC) protocol employed by Embedded LAN.
//	Some basic rules for fields:
//
//	1. When a request fails, the response is returned but not the
//	data that would ordinarily come with it.
//
//	2. All response fields are invalid if the status field is nonzero.
//
//	3. All string arrays (FSP_FILENAME, etc.) are ASCIIZ (0-byte terminated).
//	Strings have case-sensitivity.
//
//	4. All words & doublewords are little-endian format (byte reversed).
//
//	5. Unsigned short Boolean fields are 0 if FALSE, otherwise TRUE.
//
//2.	Modification History.
//	S. E. Jones	93/01/30.	Original for Embedded LAN.
//	S. E. Jones	93/03/14.	#1.101, Cloned from FSP.H.
//
//3.	NOTICE: Copyright (C) 1993 General Software, Inc.

#ifndef _IPCP
#define _IPCP

#define IPC_NAME_LENGTH         64

typedef unsigned char IPC_NAME [IPC_NAME_LENGTH], **PIPCP_NAME;

typedef unsigned short IPC_STATUS, *PIPC_STATUS;

typedef unsigned short IPC_HANDLE, *PIPC_HANDLE;

//
// Create queue protocol.
//

typedef struct _IPC_REQ_CREATE_Q {
    IPC_NAME QueueName;
} IPC_REQ_CREATE_Q, *PIPC_REQ_CREATE_Q;

typedef struct _IPC_RSP_CREATE_Q {
    IPC_STATUS Status;
    IPC_HANDLE Handle;
} IPC_RSP_CREATE_Q, *PIPC_RSP_CREATE_Q;

//
// Open queue protocol.
//

typedef struct _IPC_REQ_OPEN_Q {
    IPC_NAME QueueName;
    USHORT Flags;
} IPC_REQ_OPEN_Q, *PIPC_REQ_OPEN_Q;

typedef struct _IPC_RSP_OPEN_Q {
    IPC_STATUS Status;
    IPC_HANDLE Handle;
} IPC_RSP_OPEN_Q, *PIPC_RSP_OPEN_Q;

//
// Close queue protocol.
//

typedef struct _IPC_REQ_CLOSE_Q {
    IPC_HANDLE Handle;
} IPC_REQ_CLOSE_Q, *PIPC_REQ_CLOSE_Q;

typedef struct _IPC_RSP_CLOSE_Q {
    IPC_STATUS Status;
} IPC_RSP_CLOSE_Q, *PIPC_RSP_CLOSE_Q;

//
// Push queue protocol.
//

typedef struct _IPC_REQ_PUSH_Q {
    IPC_HANDLE Handle;
    ULONG Datum;
} IPC_REQ_PUSH_Q, *PIPC_REQ_PUSH_Q;

typedef struct _IPC_RSP_PUSH_Q {
    IPC_STATUS Status;
} IPC_RSP_PUSH_Q, *PIPC_RSP_PUSH_Q;

//
// Append queue protocol.
//

typedef struct _IPC_REQ_APPEND_Q {
    IPC_HANDLE Handle;
    ULONG Datum;
} IPC_REQ_APPEND_Q, *PIPC_REQ_APPEND_Q;

typedef struct _IPC_RSP_APPEND_Q {
    IPC_STATUS Status;
} IPC_RSP_APPEND_Q, *PIPC_RSP_APPEND_Q;

//
// Pop queue protocol.
//

typedef struct _IPC_REQ_POP_Q {
    IPC_HANDLE Handle;
} IPC_REQ_POP_Q, *PIPC_REQ_POP_Q;

typedef struct _IPC_RSP_POP_Q {
    IPC_STATUS Status;
    ULONG Datum;
} IPC_RSP_POP_Q, *PIPC_RSP_POP_Q;

//
// Create message port protocol.
//

typedef struct _IPC_REQ_CREATE_MSGPORT {
    IPC_NAME MsgPortName;
} IPC_REQ_CREATE_MSGPORT, *PIPC_REQ_CREATE_MSGPORT;

typedef struct _IPC_RSP_CREATE_MSGPORT {
    IPC_STATUS Status;
    IPC_HANDLE Handle;
} IPC_RSP_CREATE_MSGPORT, *PIPC_RSP_CREATE_MSGPORT;

//
// Open message port protocol.
//

typedef struct _IPC_REQ_OPEN_MSGPORT {
    IPC_NAME MsgPortName;
    USHORT Flags;
} IPC_REQ_OPEN_MSGPORT, *PIPC_REQ_OPEN_MSGPORT;

typedef struct _IPC_RSP_OPEN_MSGPORT {
    IPC_STATUS Status;
    IPC_HANDLE Handle;
} IPC_RSP_OPEN_MSGPORT, *PIPC_RSP_OPEN_MSGPORT;

//
// Close message port protocol.
//

typedef struct _IPC_REQ_CLOSE_MSGPORT {
    IPC_HANDLE Handle;
} IPC_REQ_CLOSE_MSGPORT, *PIPC_REQ_CLOSE_MSGPORT;

typedef struct _IPC_RSP_CLOSE_MSGPORT {
    IPC_STATUS Status;
} IPC_RSP_CLOSE_MSGPORT, *PIPC_RSP_CLOSE_MSGPORT;

//
// Send message port protocol.	Data is sent as a separate record
// following the command message.
//

typedef struct _IPC_REQ_SEND_MSGPORT {
    IPC_HANDLE Handle;
    USHORT MsgLength;
    USHORT Flags;
} IPC_REQ_SEND_MSGPORT, *PIPC_REQ_SEND_MSGPORT;

typedef struct _IPC_RSP_SEND_MSGPORT {
    IPC_STATUS Status;
} IPC_RSP_SEND_MSGPORT, *PIPC_RSP_SEND_MSGPORT;

//
// Receive message port protocol.  Data is transmitted by respondant
// after respondant sends the response message, as a separate message.
//

typedef struct _IPC_REQ_RECEIVE_MSGPORT {
    IPC_HANDLE Handle;
    USHORT BufferLength;
    USHORT Flags;
} IPC_REQ_RECEIVE_MSGPORT, *PIPC_REQ_RECEIVE_MSGPORT;

typedef struct _IPC_RSP_RECEIVE_MSGPORT {
    IPC_STATUS Status;
    USHORT BytesTransferred;
} IPC_RSP_RECEIVE_MSGPORT, *PIPC_RSP_RECEIVE_MSGPORT;

//
// Generic request type.
//

typedef struct _IPC_FRAME {
    ULONG Signature;

#define IPC_FRAME_SIGNATURE	0x495043ffL	// 'IPC'+0xff.

    USHORT Cmd;

#define IPC_FRAME_REQ_NULL		0	// do nothing.
#define IPC_FRAME_RSP_NULL		1	// do nothing.

#define IPC_FRAME_REQ_CREATE_Q		2	// create queue.
#define IPC_FRAME_RSP_CREATE_Q		3	// create queue.

#define IPC_FRAME_REQ_OPEN_Q		4	// open queue.
#define IPC_FRAME_RSP_OPEN_Q		5	// open queue.

#define IPC_FRAME_REQ_CLOSE_Q		6	// close queue.
#define IPC_FRAME_RSP_CLOSE_Q		7	// close queue.

#define IPC_FRAME_REQ_PUSH_Q		8	// push queue.
#define IPC_FRAME_RSP_PUSH_Q		9	// push queue.

#define IPC_FRAME_REQ_APPEND_Q		10	// append to queue.
#define IPC_FRAME_RSP_APPEND_Q		11	// append to queue.

#define IPC_FRAME_REQ_POP_Q		12	// pop from queue.
#define IPC_FRAME_RSP_POP_Q		13	// pop from queue.

#define IPC_FRAME_REQ_CREATE_MSGPORT	14	// create message port.
#define IPC_FRAME_RSP_CREATE_MSGPORT	15	// create message port.

#define IPC_FRAME_REQ_OPEN_MSGPORT	16	// open message port.
#define IPC_FRAME_RSP_OPEN_MSGPORT	17	// open message port.

#define IPC_FRAME_REQ_CLOSE_MSGPORT	18	// close message port.
#define IPC_FRAME_RSP_CLOSE_MSGPORT	19	// close message port.

#define IPC_FRAME_REQ_SEND_MSGPORT	20	// send message port.
#define IPC_FRAME_RSP_SEND_MSGPORT	21	// send message port.

#define IPC_FRAME_REQ_RECEIVE_MSGPORT	22	// receive message port.
#define IPC_FRAME_RSP_RECEIVE_MSGPORT	23	// receive message port.

    union {
	IPC_REQ_CREATE_Q IpcCreateQueueReq;
	IPC_RSP_CREATE_Q IpcCreateQueueRsp;

	IPC_REQ_OPEN_Q IpcOpenQueueReq;
	IPC_RSP_OPEN_Q IpcOpenQueueRsp;

	IPC_REQ_CLOSE_Q IpcCloseQueueReq;
	IPC_RSP_CLOSE_Q IpcCloseQueueRsp;

	IPC_REQ_PUSH_Q IpcPushQueueReq;
	IPC_RSP_PUSH_Q IpcPushQueueRsp;

	IPC_REQ_APPEND_Q IpcAppendQueueReq;
	IPC_RSP_APPEND_Q IpcAppendQueueRsp;

	IPC_REQ_POP_Q IpcPopQueueReq;
	IPC_RSP_POP_Q IpcPopQueueRsp;

	IPC_REQ_CREATE_MSGPORT IpcCreateMsgPortReq;
	IPC_RSP_CREATE_MSGPORT IpcCreateMsgPortRsp;

	IPC_REQ_OPEN_MSGPORT IpcOpenMsgPortReq;
	IPC_RSP_OPEN_MSGPORT IpcOpenMsgPortRsp;

	IPC_REQ_CLOSE_MSGPORT IpcCloseMsgPortReq;
	IPC_RSP_CLOSE_MSGPORT IpcCloseMsgPortRsp;

	IPC_REQ_SEND_MSGPORT IpcSendMsgPortReq;
	IPC_RSP_SEND_MSGPORT IpcSendMsgPortRsp;

	IPC_REQ_RECEIVE_MSGPORT IpcReceiveMsgPortReq;
	IPC_RSP_RECEIVE_MSGPORT IpcReceiveMsgPortRsp;

    } Operands;
} IPC_FRAME, *PIPC_FRAME;

#endif // _IPCP
