;***	UMACROS.INC -- STARLITE Macro Definitions For User Programs.
;
;1.	Functional Description.
;	This include file contains definitions for macros used by
;	user programs running under STARLITE.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/11/19.	#1.094, added priorities, long threads.
;	S. E. Jones	92/01/06.	#1.095, FREE->DEALLOCATE in SYS_xxx.
;	S. E. Jones	92/01/24.	#1.095, fixed p-call macro for MASM600.
;
;3.	NOTICE: Copyright (C) 1990, 1991, 1992 General Software, Inc.
;
;4.	Build Environment.
;	MASM 5.10.

LJA	MACRO	lab
	LOCAL	lja_biff
	jna	lja_biff
	jmp	lab
lja_biff:
	ENDM

LJB	MACRO	lab
	LOCAL	ljb_biff
	jnb	ljb_biff
	jmp	lab
ljb_biff:
	ENDM

LJZ	MACRO	lab
	LOCAL	ljz_biff
	jnz	ljz_biff
	jmp	lab
ljz_biff:
	ENDM

LJNZ	MACRO	lab
	LOCAL	ljnz_biff
	jz	ljnz_biff
	jmp	lab
ljnz_biff:
	ENDM

LJE	MACRO	lab
	LOCAL	lje_biff
	jne	lje_biff
	jmp	lab
lje_biff:
	ENDM

LJNE	MACRO	lab
	LOCAL	ljne_biff
	je	ljne_biff
	jmp	lab
ljne_biff:
	ENDM

LJC	MACRO	lab
	LOCAL	ljc_biff
	jnc	ljc_biff
	jmp	lab
ljc_biff:
	ENDM

LJNC	MACRO	lab
	LOCAL	ljnc_biff
	jc	ljnc_biff
	jmp	lab
ljnc_biff:
	ENDM

;***	DISABLE - Disable Interrupts.
;

DISABLE MACRO
	cli
	ENDM

;***	ENABLE - Enable Interrupts.
;

ENABLE	MACRO
	sti
	ENDM

;***	DefProc - Define subroutine entrypoint.
;
;	This macro takes two optional arguments, which can be interchanged
;	now, but may require an ordering later.  So here is the format.
;	If you want to declare a procedure, use this macro.  By default,
;	the procedure will be NEAR.  If you want the near procedure to
;	be publicly-known, then add ",PUBLIC" as an operand.  If you want
;	a FAR procedure instead, then use ",FAR" as an operand.  If you
;	also want that FAR procedure to be publicly-known, then add ",PUBLIC"
;	to the ",FAR" operand.

DefProc MACRO	name, scope, visibility
	IFIDN	<scope>, <PUBLIC>
	PUBLIC	name
	ENDIF

	IFIDN	<visibility>, <PUBLIC>
	PUBLIC	name
	ENDIF

	IFIDN	<scope>, <FAR>
name	PROC	FAR
	ELSE
	IFIDN	<visibility>, <FAR>
name	PROC	FAR
	ELSE
name	PROC	NEAR
	ENDIF
	ENDIF
	ENDM

;***	EndProc - Mark end of subroutine definition.
;

EndProc MACRO	name
	LOCAL	addr, endprc
	ret			; just in case he doesn't bother.
endprc:
name	ENDP
	ENDM

;***	Pcall - Call local or external procedure.
;

Pcall	MACRO	name, scope
	IFIDNI	<scope>, <FAR>

	IFNDEF	name
	EXTRN	name:FAR
	ENDIF

	ELSE

	IFE	(@Version-510)		; if version == MASM 510, then...
	IF2
	IFNDEF	name
	EXTRN	name:NEAR
	ENDIF
	ENDIF
	ELSE
	IFNDEF	name
	EXTERNDEF name:NEAR		; for C600 and above.
	ENDIF
	ENDIF

	ENDIF

	call	name
	ENDM

;***	DefInterrupt - Define software interrupt handler.
;

DefInterrupt MACRO name
	PUBLIC	name
name	PROC	FAR		; all transfers are FAR.
	ENDM

;***	EndInterrupt - Mark end of software interrupt handler.
;

EndInterrupt MACRO name
	LOCAL	addr, endprc
	iret			; just in case he doesn't bother.
endprc:
name	ENDP
	ENDM

;***	AllocatePool - Allocate Memory From System Pool.
;
;	This macro is used to allocate a chunk of memory from a system
;	pool that user programs cannot fiddle with.  Allocation can be
;	performed at interrupt time on the fly, and is very fast, so
;	this is the kind of memory that should be used for temporary
;	fast work areas.  The memory is always relative to DOSDATA.
;	If successful, the result is returned in DI.  If CY is set
;	on exit, then the call failed.	Otherwise, it succeeded.
;
;	Usage:		AllocatePool  POOLSIZE

AllocatePool MACRO chunksize
	IFIDNI	<chunksize>,<ax>

	push	dx
	mov	dl, SYS_ALLOCATE_POOL
	int	SYSINT
	pop	dx

	ELSE

	push	ax
	push	dx
	mov	ax, chunksize
	mov	dl, SYS_ALLOCATE_POOL
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	ax

	ENDIF
	ENDM

;***	DeallocatePool - Return Memory To System Pool.
;
;	This macro is used to free a chunk of memory back to the system
;	pool that user programs cannot fiddle with.  Deallocation can be
;	performed at interrupt time on the fly, and is very fast, so
;	this is the kind of memory that should be used for temporary
;	fast work areas.  The memory is always relative to DOSDATA.
;	This macro always assumes the memory is pointed to by DI.
;
;	Usage:		DeallocatePool

DeallocatePool MACRO
	push	dx
	mov	dl, SYS_DEALLOCATE_POOL
	int	SYSINT			; call system kernel function.
	pop	dx
	ENDM

;***	KeepPool - Keep Memory (Maintain Extra Reference).
;
;	This macro is used to increment the reference count on a chunk
;	of pool memory so that the next FreePool doesn't actually dispose
;	of it.	The memory is always relative to DOSDATA.  This macro
;	always assumes the memory is pointed to by DI.
;
;	Usage:		KeepPool

KeepPool MACRO
	push	dx
	mov	dl, SYS_KEEP_POOL
	int	SYSINT			; call system kernel function.
	pop	dx
	ENDM

;***	AllocateSpinLock - Allocate Spin (short term) Lock Object.
;
;	This macro is used to allocate a spin lock and store its handle
;	in a specified location.  In the actual implementation, this
;	macro doesn't even call a package, but resets a spinlock to
;	a known state.	The place where we store the handle IS the spinlock.
;
;	Usage:		AllocateSpinLock lock

AllocateSpinLock MACRO lck
	mov	lck, 0			; initialize the lock.
	ENDM

;***	DeallocateSpinLock - Deallocate Spin (short term) Lock Object.
;
;	This macro is used to deallocate a spin lock and return it
;	to the system.	In this implementation, since the user's
;	handle storage actually serves as the lock itself, we don't
;	do anything here at all.  If we change the implementation,
;	then the source can just be recompiled and the DeallocateSpinLock
;	calls will do something meaningful, like deallocating pool.
;
;	Usage:		DeallocateSpinLock lock

DeallocateSpinLock MACRO lck
	mov	lck, 0			; reset the lock.
	ENDM

;***	AcquireSpinLock - Acquire Spin (short term) Lock.
;
;	This macro is used to acquire a spin lock in a multiprocessor system
;	so that access to a mutually-exclusive object can be controlled in
;	an MP-safe way.  To setup a wwspinlock, initialize it with the
;	ALLOCATELOCK macro.  Then to acquire the lock, use this macro.
;	to free up the lock when you're done, use the RELEASELOCK macro.
;
;	Usage:		AcquireSpinLock lock [, scratch-reg]

AcquireSpinLock MACRO lck, scr
	IF	MULTIPROCESSOR
	IFIDN	<scr>,<>

	push	ax
	mov	ax, 1
@@:	xchg	lck, ax
	or	ax, ax
	jnz	@b
	pop	ax

	ELSE

	mov	scr, 1
@@:	xchg	lck, scr
	or	scr, scr
	jnz	@b

	ENDIF
	ENDIF
	ENDM

;***	ReleaseSpinLock - Release Spin (short term) Lock.
;
;	This macro is used to release a spin lock in a multiprocessor system
;	so that access to a mutually-exclusive object can be controlled in
;	an MP-safe way.  To setup a spinlock, initialize it with the
;	INITIALIZELOCK macro.  To acquire the lock, use ACQUIRELOCK.  To
;	free up the lock when you're done, use the RELEASELOCK macro.
;
;	Usage:		ReleaseSpinLock lock

ReleaseSpinLock MACRO lck
	IF	MULTIPROCESSOR
	mov	lck, 0
	ENDIF
	ENDM

;***	AllocateMutex - Allocate a Mutex (long term) Lock.
;
;	This macro is used to allocate a mutex object and return a
;	handle to it.  The macro stores the mutex handle into the
;	specified location.
;
;	Usage:		AllocateMutex mutex

AllocateMutex MACRO mutex
	push	ax
	push	dx

	mov	dl, SYS_ALLOCATE_MUTEX	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	mov	mutex, ax		; store handle to mutex object.

	pop	dx
	pop	ax
	ENDM

;***	DeallocateMutex - Free a Mutex (long term) Lock.
;
;	This macro is used to deallocate a mutex object and return it
;	to the system.
;
;	Usage:		DeallocateMutex mutex

DeallocateMutex MACRO mutex
	push	ax
	push	dx

	mov	ax, mutex		; (AX) = handle to mutex object.
	mov	dl, SYS_DEALLOCATE_MUTEX; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM

;***	AcquireMutex - Acquire Mutex (long term) Lock.
;
;	This macro is used to acquire exclusive access to a mutex object.
;
;	Usage:		AcquireMutex mutex

AcquireMutex MACRO mutex
	push	ax
	push	dx

	mov	ax, mutex		; (AX) = handle to mutex object.
	mov	dl, SYS_ACQUIRE_MUTEX	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM

;***	ReleaseMutex - Release Mutex (long term) Lock.
;
;	This macro is used to release exclusive access to a mutex object.
;
;	Usage:		ReleaseMutex mutex

ReleaseMutex MACRO mutex
	push	ax
	push	dx

	mov	ax, mutex		; (AX) = handle to mutex object.
	mov	dl, SYS_RELEASE_MUTEX	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM

;***	AllocateEvent - Allocate an Event Object.
;
;	This macro is used to allocate an event object and return a
;	handle to it.  The macro stores the event handle into the
;	specified location.
;
;	Usage:		AllocateEvent event

AllocateEvent MACRO event
	push	ax
	push	dx

	mov	dl, SYS_ALLOCATE_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	mov	event, ax		; store handle to event object.

	pop	dx
	pop	ax
	ENDM

;***	DeallocateEvent - Free an Event Object.
;
;	This macro is used to deallocate an event object and return it
;	to the system.
;
;	Usage:		DeallocateEvent event

DeallocateEvent MACRO event
	push	ax
	push	dx

	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_DEALLOCATE_EVENT; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM

;***	SetEvent - Transition Event Object to SET State.
;
;	This macro is used to set an event object.
;
;	Usage:		SetEvent event

SetEvent MACRO	event
	push	ax
	push	dx

	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_SET_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM

;***	ClearEvent - Transition Event Object to CLEARED State.
;
;	This macro is used to clear an event object.
;
;	Usage:		ClearEvent event

ClearEvent MACRO event
	push	ax
	push	dx

	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_CLEAR_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM

;***	PulseEvent - Momentarily Transition Event Object to SET State.
;
;	This macro is used to pulse an event object.
;
;	Usage:		PulseEvent event

PulseEvent MACRO event
	push	ax
	push	dx

	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_PULSE_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM

;***	WaitEvent - Wait On Event Object.
;
;	This macro is used to wait for an event to transition to the set
;	state.	If the event is already set at the time the wait is issued,
;	then execution continues as though the event became set during the wait.
;
;	Usage:		WaitEvent event

WaitEvent MACRO event
	push	ax
	push	dx

	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_WAIT_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM

;***	QueryEvent - Query Event Object.
;
;	This macro is used to return the state of an event object.
;
;	Usage:		QueryEvent event, state

QueryEvent MACRO event, state
	push	ax
	push	dx

	mov	ax, event		; (AX) = handle to event object.
	mov	dl, SYS_QUERY_EVENT	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	mov	state, ax		; store the result.
	pop	dx
	pop	ax
	ENDM

;***	AllocateThread - Allocate a Thread Object.
;
;	This macro is used to allocate a thread object and begin
;	its execution at the specified location.
;
;	Usage:		AllocateThread label

AllocateThread MACRO lab
	push	ax
	push	cx
	push	dx

	lea	ax, lab                 ; (AX) = FWA, CS-relative execution stream.
	mov	cx, cs			; (CX:AX) = FWA, execution stream.
	mov	dl, SYS_ALLOCATE_THREAD ; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	cx
	pop	ax
	ENDM

;***	AllocateThreadLong - Allocate a Thread Object With More Options.
;
;	This macro is used to allocate a thread object and begin
;	its execution with a specified stack and priority.
;
;	Usage:		AllocateThreadLong label, stacksegval, priority

AllocateThreadLong MACRO lab, stkseg, prio
	push	ax
	push	cx
	push	dx
	push	es
	mov	bx, prio		; (BX) = thread priority.
	mov	ax, stkseg
	mov	es, ax			; (ES) = stack segment.
	lea	ax, lab                 ; (AX) = FWA, CS-relative execution stream.
	mov	cx, cs			; (CX:AX) = FWA, execution stream.
	mov	dl, SYS_ALLOCATE_THREAD_LONG ; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	pop	dx
	pop	cx
	pop	ax
	ENDM

;***	DeallocateThread - Free a Thread Object.
;
;	This macro is used to deallocate a thread object and return it
;	to the system.	A thread can only call FreeThread on itself.
;
;	Usage:		DeallocateThread

DeallocateThread MACRO
	mov	dl, SYS_DEALLOCATE_THREAD ; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.
	ENDM

;***	AllocateTimer - Allocate a Timer Object.
;
;	This macro is used to allocate a timer object and initialize
;	its context and expiration routine parameters.
;
;	Usage:		AllocateTimer timer, context, expiration_rtn

AllocateTimer MACRO tmr, ctx, exprtn
	push	ax
	push	bx
	push	cx
	push	dx

	mov	ax, ctx                 ; (AX) = timer routine context.
	mov	bx, cs			; (BX) = seg FWA, expiration rtn.
	mov	cx, exprtn		; (CX) = ofs FWA, expiration rtn.
	mov	dl, SYS_ALLOCATE_TIMER	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	cx
	pop	bx
	mov	tmr, ax                 ; store handle to timer object.
	pop	ax
	ENDM

;***	DeallocateTimer - Free a Timer Object.
;
;	This macro is used to deallocate a timer object and return it
;	to the system.
;
;	Usage:		DeallocateTimer timer

DeallocateTimer MACRO tmr
	push	ax
	push	dx

	mov	ax, tmr                 ; (AX) = handle to timer object.
	mov	dl, SYS_DEALLOCATE_TIMER; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM

;***	StartTimer - Start a Timer Object.
;
;	This macro is used to start a timer object and specify the
;	number of milliseconds before the expiration routine should
;	be executed.
;
;	Usage:		StartTimer timer, deltatime

StartTimer MACRO tmr, delta
	push	ax
	push	cx
	push	dx

	mov	ax, tmr                 ; (AX) = handle to timer object.
	mov	cx, delta		; (CX) = ms until timer shall expire.
	mov	dl, SYS_START_TIMER	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	cx
	pop	ax
	ENDM

;***	StopTimer - Stop a Timer Object.
;
;	This macro is used to stop a timer object.
;
;	Usage:		StopTimer timer

StopTimer MACRO tmr
	push	ax
	push	dx

	mov	ax, tmr                 ; (AX) = handle to timer object.
	mov	dl, SYS_STOP_TIMER	; (DL) = SYSINT function code.
	int	SYSINT			; call system kernel function.

	pop	dx
	pop	ax
	ENDM


;***	BREAKPOINT - Break Into Debugger.
;
;	This macro breaks into the debugger by issuing an INT 3 instruction.

BREAKPOINT MACRO
	int	3
	ENDM

;***	PRINTF - Display Arguments With Formatting.
;
;	This macro prints a formatted string with optional arguments using
;	the routines in the PRINTF.ASM formatting package.  This macro's
;	operation tricky.  It may be used in small or large model programs.
;	If a small model program, then you must have a GROUP of segments
;	that are all treated as one segment by the linker, and you must
;	include the PRINTFMSG segment in the group, or the messages will
;	not be addressable from the PRINTF.ASM package.
;
;	This macro also uses a special calling convention.  It uses a
;	direct calling convention with a word following the INT instruction
;	THAT IS NOT EXECUTED.  Instead, the software interrupt service
;	routine treats this word as data, the offset address of the formatting
;	string to be used.  Before returning to the calling program, the
;	PRINTF.ASM interrupt handler advances its saved instruction pointer
;	over the word so that it is never executed.  This mechanism saves
;	having to use a temporary word of storage

PRINTF	MACRO	str, args
	LOCAL	addr, bytes
bytes	=	0

PRINTFMSG SEGMENT
addr	db	'&str', 0
PRINTFMSG  ENDS

	IRP	OPERAND, <args>
	push	OPERAND
bytes	=	bytes + 2
	ENDM	; (IRP)

	push	bp		; save caller's BP.
	mov	bp, sp		; install stack frame.
	add	bp, bytes	; (BP) = FWA, formatting string address.

	Pcall	PrintfSvc, FAR	; invoke the PRINTF package.
	dw	OFFSET PRINTFMSG:addr ; offset FWA, formatting string.

	pop	bp		; restore caller's BP.
	add	sp, (bytes)	; dump all arguments.
	ENDM

