//***	SYSTEM.H -- STARLITE System Definitions for C Language Programs.
//
//1.	Functional Description.
//	This include file contains macro definitions for status codes and
//	parameters used by the DOS API.
//
//2.	Modification History.
//	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
//
//3.	NOTICE: Copyright (C) 1990, 1991, 1992 General Software, Inc.

//	Type definitions for the DOSERR_xxx codes.

#define STATUS unsigned short
#define PSTATUS unsigned short *

//	Starlite OEM identification.

#define STARLITE_OEM		0x99	// special value returned by DOSGETVERSION.
#define STARLITE_MAJVER         0x03	// major version returned by DOSGETVERSION.
#define STARLITE_MINVER         0x39	// minor version returned by DOSGETVERSION.

//	 Open access modes.

#define OPEN_MODE_READ		0	// open for reading only.
#define OPEN_MODE_WRITE         1	// open for writing only.
#define OPEN_MODE_READ_WRITE	2	// open for both reading and writing.

//	 Seek method codes.

#define SEEK_MODE_BOF		0	// seek from beginning of file.
#define SEEK_MODE_REL		1	// seek relative to current position.
#define SEEK_MODE_EOF		2	// seek from end of file.

//	 File creation attributes (DosCreate).	These are bitflags.

#define CREATE_ATTRIBUTE_NORMAL   0	// file is normal.
#define CREATE_ATTRIBUTE_READONLY 0x0001// file will be made read only.
#define CREATE_ATTRIBUTE_HIDDEN   0x0002// file will be made hidden.
#define CREATE_ATTRIBUTE_SYSTEM   0x0004// file will be marked SYSTEM.
#define CREATE_ATTRIBUTE_NEW	  0x8000// don't overwrite existing file.

//	 Image activator subfunction codes.

#define EXEC_EXECUTE_IMAGE	0	// load and execute program image.
#define EXEC_LOAD_IMAGE         1	// load program image only.
#define EXEC_LOAD_OVERLAY	3	// load overlay image.

//	 Termination codes returned by DOSWAIT.

#define WAIT_NORMAL		0	// normal termination.
#define WAIT_CTRLC		1	// termination by CTRL-C.
#define WAIT_CRITERR		2	// termination by critical device error.
#define WAIT_FUNC31		3	// term. by call to function 31h (TSR).

//	 INT 21H System Service Codes.

#define DOSTERMINATE		0x00	// terminate program.
#define DOSCONINPUT		0x01	// read console character with echo.
#define DOSCONOUTPUT		0x02	// write character to console.
#define DOSAUXINPUT		0x03	// read from AUX device.
#define DOSAUXOUTPUT		0x04	// write to AUX device.
#define DOSPRNOUTPUT		0x05	// write to PRN device.
#define DOSCONIO		0x06	// read/write to console (direct).
#define DOSCONINPUTRAW		0x07	// read raw console char without echo.
#define DOSCONINPUTRAW2         0x08	// read raw console char without echo.
#define DOSCONSTROUTPUT         0x09	// write string to console.
#define DOSCONSTRINPUT		0x0a	// read string from console.
#define DOSCONGETSTATUS         0x0b	// get status of input buffer.
#define DOSCONFLUSH		0x0c	// flush input buffer & exec command.
#define DOSDISKRESET		0x0d	// reset diskette subsystem.
#define DOSSETDEFAULTDRIVE	0x0e	// set default drive number.
#define DOSOPENFCB		0x0f	// open file using FCB.
#define DOSCLOSEFCB		0x10	// close file using FCB.
#define DOSFINDFIRSTFCB         0x11	// find first match using FCB.
#define DOSFINDNEXTFCB		0x12	// find next match using FCB.
#define DOSDELETEFCB		0x13	// delete file using FCB.
#define DOSREADFCB		0x14	// sequential file read using FCB.
#define DOSWRITEFCB		0x15	// sequential file write using FCB.
#define DOSCREATEFCB		0x16	// create file using FCB.
#define DOSRENAMEFCB		0x17	// rename file using FCB.
#define DOSGETLOGIN		0x18	// return login vector (CP/M compatibility).
#define DOSGETDEFAULTDRIVE	0x19	// get default drive using FCB.
#define DOSSETDTA		0x1a	// set disk transfer address for FCB.
#define DOSGETDEFAULTINFO	0x1b	// get allocation info for default drive.
#define DOSGETINFO		0x1c	// get allocation info for specific drive.
#define DOSGETREADONLYVECTOR	0x1d	// get R/O vector (CP/M compatibility).
#define DOSSETFILEATTRIBUTES	0x1e	// set file attr (CP/M compatibility).
#define DOSGETDEFAULTDPB	0x1f	// get ptr to default DPB.
#define DOSUSERCODE		0x20	// get/set user code (CP/M compatibility).
#define DOSRANDOMREADFCB	0x21	// random read on FCB.
#define DOSRANDOMWRITEFCB	0x22	// random write on FCB.
#define DOSGETFILESIZEFCB	0x23	// get size of file on FCB.
#define DOSSETRANDOMRECFCB	0x24	// set random record position on FCB.
#define DOSSETVECTOR		0x25	// set interrupt vector.
#define DOSCREATEPSP		0x26	// create program segment prefix.
#define DOSRANDOMREADBLKFCB	0x27	// random read (block I/O) on FCB.
#define DOSRANDOMWRITEBLKFCB	0x28	// random write (block I/O) on FCB.
#define DOSPARSEFILENAME	0x29	// parse filename in FCB.
#define DOSGETDATE		0x2a	// get system date.
#define DOSSETDATE		0x2b	// set system date.
#define DOSGETTIME		0x2c	// get system time.
#define DOSSETTIME		0x2d	// set system time.
#define DOSSETVERIFY		0x2e	// set disk I/O verify mode on or off.
#define DOSGETDTA		0x2f	// get disk transfer address.
#define DOSGETVERSION		0x30	// get MS-DOS compatibility version #.
#define DOSTSR			0x31	// terminate and stay resident in memory.
#define DOSGETDPB		0x32	// get ptr to DPB.
#define DOSBREAKFLAG		0x33	// get/set break flag for Ctrl-C.
#define DOSGETVAR		0x34	// get DOS variables address.
#define DOSGETVECTOR		0x35	// get interrupt vector.
#define DOSGETDISKFREE		0x36	// get disk free space.
#define DOSSWITCHAR		0x37	// get/set switch character.
#define DOSCOUNTRYINFO		0x38	// get/set country information.
#define DOSCREATEDIR		0x39	// create subdirectory.
#define DOSDELETEDIR		0x3a	// delete subdirectory.
#define DOSSETDIR		0x3b	// set current directory.
#define DOSCREATE		0x3c	// create or truncate file.
#define DOSOPEN                 0x3d	// open file or device.
#define DOSCLOSE		0x3e	// close handle to file or device.
#define DOSREAD                 0x3f	// read file or device.
#define DOSWRITE		0x40	// write file or device.
#define DOSDELETE		0x41	// delete file.
#define DOSSETPOS		0x42	// set file pointer position.
#define DOSFILEATTR		0x43	// get/set file attributes.
#define DOSDEVIOCTL		0x44	// general device I/O control.
#define DOSDUPLICATE		0x45	// duplicate handle.
#define DOSFORCEDUPLICATE	0x46	// force duplicate handle.
#define DOSGETDIR		0x47	// get current directory.
#define DOSALLOCSEG		0x48	// allocate memory segment.
#define DOSFREESEG		0x49	// free memory segment.
#define DOSSIZESEG		0x4a	// change size of memory segment.
#define DOSEXEC                 0x4b	// load/execute program/overlay.
#define DOSEXIT                 0x4c	// terminate process.
#define DOSWAIT                 0x4d	// wait for process to get return code.
#define DOSFINDFIRST		0x4e	// find first file in pattern.
#define DOSFINDNEXT		0x4f	// find next file in pattern.
#define DOSSETPSP		0x50	// set current PSP.
#define DOSGETPSP		0x51	// get current PSP.
#define DOSGETANCHOR		0x52	// get anchor block.
#define DOSBPBTODPB		0x53	// convert BPB to DPB.
#define DOSGETVERIFY		0x54	// get verify flag status.
#define DOSCREATEPSP2		0x55	// create PSP, 2nd version.
#define DOSRENAME		0x56	// rename file.
#define DOSTIMESTAMP		0x57	// get/set file date/time stamp.
#define DOSALLOCSTRAT		0x58	// get/set memory allocation strategy.
#define DOSGETEXTERROR		0x59	// get extended error information.
#define DOSCREATETEMPFILE	0x5a	// create a temporary file.
#define DOSCREATENEWFILE	0x5b	// create a new file.
#define DOSLOCK                 0x5c	// lock/unlock byte range in file.
#define DOSMSNET		0x5d	// MS-NET support.
#define DOSMACHINEINFO		0x5e	// get/set machine name/printer setup.
#define DOSNETWORK		0x5f	// perform network operations.
#define DOSCANNONICALIZEPATH	0x60	// cannonicalize object pathname.
#define DOSGETPSP2		0x62	// get program segment prefix.
#define DOSGETLEADBYTETBL	0x63	// get lead byte table (not in 3.x).
#define DOSGETEXTCOUNTRYINFO	0x65	// get extended country information.
#define DOSGETSETCODEPAGE	0x66	// get or set the current code page.
#define DOSSETHANDLELIMIT	0x67	// set the max. # of handles/curr process.
#define DOSCOMMITFILE		0x68	// commit file to disk.
#define DOSALERT		0x70	// issue alert box and return response.

//	 DOSDEVIOCTL subfunction codes.

#define IOCTL_GET_DEV_INFO	0	// get device information (2.0).
#define IOCTL_SET_DEV_INFO	1	// set device information (2.0).
#define IOCTL_READ_CHARDEV	2	// read control data from char. device (2.0).
#define IOCTL_WRITE_CHARDEV	3	// write control data to char device (2.0).
#define IOCTL_READ_BLKDEV	4	// read control data from block device (2.0).
#define IOCTL_WRITE_BLKDEV	5	// write control data to block device (2.0).
#define IOCTL_CHECK_INPUT_STATUS 6	// check input status (2.0).
#define IOCTL_CHECK_OUTPUT_STATUS 7	// check output status (2.0).
#define IOCTL_CHECK_REMOVABLE	8	// check if block device is removable (3.0).
#define IOCTL_CHECK_REMOTE	9	// check if block device is remote (3.1).
#define IOCTL_CHECK_HANDLE_REMOTE 10	// check if handle is remote (3.1).
#define IOCTL_CHANGE_SHARE_RETRY 11	// change sharing retry count (3.1).
#define IOCTL_GENERIC_CHARDEV	12	// generic I/O control for char devices (3.2).
#define IOCTL_GENERIC_BLKDEV	13	// generic I/O control for block devices (3.2).
#define IOCTL_GET_LOGICAL_DRIVE_MAP 14	// get logical drive map (3.2).
#define IOCTL_SET_LOGICAL_DRIVE_MAP 15	// set logical drive map (3.2).
#define IOCTL_FSCTL		16	// file system driver control (STARLITE only).
#define IOCTL_LIMIT		(IOCTL_FSCTL) // maximum function code.

//	 FS-Help function codes.

#define FSHELP_GETDOSDATA	0	// return (DS)	DOSDATA segment.
#define FSHELP_GETBPB		1	// return BPB address.
#define FSHELP_READSECTOR	2	// read sector from disk.
#define FSHELP_WRITESECTOR	3	// write sector to disk.
#define FSHELP_MAX_FUNCTION	(FSHELP_WRITESECTOR) // maximum function code value.

//	 Installable File System (FSD) function codes.

#define FSD_INITIALIZE		0
#define FSD_SHUTDOWN		1
#define FSD_READFILE		2
#define FSD_WRITEFILE		3
#define FSD_OPENFILE		4
#define FSD_CLOSEFILE		5
#define FSD_CREATEFILE		6
#define FSD_DELETEFILE		7
#define FSD_CREATEDIR		8
#define FSD_DELETEDIR		9
#define FSD_RENAMEFILE	       10
#define FSD_SEEKFILE	       11
#define FSD_FINDFIRST	       12
#define FSD_FINDNEXT	       13
#define FSD_SYNCHRONIZE        14
#define FSD_FILECTRL	       15
#define FSD_FILEINFO	       16		// get/set file attributes.
#define FSD_FILETIME	       17		// get/set file date/time stamp.
#define FSD_QFSINFO	       18		// query file system information.
#define FSD_LOCK	       19		// lock byte range.
#define FSD_UNLOCK	       20		// unlock byte range.
#define FSD_LIMIT	       (FSD_UNLOCK)	// last possible command code.

//	 FSD_FILECTRL subfunction codes.

#define FSCTL_LIMIT		0

//	 Device Driver Major Function Codes.

#define DEV_INITIALIZE		0	// initialize driver.
#define DEV_MEDIA_CHECK         1	// media check on block device.
#define DEV_BUILD_BPB		2	// build BIOS Parameter Block.
#define DEV_IOCTL_READ		3	// I/O Control read.
#define DEV_READ		4	// read from device.
#define DEV_ND_READ		5	// non-destructive read.
#define DEV_INPUT_STATUS	6	// return current input status.
#define DEV_INPUT_FLUSH         7	// flush device input buffer.
#define DEV_WRITE		8	// write to device.
#define DEV_WRITE_VFY		9	// write with verify.
#define DEV_OUTPUT_STATUS      10	// return current output status.
#define DEV_OUTPUT_FLUSH       11	// flush device output buffer.
#define DEV_IOCTL_WRITE        12	// I/O Control write.
#define DEV_OPEN	       13	// device open.
#define DEV_CLOSE	       14	// device close.
#define DEV_REMOVE_MEDIA       15	// removable media.
#define DEV_OUTPUT_BUSY        16	// output until busy.
#define DEV_GENERIC_IOCTL      19	// generic IOCTL function.
#define DEV_GET_LOGICAL_DEVICE 23	// get logical device mapping.
#define DEV_SET_LOGICAL_DEVICE 24	// set logical device mapping.
#define DEV_LIMIT	       (DEV_SET_LOGICAL_DEVICE) // last possible command code.

//	 DEVICE error codes.

#define DEVERR_WRITE_PROTECT_VIO	0	// write protection violation.
#define DEVERR_UNKNOWN_UNIT		1	// unknown unit number.
#define DEVERR_DRIVE_NOT_READY		2	// specified drive not closed/ready.
#define DEVERR_BAD_COMMAND		3	// bad command, driver cannot process.
#define DEVERR_DATA_ERROR		4	// CRC failure// data corruption.
#define DEVERR_BAD_STRUC_LENGTH         5	// bad drive request structure length.
#define DEVERR_SEEK_FAILURE		6	// seek failure on drive.
#define DEVERR_UNKNOWN_MEDIA		7	// media unknown.
#define DEVERR_SECTOR_NOT_FOUND         8	// sector number could not be found.
#define DEVERR_PAPER_OUT		9	// printer out of paper.
#define DEVERR_WRITE_FAULT	       10	// write fault.
#define DEVERR_READ_FAULT	       11	// read fault.
#define DEVERR_GENERAL_FAILURE	       12	// catch-all category for hard errors.
#define DEVERR_INVALID_DISK_CHANGE     15	// (only on DOS versions 3 and above).

//	 DOS error codes.

#define DOSERR_SUCCESS			0	// success.
#define DOSERR_INVALID_FUNCTION         1	// invalid function number.
#define DOSERR_FILE_NOT_FOUND		2	// file not found.
#define DOSERR_PATH_NOT_FOUND		3	// path not found.
#define DOSERR_HANDLE_LIMIT		4	// too many open files (limit reached).
#define DOSERR_ACCESS_DENIED		5	// access is blocked.
#define DOSERR_INVALID_HANDLE		6	// invalid handle.
#define DOSERR_MEMORY_CORRUPTED         7	// system memory block(s) corrupted.
#define DOSERR_NO_MEMORY		8	// insufficient memory (all in use).
#define DOSERR_INVALID_ADDRESS		9	// invalid memory block address.
#define DOSERR_INVALID_ENVIRON	       10	// invalid environment.
#define DOSERR_INVALID_FORMAT	       11	// invalid format.
#define DOSERR_INVALID_ACCESS	       12	// invalid access code.
#define DOSERR_INVALID_DATA	       13	// invalid data.
#define DOSERR_RESERVED_1	       14	// this is reserved.
#define DOSERR_INVALID_DISK_DRIVE      15	// invalid disk drive.
#define DOSERR_REMOVE_CUR_DIR	       16	// attempt to remove current directory.
#define DOSERR_NOT_SAME_DEVICE	       17	// not same device.
#define DOSERR_NO_MORE_FILES	       18	// no more files in search.
#define DOSERR_WRITE_PROTECTED	       19	// device/file is write protected.
#define DOSERR_UNKNOWN_UNIT	       20	// unknown disk unit.
#define DOSERR_DRIVE_NOT_READY	       21	// disk drive is not ready.
#define DOSERR_UNKNOWN_COMMAND	       22	// unknown command.
#define DOSERR_DATA_ERROR	       23	// CRC error.
#define DOSERR_BAD_REQUEST_LENGTH      24	// bad request structure length.
#define DOSERR_SEEK_ERROR	       25	// seek error.
#define DOSERR_UNKNOWN_MEDIA	       26	// media type unknown.
#define DOSERR_SECTOR_NOT_FOUND        27	// sector not found or missing.
#define DOSERR_OUT_OF_PAPER	       28	// printer is out of paper.
#define DOSERR_WRITE_FAULT	       29	// write fault.
#define DOSERR_READ_FAULT	       30	// read fault.
#define DOSERR_GENERAL_FAILURE	       31	// general failure.

//	 Version 3.x and above error codes.

#define DOSERR_SHARING_VIOLATION       32	// sharing violation.
#define DOSERR_LOCK_VIOLATION	       33	// lock violation.
#define DOSERR_INVALID_DISK_CHANGE     34	// disk was changed at a bad time.
#define DOSERR_FCB_UNAVAILABLE	       35	// FCB was unavailable.
#define DOSERR_SHARING_BUFFER_OVFL     36	// sharing buffer overflow.
#define DOSERR_INVALID_NETWORK_REQUEST 50	// network request not supported.
#define DOSERR_NO_LISTENS	       51	// remote computer not listening.
#define DOSERR_DUPLICATE_NAME	       52	// duplicate name on network.
#define DOSERR_NAME_NOT_FOUND	       53	// network name not found.
#define DOSERR_NETWORK_BUSY	       54	// the network is busy.
#define DOSERR_NETWORK_DEVICE_GONE     55	// the network device no longer exists.
#define DOSERR_ADAPTER_FAILURE	       57	// network adapter hardware error.
#define DOSERR_NETWORK_RESPONSE_BAD    58	// incorrect response from network.
#define DOSERR_NETWORK_ERROR	       59	// unexpected network error.
#define DOSERR_INCOMPATIBLE_NETWORK    60	// incompatible remote adapter.
#define DOSERR_PRINT_QUEUE_FULL        61	// the print queue full.
#define DOSERR_PRINT_QUEUE_NOT_FULL    62	// the print queue is not full.
#define DOSERR_PRINT_FILE_DELETED      63	// the print job ran out of space.
#define DOSERR_NETWORK_NAME_DELETED    64	// the local name was deleted.
#define DOSERR_ACCESS_DENIED_2	       65	// access to named object denied.
#define DOSERR_FILE_ALREADY_EXISTS     80	// the specified file already exists.
#define DOSERR_CANNOT_MAKE_DIR_ENTRY   82	// cannot make directory entry.
#define DOSERR_REDIRECTION_TABLE_FULL  84	// too many redirections.
#define DOSERR_INVALID_PASSWORD        86	// invalid password.
#define DOSERR_INVALID_PARAMETER       87	// invalid parameter.

//	 Guru meditation numbers.

#define GURU_NO_STACKS			1	// no system stacks are available.
#define GURU_NO_RUNNERS                 2       // scheduler can't find a thread to run.
#define GURU_DEBUG_FORMAT_ERROR         3	// FORMAT macro encountered bad format.
#define GURU_NO_THREADS                 4       // no threads available to allocate.
#define GURU_SCHEDULER_RETURNED         5	// ScheduleThread returned.
#define GURU_POOL_OVERREF		6	// system pool block ref count overflow.
#define GURU_UNKNOWN_OBJECT		7	// unknown object type in I/O system.
#define GURU_MISSING_FFO		8	// FAT system can't find FFO.
#define GURU_NO_INIT_POOL		9	// insufficient pool exists for init.
#define GURU_MISSING_NFO	       10	// DFS system can't find NFO.
#define GURU_MISSING_LFO	       11	// DFS system can't find LFO.
#define GURU_MISSING_NCB	       12	// DFS system can't find NCB.

//	 System kernel function assignments.

#define SYS_ALLOCATE_THREAD		1
#define SYS_FREE_THREAD                 2
#define SYS_ENTER_CRITICAL_SECTION	3
#define SYS_LEAVE_CRITICAL_SECTION	4
#define SYS_PASS_TIME_SLICE		5
#define SYS_ALLOCATE_MUTEX		6
#define SYS_FREE_MUTEX			7
#define SYS_ACQUIRE_MUTEX		8
#define SYS_RELEASE_MUTEX		9
#define SYS_ALLOCATE_EVENT	       10
#define SYS_FREE_EVENT		       11
#define SYS_SET_EVENT		       12
#define SYS_CLEAR_EVENT                13
#define SYS_PULSE_EVENT                14
#define SYS_ALLOCATE_TIMER	       15
#define SYS_FREE_TIMER		       16
#define SYS_START_TIMER                17
#define SYS_STOP_TIMER		       18
#define SYS_ALLOCATE_POOL	       19
#define SYS_DEALLOCATE_POOL	       20
#define SYS_KEEP_POOL		       21
#define SYS_USEDOSDATA_DS	       22
#define SYS_USEDOSDATA_ES	       23
#define SYS_USEPSP_DS		       24
#define SYS_USEPSP_ES		       25
#define SYS_USEDGROUP_DS	       26
#define SYS_USEDGROUP_ES	       27
#define SYS_QUERY_EVENT                28
#define SYS_WAIT_EVENT		       29
#define SYS_MAX_KERNEL_FUNCTION        (SYS_WAIT_EVENT)
