//***	KTYPES.H -- STARLITE Kernel Type Definitions for C Language Programs.
//
//1.	Functional Description.
//	This include file contains type definitions for the STARLITE KERNEL.
//
//2.	Modification History.
//	S. E. Jones	91/10/12.	#1.093, Original.
//	S. E. Jones	92/01/12.	#1.095, slstatus->status.
//
//3.	NOTICE: Copyright (C) 1991, 1992 General Software, Inc.

#ifndef _KTYPES
#define _KTYPES

#define UCHAR unsigned char
#define PUCHAR unsigned char *
#define USHORT unsigned short
#define PUSHORT unsigned short *
#define ULONG unsigned long
#define PULONG unsigned long *
#define CHAR char
#define PCHAR char *
#define SHORT short
#define PSHORT short *
#define LONG	long
#define PLONG long *
#define BOOLEAN unsigned short
#define PBOOLEAN unsigned short *
#define VOID void
#define PVOID void *

#ifndef NULL
#define NULL 0L
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif

//
// The Kernel API functions return a 16-bit STATUS value.  This value
// may be interpreted according to the codes defined in SYSTEM.H, with
// the DOSERR_ prefixes.
//

#define STATUS unsigned short		// return-code status type.

//
// General Kernel API syntax.
//

#define IN				// parameter is readable.
#define OUT				// parameter is writable.
#define OPTIONAL			// parameter is optional.

//
// Handles are just unsigned shorts.
//

#define HANDLE unsigned short
#define PHANDLE unsigned short *

#endif // not defined, _KTYPES
