;***	DEFINES.INC -- STARLITE Common Kernel Magic Numbers.
;
;1.	Functional Description.
;	This include file contains symbol definitions for the commonly-
;	used magic numbers and tuning parameters.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/02/03.	Added [de]register file system fs-helps.
;	S. E. Jones	91/03/04.	Reduced INT21 stacks from 10 to 5.
;	S. E. Jones	91/05/20.	Directory Reorg.
;	S. E. Jones	91/07/25.	#1.087, added unarchitected kernel functions.
;	S. E. Jones	91/07/26.	#1.087, added COM port debugger code.
;	S. E. Jones	91/07/27.	#1.087, removed some debugging build options.
;	S. E. Jones	91/08/09.	#1.090, removed gurus.
;	S. E. Jones	91/11/19.	#1.094, added long thread creation.
;	S. E. Jones	92/01/04.	#1.095, added prioritize/abort thread funcs.
;	S. E. Jones	92/01/06.	#1.095, added get fshelp address function.
;	S. E. Jones	92/01/08.	#1.095, added get iohelp address function.
;	S. E. Jones	92/01/08.	#1.095, added iohelp function codes.
;	S. E. Jones	92/07/14.	#1.099, added query thread handle.
;	S. E. Jones	92/07/26.	#1.099, added OBJECT API.
;	S. E. Jones	92/09/03.	#1.100, split-off API definitions.
;
;3.	NOTICE: Copyright (C) 1990, 1991, 1992 General Software, Inc.

;	Symbols used by macros.

BOUND		=	1		; module is bound in system.
UNBOUND         =	0		; module is not bound.

;	System build options to include functionality.

BUILD_DFS	=	1		; 1=make DFS, 0=don't.
BUILD_DFSPROT	=	0		; 1=make DFSxxx.ASM, 0=don't.
BUILD_FCB	=	1		; 1=support FCB's, 0=don't.
BUILD_DPB	=	1		; 1=support DPB's, 0=don't.

;	Debugging flags (used by DISPLAY and DPRINTF macros).

ASSERTS         =	0		; 1=compile assertion code, 0=don't.
		IFNDEF	DEBUG
DEBUG		=	1		; 1=compile debugging code, 0=don't.
		ENDIF	; (IFNDEF DEBUG)
SHOWBUGBUGS	=	0		; flag BUGBUGs as assembly errors.

;	The following symbols are used by the debugger (DEBUGCMD.ASM) to
;	route debug I/O to various devices (console, COM port, etc.).  They
;	are hardcoded here because both OEM.ASM and DEBUGCMD.ASM have to
;	agree on their values.	The other values of DebugPort are the
;	unarchitected COM port numbers set by DEBUGCMD and used by OEM.

DEBUGPORT_CONSOLE	=	0fffeh	; I/O goes to console.
DEBUGPORT_DISABLE	=	0ffffh	; I/O goes nowhere.

;	Some debugging constants.

DEBUG_SCREEN_SCHED =	75		; column to update with scheduler debugging.
MAX_BREAKPOINTS =	8		; number of breakpoints in table.

;	Starlite OEM identification.

STARLITE_OEM	=	99h		; special value returned by DOSGETVERSION.
STARLITE_MAJVER =	3		; major version returned by DOSGETVERSION.
STARLITE_MINVER =	39		; minor version returned by DOSGETVERSION.

;	MS-DOS-compatible interrupt vectors (can't be changed).

DOSVECT_EXIT	=	22h		; exit handler vector.
DOSVECT_CTRLC	=	23h		; ctrl-c handler vector.
DOSVECT_CRITERR =	24h		; critical error handler vector.

;	Image activator tuning constants.

INCR_ENVIRONMENT =	256		; #bytes to increase environment/exec.
LOAD_INITIALIZE =	0		; 1 if init load area to INT 3's.
FIXUP_TABLE_SIZE =	512		; must be a multiple of 4.

;	Multiprocessor support.

PROCESSOR_COUNT =	1		; number of processors in system.
MULTIPROCESSOR	=	0		; 1=compile MP code, 0=disable code.

;	System memory configuration (private POOL.ASM constants).

MIN_FRAGMENT_SIZE =	10		; smallest fragment size possible in pool.

;	I/O system constants.

MAX_PARSE_PATH_SIZE =	256		; up to 256 bytes in pathname.
DISK_BLOCK_SIZE =	512		; size of a logical disk block.
INIT_FAT_CACHE_SIZE =	2		; FATFSD uses 2 buffers at init time.
INIT_FAT_CACHE_CYCLE =	1000		; 1 second between cache runs.
INIT_FAT_CACHE_TTL =	2000		; 2 seconds between cache agings.
FAT_PRIORITY_BOOST =	15		; extra cache priority for FAT sectors.
SHARE_VIOLATION_RETRIES = 3		; default number of sharing violation retries.
COOKED_BUFFER_SIZE =	128		; size of cooked buffer to allocate.
DISK_CACHE_ENTRIES =	8		; size of cache for disk driver in sectors.
MAX_SFDS =		8		; up to 8 concurrently open FCBs in system.
DFS_PREFIX_ENTRY_SIZE = 64		; maximum size of a DFS prefix path.
MAX_TEMPLATES =         2		; maximum number of I/O templates in system.
MAX_TEMPLATE_SIZE =	128		; maximum size of input buffer.
MAX_DDS =		3		; max DOS Drive Structures defined.

;	System timeout values.

TIMEOUT_CACHE_DECAY  =	2000		; 2000 milliseconds/cache decay in FATFSD.
TIMEOUT_SHARE_VIOLATION = 1000		; 1000 milliseconds/sharing violation retry.

;	Timer system constants (milliseconds per tick is in IBMPC.INC).

MAX_TIMERS	=	100		; number of timers to define.

;	Some commonly-used general-purpose equates.

DYNSEG		=	0ffffh		; special segment value for SYMENTRY.
FALSE		=	0
TRUE		=	(NOT FALSE)

;	ASCII characters.

CR		=	0dh		; carriage return.
LF		=	0ah		; line feed.
BKSP		=	08h		; backspace (not DEL, which is ffh).
ESCAPE		=	1bh		; escape key.
TAB		=	09h		; horizontal tab (^I).
BELL		=	07h		; bell character (beep) for BIOS.
SPACE		=	20h		; a blank (space).

;	The default handle names.

HANDLE_STDIN	=	0		; standard input device.
HANDLE_STDOUT	=	1		; standard output device.
HANDLE_STDERR	=	2		; standard error device.
HANDLE_STDAUX	=	3		; standard auxilliary device.
HANDLE_STDPRN	=	4		; standard list device.

;	Loader constants.

DEFAULT_ENVSIZE =	1024		; 1k environments by default.

;	80x86 processor flags for use by the debugger.

FL_CARRY	=	0000000000000001b
FL_PARITY	=	0000000000000100b
FL_AUX		=	0000000000010000b
FL_ZERO         =	0000000001000000b
FL_SIGN         =	0000000010000000b
FL_TRACE	=	0000000100000000b
FL_INTERRUPT	=	0000001000000000b
FL_DIRECTION	=	0000010000000000b
FL_OVERFLOW	=	0000100000000000b

;	Bitflags for PUSHREG/POPREG indicating specific registers pushed/popped.
;	Do not change these assignments unless you understand how the routines
;	PushRegistersByMaskFar and PopRegistersByMaskFar really work.  They are
;	currently optimized to shift the mask right by one to get to the next
;	succeeding register bit assignment.  PopRegistersByMaskFar also assumes
;	that REG_BP is equal to 0100h and that all of the others are stored in
;	one byte in the order defined below.

REG_AX		=	0001h
REG_BX		=	0002h
REG_CX		=	0004h
REG_DX		=	0008h
REG_SI		=	0010h
REG_DI		=	0020h
REG_DS		=	0040h
REG_ES		=	0080h
REG_BP		=	0100h
