/*
// PROGRAM NAME:  INPUT.C.
//
// FUNCTIONAL DESCRIPTION.
//	This module implements INPUT functionality in COW.
//
// MODIFICATION HISTORY.
//	S. E. Jones	91/05/10.	Original.
//	S. E. Jones	91/07/08.	Added KeyReady.
//
// NOTICE:  Copyright (C) 1991-1993 General Software, Inc.
*/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "cow.h"			// COW system include file.

//
// Scan code definitions PRIVATE to this module.
//

#define UP_ARROW	0x48
#define DOWN_ARROW	0x50
#define LEFT_ARROW	0x4b
#define RIGHT_ARROW	0x4d
#define PAGE_UP         0x49
#define PAGE_DOWN	0x51
#define F1		0x3b
#define F2		0x3c
#define F3		0x3d
#define F4		0x3e
#define F5		0x3f
#define F6		0x40
#define F7		0x41
#define F8		0x42
#define F9		0x43
#define F10		0x44
#define BACKTAB         0x0f		// NUL followed by ^O.
#define INS		0x52		// insert key.
#define DEL		0x53		// delete key.
#define HOME		0x47
#define END		0x4f

static PCOW_IDLE_ROUTINE UserIdleRoutine=NULL;

VOID KeyRegisterIdleRoutine (UserRoutine)
    PCOW_IDLE_ROUTINE UserRoutine;
{
    UserIdleRoutine = UserRoutine;
} // KeyRegisterIdleRoutine

KEY_CODE KeyRead ()
{
    union REGS regs;

    //
    // Call the user idle routine in our free time.
    //

    if (UserIdleRoutine != NULL) {
	(*UserIdleRoutine)();
    }

    //
    // Call the keyboard BIOS to read without fear of ^C being echoed, etc.
    //

    regs.h.ah = 0;			// (AH) = read keyboard input function.
    int86 (0x16, &regs, &regs);         // (AL) = ASCII code, (AH) = scan code.
    if (regs.h.al != 0) {
	return regs.h.al;
    }

    //
    // We have a function key here.  Switch off the scan code.
    //

    switch (regs.h.ah) {
	case UP_ARROW:		return I_UP;
	case DOWN_ARROW:	return I_DOWN;
	case LEFT_ARROW:	return I_LEFT;
	case RIGHT_ARROW:	return I_RIGHT;
	case PAGE_UP:		return I_PGUP;
	case PAGE_DOWN:         return I_PGDN;
	case HOME:		return I_HOME;
	case END:		return I_END;
	case INS:		return I_INSERT;
	case DEL:		return I_DELETE;
	case F1:		return I_F1;
	case F2:		return I_F2;
	case F3:		return I_F3;
	case F4:		return I_F4;
	case F5:		return I_F5;
	case F6:		return I_F6;
	case F7:		return I_F7;
	case F8:		return I_F8;
	case F9:		return I_F9;
	case F10:		return I_F10;
	case BACKTAB:		return I_BACKTAB;
	default:		return I_INVALID;
    }
} // KeyRead

BOOLEAN KeyReady ()
{
    union REGS regs;

    //
    // Call DOSCONIO to see if a character is ready.
    //

    regs.h.ah = 6;			// (AH) = raw console I/O function.
    regs.h.al = 99;			// set to non-zero for test, below.
    regs.h.dl = 0xff;			// (DL) = input request indicator.
    intdos (&regs, &regs);		// (AL) = 0 if no character ready.
    if (regs.h.al != 0) {
	return TRUE;
    } else {
	return FALSE;
    }
} // KeyReady
