package hw_int is

  ----------------------------------
  --  Hardware Interrupt Vectors  --
  ----------------------------------

  -- Intel 80x86 chip-defined hardware interrupts

  int_divde_by_zero               : constant := 16#00#;
  int_single_step                 : constant := 16#01#;
  int_nonmaskable                 : constant := 16#02#;
  int_breakpoint                  : constant := 16#03#;
  int_overflow                    : constant := 16#04#;
  int_bound                       : constant := 16#05#;
  int_invalid_opcode              : constant := 16#06#;
  int_no_coprocessor              : constant := 16#07#;
  int_double_exception            : constant := 16#08#;
  int_coprocessor_segment_overrun : constant := 16#09#;
  int_invalid_task_state_segment  : constant := 16#0A#;
  int_segment_not_present         : constant := 16#0B#;
  int_stack_overflow              : constant := 16#0C#;
  int_general_protection          : constant := 16#0D#;

  -- IBM PC-defined hardware interrupts

  int_timer                       : constant := 16#08#;  -- IRQ 0
  int_keyboard                    : constant := 16#09#;  -- IRQ 1
  int_network                     : constant := 16#0A#;  -- IRQ 9 (redirected)
  int_com_port2                   : constant := 16#0B#;  -- IRQ 3
  int_com_port1                   : constant := 16#0C#;  -- IRQ 4
  int_alt_printer                 : constant := 16#0D#;  -- IRQ 5
  int_disk                        : constant := 16#0E#;  -- IRQ 6
  int_printer                     : constant := 16#0F#;  -- IRQ 7

  int_real_clock                  : constant := 16#70#;  -- IRQ 8
  int_coprocessor                 : constant := 16#75#;  -- IRQ 13
  int_fixed_disk                  : constant := 16#76#;  -- IRQ 14

  ----------------------------------------------------------
  --  Definitions for the 8259 Interrupt Controller Chip  --
  ----------------------------------------------------------

  -- Base I/O addresses for 8259 Interrupt Controllers

  INC1                     : constant := 16#20#;  -- Master - IRQ 0 - 7
  INC2                     : constant := 16#A0#;  -- Slave  - IRQ 8 - 15

  -- 8259 register offsets from base address

  OCR_register             : constant := 16#00#;  -- Operational Control Reg.
  IMR_register             : constant := 16#01#;  -- Interrupt Mask Register

  INC1_OCR                 : constant := INC1 + OCR_register;
  INC1_IMR                 : constant := INC1 + IMR_register;

  -- Operational Control Register commands

  OCR_end_of_interrupt     : constant := 16#20#;  -- Clears interrupt
  OCR_EOI_com_port2        : constant := 16#63#;  -- Clears com_port2 interrupt
  OCR_EOI_com_port1        : constant := 16#64#;  -- Clears com_port1 interrupt

  -- Interrupt Mask Register values
  --  "enable"  values should be ANDed to current mask value (read, AND, write)
  --  "disable" values should be ORed  to current mask value (read, OR,  write)

  IMR_enable_all           : constant := 16#00#;

  IMR1_enable_timer        : constant := 16#FE#;  -- Use with INC1
  IMR1_enable_keyboard     : constant := 16#FD#;
  IMR1_enable_network      : constant := 16#FB#;
  IMR1_enable_com_port2    : constant := 16#F7#;
  IMR1_enable_com_port1    : constant := 16#EF#;
  IMR1_enable_alt_printer  : constant := 16#DF#;
  IMR1_enable_disk         : constant := 16#BF#;
  IMR1_enable_printer      : constant := 16#7F#;

  IMR2_enable_real_clock   : constant := 16#FE#;  -- Use with INC2
  IMR2_enable_coprocessor  : constant := 16#DF#;
  IMR2_enable_fixed_disk   : constant := 16#BF#;

  IMR_disable_all          : constant := 16#FF#;

  IMR1_disable_timer       : constant := 16#01#;  -- Use with INC1
  IMR1_disable_keyboard    : constant := 16#02#;
  IMR1_disable_network     : constant := 16#04#;
  IMR1_disable_com_port2   : constant := 16#08#;
  IMR1_disable_com_port1   : constant := 16#10#;
  IMR1_disable_alt_printer : constant := 16#20#;
  IMR1_disable_disk        : constant := 16#40#;
  IMR1_disable_printer     : constant := 16#80#;

  IMR2_disable_real_clock  : constant := 16#01#;  -- Use with INC2
  IMR2_disable_coprocessor : constant := 16#20#;
  IMR2_disable_fixed_disk  : constant := 16#40#;

end hw_int;
