package bios is

  -----------------------
  --  BIOS Interrupts  --
  -----------------------

  int_print_screen         : constant := 16#05#;
  int_video_io             : constant := 16#10#;
  int_equipment            : constant := 16#11#;
  int_memory               : constant := 16#12#;
  int_disk_io              : constant := 16#13#;
  int_com_port_io          : constant := 16#14#;
  int_cassette_io          : constant := 16#15#;
  int_extensions           : constant := 16#15#;
  int_keyboard_io          : constant := 16#16#;
  int_printer_io           : constant := 16#17#;
  int_time_of_day          : constant := 16#1A#;
  int_keyboard_break       : constant := 16#1B#;
  int_timer_tick           : constant := 16#1C#;
  int_video_initialization : constant := 16#1D#;
  int_diskette_parameters  : constant := 16#1E#;
  int_video_graphics_chars : constant := 16#1F#;

  --------------------------------------------------------------------------
  --  Definitions for the DOS BIOS Commun. Port Interrupt (int_com_port)  --
  --------------------------------------------------------------------------

  -- Communications Port Identifier

  com_port1           : constant := 0;
  com_port2           : constant := 1;

  --  Initialization Parameters - pick 1 from each of the following groups

  inp_7_bits          : constant := 16#02#;
  inp_8_bits          : constant := 16#03#;

  inp_1_stop_bit      : constant := 16#00#;
  inp_2_stop_bits     : constant := 16#04#;

  inp_no_parity       : constant := 16#00#;
  inp_odd_parity      : constant := 16#08#;
  inp_even_parity     : constant := 16#18#;

  inp_110_baud        : constant := 16#00#;
  inp_150_baud        : constant := 16#20#;
  inp_300_baud        : constant := 16#40#;
  inp_600_baud        : constant := 16#60#;
  inp_1200_baud       : constant := 16#80#;
  inp_2400_baud       : constant := 16#A0#;
  inp_4800_baud       : constant := 16#C0#;
  inp_9600_baud       : constant := 16#E0#;

  -- int_com_port function codes (loaded in AH register, defined for AX)

  intf_com_initialize : constant := 16#0000#;
    -- Initialize communications port
    --   Params:  DX - Commuications Port Identifier (see above)
    --            AL - Initialization Parameters (see above)
    --   Return:  AH - Line Control Status (see package com_port)
    --            AL - Modem Status (see package com_port)

  intf_com_write      : constant := 16#0100#;
    -- Send a character over port
    --   Params:  DX - Commuications Port Identifier (see above)
    --            AL - Character to send
    --   Return:  AH - Line Control Status (see package com_port)

  intf_com_read       : constant := 16#0200#;
    -- Receive character from port
    --   Params:  DX - Commuications Port Identifier (see above)
    --   Return:  AH - Line Control Status (see package com_port)
    --            AL - Character read

  intf_com_get_status : constant := 16#0300#;
    -- Return port status
    --   Params:  DX - Commuications Port Identifier (see above)
    --   Return:  AH - Line Control Status (see package com_port)
    --            AL - Modem Status (see package com_port)

end bios;
