--        ͻ
--        ۺ
--                                                                   ۺ
--                         Meridian Software Systems                 ۺ
--                                                                   ۺ
--                            Copyright (C)  1990                    ۺ
--                                                                   ۺ
--                            ALL RIGHTS RESERVED                    ۺ
--                                                                   ۺ
--        ۺ
--        ͼ
--
------------------------------------------------------------------------------
--
--   Unit Name: Window_IO         - package specification
--
--   Purpose of unit:   This package is called by the window package to save
--                      and load windows to and from a disk file.
--
------------------------------------------------------------------------------

with SPY;

package WINDOW_IO is

  type BYTE_ARRAY is array(1..320) of SPY.byte;
  type BYTE_REC is
	 record
	   BYTE_ARRAY : BYTE_ARRAY;
	 end record;

  function  CREATE (FILE_NAME : in  string) return boolean;
  function  OPEN   (FILE_NAME : in  string) return boolean;
  procedure READ   (REC  : out BYTE_REC;
		    OK   : out boolean);
  function  WRITE  (REC  : in  BYTE_REC) return boolean;

  function  END_OF_FILE return boolean;
  function  CLOSE       return boolean;

end WINDOW_IO;

