--        ͻ
--        ۺ
--                                                                   ۺ
--                         Meridian Software Systems                 ۺ
--                                                                   ۺ
--                            Copyright (C)  1990                    ۺ
--                                                                   ۺ
--                            ALL RIGHTS RESERVED                    ۺ
--                                                                   ۺ
--        ۺ
--        ͼ
--
------------------------------------------------------------------------------
--
--   Unit Name: Window_IO           - package body
--
--   Purpose of unit:   This package is called to save and load windows to
--                      and from a disk file.
--
------------------------------------------------------------------------------

with Sequential_io, Ada_io;

package body WINDOW_IO is

  package FILE_IO is new Sequential_io(ELEMENT_TYPE => BYTE_REC);

  WINDOW_FILE : FILE_IO.File_type;

  -- ==========================================================================
  --
  --                            CREATE
  --
  -- ==========================================================================
  function CREATE(FILE_NAME : in string) return boolean is
  begin
    FILE_IO.Create(FILE => WINDOW_FILE,
		   MODE => FILE_IO.Out_file,
		   NAME => FILE_NAME);
    return true;
  exception
    when others =>
      Ada_io.Put_line("Error creating file.");
      return false;
  end CREATE;

  -- ==========================================================================
  --
  --                           OPEN
  --
  -- ==========================================================================
  function OPEN (FILE_NAME : in string) return boolean is
  begin
    FILE_IO.Open(FILE => WINDOW_FILE,
		 MODE => FILE_IO.In_file,
		 NAME => FILE_NAME);
    return true;
  exception
    when others =>
      Ada_io.Put_line("Error opening file.");
      return false;
  end OPEN;

  -- ==========================================================================
  --
  --                           READ
  --
  -- ==========================================================================
  procedure READ (REC : out BYTE_REC;
		  OK  : out boolean) is
  begin
    FILE_IO.Read(FILE => WINDOW_FILE,
		 ITEM => REC);
    OK := true;
  exception
    when others =>
      Ada_io.Put_line("Error reading file.");
      OK := false;
  end READ;

  -- ==========================================================================
  --
  --                           WRITE
  --
  -- ==========================================================================
  function WRITE (REC : in BYTE_REC) return boolean is
  begin
    FILE_IO.Write(FILE => WINDOW_FILE,
		  ITEM => REC);
    return true;
  exception
    when others =>
      Ada_io.Put_line("Error writing to file.");
      return false;
  end WRITE;

  -- ==========================================================================
  --
  --                           END_OF_FILE
  --
  -- ==========================================================================
  function  END_OF_FILE return boolean is
  begin
    return FILE_IO.End_of_file(FILE => WINDOW_FILE);
  exception
    when others =>
      Ada_io.Put_line("Error checking for end of file.");
      return true;
  end END_OF_FILE;

  -- ==========================================================================
  --
  --                           CLOSE
  --
  -- ==========================================================================
  function CLOSE return boolean is
  begin
    FILE_IO.Close(FILE => WINDOW_FILE);
    return true;
  exception
    when others =>
      Ada_io.Put_line("Error closing file.");
      return false;
  end CLOSE;

end WINDOW_IO;
