--        ͻ
--        ۺ
--                                                                   ۺ
--                         Meridian Software Systems                 ۺ
--                                                                   ۺ
--                            Copyright (C)  1990                    ۺ
--                                                                   ۺ
--                            ALL RIGHTS RESERVED                    ۺ
--                                                                   ۺ
--        ۺ
--        ͼ

------------------------------------------------------------------------------
--
--   Unit Name:   DRAW         - package specification
--
--   Purpose of unit:   This specification allows the application programmer
--                      to interface with the software to perform the func-
--                      tions to draw the geometric shapes and set the fore-
--                      ground and backgorund colors. The programmer may also
--                      use this package to clear a graphics screen and fill 
--                      the geometric objects drawn.
--
------------------------------------------------------------------------------

with COMMON_DISPLAY_TYPES;

package DRAW is

  procedure ELLIPSE          (XC, YC, A0, B0    : natural);
  procedure CIRCLE           (XC, YC, R         : natural);
  procedure CIRCLE_SEGMENT   (XC, YC, SA, EA, R : natural);
  procedure ARC              (XC, YC, SA, EA, R : natural);
  procedure RECTANGLE        (X1, Y1, X2, Y2    : natural);
  procedure LINE             (X1, Y1, X2, Y2    : natural);
  procedure OBJECT_FILL      (X, Y              : natural;
			      FIL_C, BRD_C      : COMMON_DISPLAY_TYPES.COLOR);
  procedure FOREGROUND_COLOR (COLOR             : COMMON_DISPLAY_TYPES.COLOR);
  procedure BACKGROUND_COLOR (COLOR             : COMMON_DISPLAY_TYPES.COLOR);
  procedure CLEAR_SCREEN;

end DRAW;
