--        ͻ
--        ۺ
--                                                                   ۺ
--                         Meridian Software Systems                 ۺ
--                                                                   ۺ
--                           Copyright (C)  1990                     ۺ
--                                                                   ۺ
--                           ALL RIGHTS RESERVED                     ۺ
--                                                                   ۺ
--        ۺ
--        ͼ

--
--
--  Unit Name :  Common_Graphic_Types - package specification
--
--  Purpose of unit:  This package defines the common, global, variables
--                    for the Ada Graphics Utility Library.
--
--

with COMMON_DISPLAY_TYPES, DISK_TYPES, DIRECTORY, ERRORS, VIDEO, BOX;
use  COMMON_DISPLAY_TYPES;

package COMMON_GRAPHIC_TYPES is

  --ͻ

  --  Ada Graphics Utility Library Global Types

  type VIDEO_SYSTEM is (
    CGA_TEXT40_BW,
    CGA_TEXT40_COLOR,
    CGA_TEXT80_BW,
    CGA_TEXT80_COLOR,
    CGA_LOW_C4,
    CGA_LOW_GREY4,
    CGA_HIGH_C2,
    MDA_EVGA_TEXT80_BW,
    PCJR_LOW_C16,
    PCJR_MED_C16,
    PCJR_HIGH_C4,
    EGA_RESERVED_1,
    EGA_RESERVED_2,
    EVGA_LOW_C16,
    EVGA_MED_C16,
    EVGA_HIGH_BW,
    EVGA_HIGH_C16,
    MCVGA_HIGH_C2,
    VGA_HIGH_C16,
    MCVGA_LOW_C256,
    DEFAULT
    );

  subtype AGUL_MEMORY_LOCATION is long_integer;
  subtype HORIZONTAL           is integer range 0 .. 639;
  subtype VERTICAL             is integer range 0 .. 479;
  subtype CHAR_HORIZ           is integer range 0 ..  79;
  subtype CHAR_VERT            is integer range 0 ..  53;
  subtype DISPLAY_PAGE         is integer range 0 ..   1;
  subtype INDEX_NUMBER         is integer range 0 ..   8;
  subtype CHAR_PIXEL_SIZE      is integer range 8 ..  16;

  --ͼ

  --ͻ

  --  Video System Global Variables

  ASPECT_RATIO                   : float;
  SCREEN_WORLD_RATIO_X           : float;
  SCREEN_WORLD_RATIO_Y           : float;
  GRAPH_SCREEN                   : integer;
  CURRENT_VIDEO_PAGE             : integer := 0;
  SCREEN_FLAG                    : boolean;
  ACTIVE_PAGE                    : DISPLAY_PAGE;
  CURRENT_PAGE                   : DISPLAY_PAGE;
  TEXT_SCREEN                    : VIDEO_SYSTEM;
  CHARACTER_PIXEL_WIDTH          : CHAR_PIXEL_SIZE;
  CHARACTER_PIXEL_HEIGHT         : CHAR_PIXEL_SIZE;

  SCREEN_DIMENSION_UPPER_LEFT_X  : constant integer := 0;
  SCREEN_DIMENSION_UPPER_LEFT_Y  : constant integer := 0;
  SCREEN_DIMENSION_LOWER_RIGHT_X : HORIZONTAL;
  SCREEN_DIMENSION_LOWER_RIGHT_Y : VERTICAL;

  PAGE1_MEMORY_START             : AGUL_MEMORY_LOCATION;
  PAGE1_MEMORY_END               : AGUL_MEMORY_LOCATION;

  PAGE2_MEMORY_START             : AGUL_MEMORY_LOCATION;
  PAGE2_MEMORY_END               : AGUL_MEMORY_LOCATION;

  --ͼ

  --ͻ

  --  World Global Variables

  CURRENT_WORLD_LEFT_X        : constant integer := 0;
  CURRENT_WORLD_LEFT_Y        : constant integer := 0;
  CURRENT_WORLD_LOWER_RIGHT_X : natural;
  CURRENT_WORLD_LOWER_RIGHT_Y : natural;

  CURRENT_WORLD_INDEX_NO      : INDEX_NUMBER;

  --ͼ

  --ͻ

  --  Window Global Variables

  CURRENT_WINDOW_UPPER_LEFT_X  : HORIZONTAL;
  CURRENT_WINDOW_UPPER_LEFT_Y  : VERTICAL;
  CURRENT_WINDOW_LOWER_RIGHT_X : HORIZONTAL;
  CURRENT_WINDOW_LOWER_RIGHT_Y : VERTICAL;

  CURRENT_WINDOW_INDEX_NO      : INDEX_NUMBER;
  CLIP_ENABLE                  : boolean;   
  WINDOW_FORE_COLOR            : COMMON_DISPLAY_TYPES.COLOR;
  WINDOW_BACK_COLOR            : COMMON_DISPLAY_TYPES.BACKGROUND_COLOR;

  --ͼ

  --ͻ

  --  Disk Global Variables

  CURRENT_DISK_DRIVE               : DISK_TYPES.DRIVE_ID;
  CURRENT_DISK_DIRECTORY           : DIRECTORY.PATHNAME;
  CURRENT_DISK_DIRECTORY_LAST_CHAR : natural;

  --ͼ

  --ͻ

  --  Miscellanous Global Variables

  FORE_COLOR        : COMMON_DISPLAY_TYPES.COLOR;
  BACK_COLOR        : COMMON_DISPLAY_TYPES.BACKGROUND_COLOR;

  ERROR_CODE        : ERRORS.EXTENDED_ERRORS;


  --ͼ

  --ͻ

  --  Discard the following declarations after system testing
  --  These variables are used for the integration testing programs

  ULR                      : COMMON_DISPLAY_TYPES.ROW_RANGE;
  ULC                      : COMMON_DISPLAY_TYPES.COLUMN_RANGE;
  LRR                      : COMMON_DISPLAY_TYPES.ROW_RANGE;
  LRC                      : COMMON_DISPLAY_TYPES.COLUMN_RANGE;

  NON_BLINK                :    boolean := false;
  BLINK                    :    boolean := true;
  BLUE_BOX                 :    COMMON_DISPLAY_TYPES.DISPLAY_ATTRIBUTE :=  
				  (FOREGROUND => BRIGHT_WHITE,
				   BACKGROUND => BLUE,
				   BLINK      => false);

  CYAN_BOX                 :    COMMON_DISPLAY_TYPES.DISPLAY_ATTRIBUTE :=  
				  (FOREGROUND => BLUE,
				   BACKGROUND => CYAN,
				   BLINK      => false);

  GREEN_BOX                :    COMMON_DISPLAY_TYPES.DISPLAY_ATTRIBUTE :=  
				  (FOREGROUND => YELLOW,
				   BACKGROUND => GREEN,
				   BLINK      => false);

  NORM_FC      : COMMON_DISPLAY_TYPES.COLOR := YELLOW;        -- Normal Foreground Color
  NORM_BC      : COMMON_DISPLAY_TYPES.COLOR := BLUE;          -- Normal Background Color
  ENTRY_FC     : COMMON_DISPLAY_TYPES.COLOR := BLACK;         -- Function Entry Foreground Color
  ENTRY_BC     : COMMON_DISPLAY_TYPES.COLOR := CYAN;          -- Function Entry Background Color
  HELP_FC      : COMMON_DISPLAY_TYPES.COLOR := BLACK;         -- Information Foreground Color
  HELP_BC      : COMMON_DISPLAY_TYPES.COLOR := GREEN;         -- Information Background Color
  HIGHLIGHT_FC : COMMON_DISPLAY_TYPES.COLOR := YELLOW;        -- HighLight Foreground Color
  HIGHLIGHT_BC : COMMON_DISPLAY_TYPES.COLOR := CYAN;          -- HighLight Background Color
  LOWLIGHT_BC  : COMMON_DISPLAY_TYPES.COLOR := BLUE;          -- LowLight Background Color
  COL_FC       : COMMON_DISPLAY_TYPES.COLOR := BRIGHT_WHITE;  -- Column Select Foreground Color
  COL_BC       : COMMON_DISPLAY_TYPES.COLOR := GREEN;         -- Column Select Background Color
  ERROR_FC     : COMMON_DISPLAY_TYPES.COLOR := RED;           -- Error Foreground Color
  ERROR_BC     : COMMON_DISPLAY_TYPES.COLOR := BLUE;          -- Error Background Color

  --ͼ

end COMMON_GRAPHIC_TYPES;
