--        ͻ
--        ۺ
--                                                                   ۺ
--                         Meridian Software Systems                 ۺ
--                                                                   ۺ
--                            Copyright (C)  1990                    ۺ
--                                                                   ۺ
--                            ALL RIGHTS RESERVED                    ۺ
--                                                                   ۺ
--        ۺ
--        ͼ

--
--
--  Unit Name :  AGULMENU  -  package body
--
--  Purpose of unit:  This procedure performs the menu operations for the 
--                    AGUL demonstration and test program
--
--

with COMMON_GRAPHIC_TYPES, COMMON_DISPLAY_TYPES, BOX, TTY, INTERRUPT;
use  COMMON_GRAPHIC_TYPES, COMMON_DISPLAY_TYPES, BOX, TTY;

package body AGULMENU is

  REG_FILE : INTERRUPT.REGISTERS;

  --ͻ

  procedure DRAW_MAIN_MENU_BOX is
    LINE1 : constant string := "Ada Graphics Utility Library Demonstration Program";  -- 50 characters long
    LINE2 : constant string := "Function Data Entry Menu";  -- 24 characters long
    LINE3 : constant string := "Operational Information";  -- 23 characters long
  begin
    TTY.CLEAR_SCREEN;
    REG_FILE.AX := 16#0600#;
    REG_FILE.BX := 16#1000#;
    REG_FILE.CX := 16#0000#;
    REG_FILE.DX := 16#184F#;

    -- Call interrupt 10h
    INTERRUPT.VECTOR ( ON             => 16#10# ,
		       REGISTER_BLOCK => REG_FILE );

    ULR := 0;
    ULC := 0;
    LRR := 2;
    LRC := 79;
    BOX.DRAW (UPPER_LEFT_ROW      => ULR,
	      UPPER_LEFT_COLUMN   => ULC,
	      LOWER_RIGHT_ROW     => LRR,
	      LOWER_RIGHT_COLUMN  => LRC,
	      KIND                => DOUBLE,
	      ATTRIBUTE           => BLUE_BOX,
	      PAGE                => 0);

    ULR := 3;
    ULC := 0;
    LRR := 5;
    LRC := 39;
    BOX.DRAW (UPPER_LEFT_ROW      => ULR,
	      UPPER_LEFT_COLUMN   => ULC,
	      LOWER_RIGHT_ROW     => LRR,
	      LOWER_RIGHT_COLUMN  => LRC,
	      KIND                => DOUBLE,
	      ATTRIBUTE           => BLUE_BOX,
	      PAGE                => 0);

    ULR := 3;
    ULC := 40;
    LRR := 5;
    LRC := 79;
    BOX.DRAW (UPPER_LEFT_ROW      => ULR,
	      UPPER_LEFT_COLUMN   => ULC,
	      LOWER_RIGHT_ROW     => LRR,
	      LOWER_RIGHT_COLUMN  => LRC,
	      KIND                => DOUBLE,
	      ATTRIBUTE           => CYAN_BOX,
	      PAGE                => 0);

    ULR := 5;
    ULC := 0;
    LRR := 24;
    LRC := 39;
    BOX.DRAW (UPPER_LEFT_ROW      => ULR,
	      UPPER_LEFT_COLUMN   => ULC,
	      LOWER_RIGHT_ROW     => LRR,
	      LOWER_RIGHT_COLUMN  => LRC,
	      KIND                => DOUBLE,
	      ATTRIBUTE           => BLUE_BOX,
	      PAGE                => 0);

    ULR := 5;
    ULC := 40;
    LRR := 12;
    LRC := 79;
    BOX.DRAW (UPPER_LEFT_ROW      => ULR,
	      UPPER_LEFT_COLUMN   => ULC,
	      LOWER_RIGHT_ROW     => LRR,
	      LOWER_RIGHT_COLUMN  => LRC,
	      KIND                => DOUBLE,
	      ATTRIBUTE           => CYAN_BOX,
	      PAGE                => 0);

    ULR := 13;
    ULC := 40;
    LRR := 15;
    LRC := 79;
    BOX.DRAW (UPPER_LEFT_ROW      => ULR,
	      UPPER_LEFT_COLUMN   => ULC,
	      LOWER_RIGHT_ROW     => LRR,
	      LOWER_RIGHT_COLUMN  => LRC,
	      KIND                => DOUBLE,
	      ATTRIBUTE           => GREEN_BOX,
	      PAGE                => 0);

    ULR := 15;
    ULC := 40;
    LRR := 24;
    LRC := 79;
    BOX.DRAW (UPPER_LEFT_ROW      => ULR,
	      UPPER_LEFT_COLUMN   => ULC,
	      LOWER_RIGHT_ROW     => LRR,
	      LOWER_RIGHT_COLUMN  => LRC,
	      KIND                => DOUBLE,
	      ATTRIBUTE           => GREEN_BOX,
	      PAGE                => 0);

    Put (1,  (40 - 25), LINE1, HELP_BC, NORM_BC, NON_BLINK);
    Put (4,  41, "                                      ", ENTRY_FC, ENTRY_BC, NON_BLINK);
    Put (14, 41, "                                      ", HELP_FC, HELP_BC, NON_BLINK);
    Put (4,  (60 - 12), LINE2, ENTRY_FC, ENTRY_BC, NON_BLINK);
    Put (14, (60 - 12), LINE3, HELP_FC, HELP_BC, NON_BLINK);
  end DRAW_MAIN_MENU_BOX;

  --ͼ

  --ͻ

  procedure PRINT_MENU (MENU_TYPE : integer) is
    LINES, ROW, COLUMN  : integer;
    FC, BC              : COMMON_DISPLAY_TYPES.COLOR;
  begin
    case MENU_TYPE is
      when 1 => 
        LINES := 11;
        ROW   := 7;
        COLUMN := 2;
        FC     := NORM_FC;
        BC     := NORM_BC;

      when 2 => 
        LINES := 5;
        ROW   := 6;
        COLUMN := 42;
        FC     := ENTRY_FC;
        BC     := ENTRY_BC;

      when 3 => 
        LINES := 8;
        ROW   := 15;
        COLUMN := 42;
        FC     := HELP_FC;
        BC     := HELP_BC;

      when others => null;
    end case;

    for COUNTER in 1 .. LINES loop
      Put ((ROW + COUNTER), COLUMN, (MENU_LINE (COUNTER)), FC, BC, NON_BLINK);
    end loop;
  end PRINT_MENU;

  --ͼ

  --ͻ

  procedure CLEAR_FUNCTION_WINDOW is
  begin
    REG_FILE.AX := 16#0600#;
    REG_FILE.BX := 16#3000#;
    REG_FILE.CX := 16#0629#;
    REG_FILE.DX := 16#0B4E#;

    -- Call interrupt 10h
    INTERRUPT.VECTOR ( ON             => 16#10# ,
		       REGISTER_BLOCK => REG_FILE );
  end CLEAR_FUNCTION_WINDOW;

  --ͼ

  --ͻ

  procedure CLEAR_INFORMATION_WINDOW is
  begin
    REG_FILE.AX := 16#0600#;
    REG_FILE.BX := 16#2000#;
    REG_FILE.CX := 16#1029#;
    REG_FILE.DX := 16#174E#;

    -- Call interrupt 10h
    INTERRUPT.VECTOR ( ON             => 16#10# ,
		       REGISTER_BLOCK => REG_FILE );
  end CLEAR_INFORMATION_WINDOW;

  --ͼ

  --ͻ

  procedure DISPLAY_VIDEO_MODE is
  begin
    MENU_LINE(1)  := "        Graphic Video Modes         ";
    MENU_LINE(2)  := "                                    ";
    MENU_LINE(3)  := "4  CGA (320x200) | 16  EGA (640x350)";
    MENU_LINE(4)  := "5  CGA (320x200) | 17  VGA (640x480)";
    MENU_LINE(5)  := "6  CGA (640x200) | 17  MCGA(640x480)";
    MENU_LINE(6)  := "13  EGA (320x200)| 18  VGA (640x480)";
    MENU_LINE(7)  := "14  EGA (640x200)| 19  VGA (320x480)";
    MENU_LINE(8)  := "15  EGA (640x350)| 19  MCGA(320x480)";

    PRINT_MENU (3);
  end DISPLAY_VIDEO_MODE;

  --ͼ

  --ͻ

  procedure DISPLAY_COLOR is
  begin
    MENU_LINE(1)  := "0  -  Black    |   8  -  Grey       ";
    MENU_LINE(2)  := "1  -  Blue     |   9  -  Lgt-Blue   ";
    MENU_LINE(3)  := "2  -  Green    |  10  -  Lgt-Green  ";
    MENU_LINE(4)  := "3  -  Cyan     |  11  -  Lgt-Cyan   ";
    MENU_LINE(5)  := "4  -  Red      |  12  -  Lgt-Red    ";
    MENU_LINE(6)  := "5  -  Magenta  |  13  -  Lgt-Magenta";
    MENU_LINE(7)  := "6  -  Brown    |  14  -  Yellow     ";
    MENU_LINE(8)  := "7  -  White    |  15  -  Brt-White  ";

    PRINT_MENU (3);
  end DISPLAY_COLOR;

  --ͼ

  --ͻ

  procedure DISPLAY_PIXEL is
  begin
    MENU_LINE(1)  := "The position or coordinate requested";
    MENU_LINE(2)  := "is the pixel position on the screen.";
    MENU_LINE(3)  := "This relative pixel position will   ";
    MENU_LINE(4)  := "vary depending on the video mode    ";
    MENU_LINE(5)  := "selected.                           ";
    MENU_LINE(6)  := "                                    ";
    MENU_LINE(7)  := "                                    ";
    MENU_LINE(8)  := "                                    ";

    PRINT_MENU (3);
  end DISPLAY_PIXEL;

  --ͼ

  --ͻ

  procedure DISPLAY_ROW is
  begin
    MENU_LINE(1)  := "The row and col (column) position   ";
    MENU_LINE(2)  := "requested above depends on the video";
    MENU_LINE(3)  := "mode selected.  The minimum value is";
    MENU_LINE(4)  := "always 0 while the maximum value for";
    MENU_LINE(5)  := "the row and column is:              ";
    MENU_LINE(6)  := "Mode  row  col  |   Mode  row  col  ";
    MENU_LINE(7)  := "CGA    25   79  |   EGA    79   25  ";
    MENU_LINE(8)  := "VGA    50   79  |   MCGA   79   50  ";

    PRINT_MENU (3);
  end DISPLAY_ROW;

  --ͼ

  --ͻ

  procedure DISPLAY_FILE_INFO is
  begin
    MENU_LINE(1)  := "The maximum characters you may enter";
    MENU_LINE(2)  := "for file name is 30.  The file name ";
    MENU_LINE(3)  := "may contain the designated drive,   ";
    MENU_LINE(4)  := "path, and file name.  For example,  ";
    MENU_LINE(5)  := "                                    ";
    MENU_LINE(6)  := "For current drive - myfile.scn      ";
    MENU_LINE(7)  := "On another path - C:\draw\myfile.srn";
    MENU_LINE(8)  := "Different drive - D:\screen\new.scn ";

    PRINT_MENU (3);
  end DISPLAY_FILE_INFO ;

  --ͼ

  --ͻ

  procedure DISPLAY_MENU_INFO is
    LINE : constant string := "   Main Demonstration Menu   ";  -- 28 characters long
  begin
    MENU_LINE(1)  := "[1]   DRAW Package Functions        ";
    MENU_LINE(2)  := "[2]   Window Package Functions      ";
    MENU_LINE(3)  := "[3]   Screen Package Functions      ";
    MENU_LINE(4)  := "[4]   Select Video Mode             ";
    MENU_LINE(5)  := "[5]   Run AGUL User Input Demo      ";
    MENU_LINE(6)  := "[6]   -- future use --              ";
    MENU_LINE(7)  := "[7]   -- future use --              ";
    MENU_LINE(8)  := "[8]   Run AGUL Contineous Demo      ";
    MENU_LINE(9)  := "[9]   -- future use --              ";
    MENU_LINE(10) := "[0]   Exit Package Selection Menu   ";
    MENU_LINE(11) := "Press <RETURN> to select Package    ";

    MENU_SELECT := 0;
    Put (4, (20 - 14), LINE, NORM_FC, NORM_BC, NON_BLINK);
    PRINT_MENU (1);
  end DISPLAY_MENU_INFO;

  --ͼ
  --ͻ

  procedure DRAW_MENU is
    LINE : constant string := " DRAW Package Function Menu ";  -- 28 characters long
  begin
    MENU_LINE(1)  := "[1]   Ellipse                       ";
    MENU_LINE(2)  := "[2]   Circle                        ";
    MENU_LINE(3)  := "[3]   Circle_Segment                ";
    MENU_LINE(4)  := "[4]   ARC                           ";
    MENU_LINE(5)  := "[5]   Rectangle                     ";
    MENU_LINE(6)  := "[6]   Line                          ";
    MENU_LINE(7)  := "[7]   Object FillColor              ";
    MENU_LINE(8)  := "[8]   Foreground Color              ";
    MENU_LINE(9)  := "[9]   Background Color              ";
    MENU_LINE(10) := "[0]   Exit to Package Selection Menu";
    MENU_LINE(11) := "Press <RETURN> to select function   ";

    MENU_SELECT := 1;
    Put (4, (20 - 14),  LINE, NORM_FC, NORM_BC, NON_BLINK);
    PRINT_MENU (1);
  end DRAW_MENU;

  --ͼ
  --ͻ

  procedure WINDOW_MENU is
    LINE : constant string := "WINDOW Package Function Menu";  -- 28 characters long
  begin
    MENU_LINE(1)  := "[1]   Select Window                 ";
    MENU_LINE(2)  := "[2]   Define Windows                ";
    MENU_LINE(3)  := "[3]   Select World                  ";
    MENU_LINE(4)  := "[4]   Define World Coordinates      ";
    MENU_LINE(5)  := "[5]   Save Window to Disk           ";
    MENU_LINE(6)  := "[6]   Load Window File from Disk    ";
    MENU_LINE(7)  := "[7]   Reset Window                  ";
    MENU_LINE(8)  := "[8]   Reset World                   ";
    MENU_LINE(9)  := "[9]   -- future use --              ";
    MENU_LINE(10) := "[0]   Exit to Package Selection Menu";
    MENU_LINE(11) := "Press <RETURN> to select function   ";

    MENU_SELECT := 2;
    Put (4, (20 - 14),  LINE, NORM_FC, NORM_BC, non_BLINK);
    PRINT_MENU (1);
  end WINDOW_MENU;

  --ͼ

  --ͻ

  procedure SCREEN_MENU is
    LINE : constant string := "SCREEN Package Function Menu";  -- 28 characters long
  begin
    MENU_LINE(1)  := "[1]   Video Page0                   ";
    MENU_LINE(2)  := "[2]   Video Page1                   ";
    MENU_LINE(3)  := "[3]   Swap Video Pages              ";
    MENU_LINE(4)  := "[4]   Save Active Screen to Disk    ";
    MENU_LINE(5)  := "[5]   Load File to Active Screen    ";
    MENU_LINE(6)  := "[6]   Copy Video Page0 to Page1     ";
    MENU_LINE(7)  := "[7]   -- future use --              ";
    MENU_LINE(8)  := "[8]   -- future use --              ";
    MENU_LINE(9)  := "[9]   -- future use --              ";
    MENU_LINE(10) := "[0]   Exit to Package Selection Menu";
    MENU_LINE(11) := "Press <RETURN> to select function   ";

    MENU_SELECT := 3;
    Put (4, (20 - 14),  LINE, NORM_FC, NORM_BC, non_BLINK);
    PRINT_MENU (1);
  end SCREEN_MENU;

  --ͼ

  --ͻ

  procedure DISPLAY_MENU (MENU : integer) is
  begin
    case MENU is
      when 0 =>
	TTY.CLEAR_SCREEN;
        DRAW_MAIN_MENU_BOX;
        CLEAR_FUNCTION_WINDOW;
        CLEAR_INFORMATION_WINDOW;
        DISPLAY_MENU_INFO;

      when 1 =>
	CLEAR_FUNCTION_WINDOW;
        CLEAR_INFORMATION_WINDOW;
        DISPLAY_MENU_INFO;

      when 2 =>
	CLEAR_FUNCTION_WINDOW;
        CLEAR_INFORMATION_WINDOW;
        DRAW_MENU;

      when 3 =>
	CLEAR_FUNCTION_WINDOW;
        CLEAR_INFORMATION_WINDOW;
        WINDOW_MENU;

      when 4 =>
	CLEAR_FUNCTION_WINDOW;
        CLEAR_INFORMATION_WINDOW;
        SCREEN_MENU;

      when 5 =>
	CLEAR_INFORMATION_WINDOW;

      when 6 =>
	DISPLAY_VIDEO_MODE;

      when 7 =>
	DISPLAY_COLOR;

      when 8 =>
	DISPLAY_PIXEL;

      when 9 =>
	DISPLAY_ROW;

      when 10 =>
	DISPLAY_FILE_INFO;

      when others =>
	null;

    end case;
  end DISPLAY_MENU;

  --ͼ

end AGULMENU;
