with text_io;   use text_io;
with fio;
with iio;

procedure msctest is
  i, j: integer;
  a, b: float;

  procedure msc_start;
    pragma INTERFACE(microsoft_C, msc_start);

  procedure msc_end;
    pragma INTERFACE(microsoft_C, msc_end);

  function cinttst1(x: integer) return integer;
    pragma INTERFACE(microsoft_C, cinttst1);

  procedure cinttst2(x, y: integer; z: out integer);
    pragma INTERFACE(microsoft_C, cinttst2);

  procedure cflttst(x: in out float;
		    y: in out float);
    pragma INTERFACE(microsoft_C, cflttst);

begin
  put_line("Beginning of Ada/Microsoft-C Interface Example.");
  new_line;

  put_line("Calling msc_start.");
  new_line;
  msc_start;

  put_line("Calling cinttst1 ...");
  new_line;

  i := cinttst1(4);

  new_line;
  put_line("... result returned from cinttst1:");
  put("  i (16) = ");  iio.put(i);  new_line;
  new_line;

  put_line("Calling cinttst2 ...");
  new_line;

  i := 5;
  cinttst2(i, 11, j);

  new_line;
  put_line("... result returned from cinttst2:");
  put("  j (55) = ");  iio.put(j);  new_line;
  new_line;

  put_line("Calling cflttst ...");
  new_line;

  a := 1.23456;
  b := 9.87654;

  cflttst(a,b);

  new_line;
  put_line("... results returned from cflttst:");
  put("  a (8.76543) = ");  fio.put(a, aft => 5, exp => 0);  new_line;
  put("  b (2.34567) = ");  fio.put(b, aft => 5, exp => 0);  new_line;
  new_line;

  put_line("Calling msc_end.");
  msc_end;

  new_line;
  put_line("End of Ada/Microsoft-C Interface Example.");
end;
