with ada_io;    use ada_io;
with text_handler;
procedure thtest is
begin
  put_line("TEST LENGTH");
  declare
    use text_handler;
    t: text(10);
    l: index;
  begin
    set(t, "rasp");     put("set(t, ""rasp""); ");
    l := length(t);     put_line("length(t) = <4>: " & index'image(l));
  end;

  put_line("TEST EMPTY");
  declare
    use text_handler;
    t: text(10);
  begin
    set(t, "");
    put_line("set(t, """"); empty(t) = <true>: " & Boolean'image(empty(t)));
  end;

  put_line("TEST ""&""");
  declare
    use text_handler;
    t: text(80);
  begin
    set(t, "da");         put("set(t, ""da""); ");
    set(t, t & t );       put("set(t, t & t); ");
    set(t, t & "esque");  put("set(t, t & ""esque""); ");
    set(t, '_' & t );     put_line("set(t, '_' & t); ");
    put_line("t = <_dadaesque>: " & value(t));
  end;

  put_line("TEST RELATIONAL FUNCTIONS");
  declare
    use text_handler;
    t, u: text(10);
  begin
    set(t, "there");      put("set(t, ""there""); ");
    set(u, "therapy" );   put("set(u, ""therapy""); ");
    if t > u then
      put_line("PASSED-- t > u");
    else
      put_line("FAILED-- t <= u");
    end if;
  end;

  put_line("TEST SET");
  declare
    use text_handler;
    t, u: text(10);
  begin
    set(t, "zot");      put("set(t, ""zot""); ");
    set(t, 'z');        put("set(t, 'z'); ");
    set(u, t);          put("set(u, t); ");
    put_line("u = <z>: " & value(u));
  end;

  put_line("TEST APPEND");
  declare
    use text_handler;
    t, u: text(10);
  begin
    set(u, "st");       put("set(u, ""st""); ");
    set(t, "pa");       put("set(t, ""pa""); ");
    append(u, to => t); -- "past"
	put("append(u, t); ");
    append('e', to => t);       -- "paste"
	put_line("append('e', t); ");
    append("urize", to => t);               put("append(""urize"", t); ");
    put_line("t = <pasteurize>: " & value(t));
  end;

  put_line("TEST AMEND");
  declare
    use text_handler;
    t, u: text(10);
  begin
    set(t, "analogy");  put("set(t, ""analogy""); ");
    set(u, "yst");      put("set(u, ""yst""); ");
    amend(t, by => u, position => 5);     put("amend(t, u, 5); ");
    amend(t, by => "ze", position => 6);  put_line("amend(t, ""ze"", 6); ");
    amend(t, by => 's', position => 6);   put("amend(t, 's', 6); ");
    put_line("t = <analyse>: " & value(t));
  end;

  put_line("TEST LOCATE");
  declare
    use text_handler;
    t, u: text(80);
    i: index;
  begin
    set(t, "Beware the Lurker at the Threshold.");
	put("set(t, ""Beware the Lurker at the Threshold.""); ");
    set(u, "Cthulhu!");
	put_line("set(u, ""Cthulhu!""); ");
    i := locate("Lurk", within => t);
    put_line("locate(""Lurk"", t) = <12>: " & index'image(i));
    i := locate('T', within => t);
    put_line("locate('T', t) = <26>: " & index'image(i));
    i := locate(u, within => t);
    put_line("locate(u, t) = <0>: " & index'image(i));
  end;

  put_line("---END TESTS---");
end thtest;
