-- This example accepts command lines of the form:
--
--      prog [-a] [-b] [arg] ...
--
-- where "prog" is the name of the program, "-a" and
-- "-b" are legal options, and "arg" is some optional
-- argument.
--
with text_handler;      use text_handler;
with text_io;           use text_io;
with arg;
procedure scan_com is
  this: text(127);
  unrecognized_option: exception;
  illegal_argument: exception;
begin
  for i in 2..arg.count loop

    set(this, arg.data(i));
      -- convert string argument to text object.

    if not empty(this) then
      if value(this)(1) = '-' then
	if length(this) < 2 then
	  raise illegal_argument;
	    -- argument was just '-' alone.
	end if;
	case value(this)(2) is
	  when 'a' =>
	    put_line("-a recognized");
	  when 'b' =>
	    put_line("-b recognized");
	  when others =>
	    raise unrecognized_option;
	      -- argument wasn't "-a" or "-b".
	end case;
      else
	put_line("argument """ & value(this) &
		    """ recognized");
	  -- argument didn't start with '-'.
      end if;
    else
      raise illegal_argument;
	-- argument was empty somehow.
    end if;

  end loop;

exception
  when illegal_argument =>
    put_line("Illegal argument");

  when unrecognized_option =>
    put_line("Unrecognized option: '" &
		value(this) & ''');

end scan_com;
