


--           Test program for Meridian Ada compiler.            --
--    This program computes prime numbers by using a sieve.     --
--      Copyright (C) 1986 Meridian Software Systems, Inc.      --

with ada_io; use ada_io;
procedure sieve is
  pragma suppress(index_check);
  size: constant integer := 8190;
  flags: array(0..size) of boolean;
  i, k, prime: integer;
  count: integer := 0;
begin
  for i in flags'range loop
    flags(i) := true;
  end loop;
  for i in 0..size loop
    if flags(i) then
      prime := 2*i+3;
      k := i + prime;
      while k <= size loop
	flags(k) := false;
	k := k+prime;
      end loop;
      if count mod 12 = 0 then
	new_line;
      end if;
      put(prime, width => 6);
      count := count + 1;
    end if;
  end loop;

  new_line;
  put(count);
  put(" primes.");
  new_line;
end;
