generic
  type index is (<>);
  type elem is private;
  type vector is array(index range <>) of elem;
  with function gt(a,b: elem) return boolean;
  with procedure putaux(x: elem);
package gsort is
  procedure put(v: vector);
  procedure sort(v: in out vector);
end;

with ada_io; use ada_io;
package body gsort is

  procedure put(v: vector) is
  begin
    for i in v'first..v'last loop
      putaux(v(i));
      put(' ');
    end loop;
    new_line;
  end;

  procedure sort(v: in out vector) is
    i: index;
    j: index;
    m: elem;
    t: elem;
  begin
    i := v'first;
    j := v'last;
    m := v(index'val((index'pos(i)+index'pos(j))/2));
    while i <= j loop
      while gt(m, v(i)) loop
	i := index'succ(i);
      end loop;
      while gt(v(j), m) loop
	j := index'pred(j);
      end loop;
      if i <= j then
	t := v(i);
	v(i) := v(j);
	v(j) := t;
	i := index'succ(i);
	j := index'pred(j);
      end if;
    end loop;
    if v'first < j then
      sort(v(v'first..j));
    end if;
    if i < v'last then
      sort(v(i..v'last));
    end if;
  end sort;

end gsort;
