package dos_asm_interface is
  procedure dos_output_char(ch: character);
    pragma INTERFACE(assembly, dos_output_char);

  procedure dos_output_str(str: in string);
    pragma INTERFACE(assembly, dos_output_str);

  function dos_input_ready return boolean;
    pragma INTERFACE(assembly, dos_input_ready);

  type dos_time is
    record
      centisecs: byte_integer;  -- 0 .. 99
      seconds:   byte_integer;  -- 0 .. 59
      minutes:   byte_integer;  -- 0 .. 59
      hours:     byte_integer;  -- 0 .. 23
    end record;

  procedure dos_get_time(timeval: out dos_time);
    pragma INTERFACE(assembly, dos_get_time);

  procedure dos_version(major_version: out byte_integer;
			minor_version: out byte_integer);
    pragma INTERFACE(assembly, dos_version);
end dos_asm_interface;

with dos_asm_interface; use dos_asm_interface;
procedure asmtest is

  curtime: dos_time;
  major: byte_integer;
  minor: byte_integer;

  procedure out_newline is
  begin
    dos_output_char(ascii.cr);
    dos_output_char(ascii.lf);
  end;

  procedure out_str(str: in string) is
  begin
    dos_output_str(str & '$');
  end;

  procedure out_line(str: in string) is
  begin
    out_str(str);
    out_newline;
  end;

  procedure out_num(num: byte_integer) is
    numarr: constant array(0..9) of character := "0123456789";
  begin
    dos_output_char( numarr(integer(num)  /  10) );
    dos_output_char( numarr(integer(num) rem 10) );
  end;

begin
  out_line("Beginning of Ada/Assembly Interface Example.");
  out_newline;

  out_line("Testing dos_output_char ...");
  out_newline;

  for ich in '0' .. '9' loop
    dos_output_char(ich);
  end loop;
  out_newline;

  out_newline;
  out_line("Testing dos_output_str ...");
  out_newline;

  out_str("This is only a test.");
  out_newline;

  out_newline;
  out_line("Testing dos_version ...");
  out_newline;

  dos_version(major, minor);
  out_str("DOS version = ");
  out_num(major); dos_output_char('.');  out_num(minor);
  out_newline;

  out_newline;
  out_line("Testing dos_input_ready and dos_get_time ...");
  out_newline;

time_loop:
  while true loop
    dos_get_time(curtime);
    out_str("The time is now ");
    out_num(curtime.hours);     dos_output_char(':');
    out_num(curtime.minutes);   dos_output_char(':');
    out_num(curtime.seconds);   dos_output_char('.');
    out_num(curtime.centisecs);
    out_line(".  Type anything to stop.");

    for i in 1 .. 700 loop
      if dos_input_ready then
	exit time_loop;
      end if;
    end loop;

  end loop time_loop;

  out_newline;
  out_line("End of Ada/Assembly Interface Example.");
end asmtest;
