/*
=============================================================================

    Filename:       mciawi_x.h

    Description:

    This file is used to access the custom command set of the MCI
    Animation Driver.

=============================================================================
*/

/*  the resource compiler requires that all commands have a literal value
 *  which starts at MCI_USER_MESSAGES (literal value of 3072), so the
 *  custom MCI commands are listed by value below
 */

#define GOLDDISK_MCI_FIRST          MCI_USER_MESSAGES

/*  get version of MCI driver: string equivalent = "version" */
#define GOLDDISK_MCI_GETVER         3072

// if another message needs to be added 
// we need to do the following to ensure that we pass 
// the IF statement in mcimain.c 
//#define GOLDDISK_MCI_DUMMY          3073
//#define GOLDDISK_MCI_LAST           3073

#define GOLDDISK_MCI_LAST           3072


//  The MCI_VERSION_PARMS structure contains parameters for the
//  GOLDDISK_MCI_GETVER message. When assigning data to the fields in this
//  data structure, set the corresponding MCI flags in the dwFlags
//  parameter of mciSendCommand to validate the fields.

typedef struct {
    DWORD dwCallback;
    DWORD dwReturn;
} MCI_VERSION_PARMS, FAR *LPMCI_VERSION_PARMS;

//  DWORD dwCallback
//      The low-order word specifies a window handle used only when
//      the MCI_NOTIFY flag is set.
//
//  DWORD dwReturn
//      Contains the return information on exit.
