*************************************************
* BANKER2.PRG - CA dBFast CREATE CONTROL version
*************************************************

*: Define constants for events
#DEFINE eKybd      1
#DEFINE eClose     5
#DEFINE eButton    6

*: Define constants for actions
#DEFINE aNone      -1
#DEFINE aDone      1

*: Define constants for button names
#DEFINE bDone      "Done"
#DEFINE bAdd       "Add"

*: Define constants for key names
#DEFINE kESC       27

SET PROCEDURE TO BANKER2

USE BANKER2
INDEX ON NAME TO BANKER2

STORE '' TO sTheButton, sTheKey
nCustRec = 0

CREATE BUTTON bAdd  AT 23,29 SIZE 1,10 PLAIN ;
	VALID ADDLOAN()
CREATE BUTTON bDone AT 23,41 SIZE 1,10 PLAIN

CENTER('Demo Application',1,0,80,10)

CENTER('Customer Accounts',3,0,80,10)

SET SAY VIDEO TO 112

CREATE CONTROL FIELD NAME ;
	PICTURE REPLICATE('X',20) ;
	COLOR SAYVIDEO()

CREATE CONTROL BROWSE 'CustBrowse' AT 6,1 ;
	SIZE 15,76 ;
	TITLE 'Customer Loan Information;Name of Customer;' + ;
		'Acct #;LoanDate;Beg Amt;Balance;Cat' ;
	STYLE TITLE + VIEW ;
	SAVE TO nCustRec

  
* Initialize nAction

nAction = 0

* While not done

DO WHILE nAction <> aDone
	* Get the event
	nEvent = GETEVENT()
	* Translate event into action
	nAction = TRANSLATEEVENT(nEvent)
	* Do the action
	DO PROCESSACTION WITH nAction
ENDDO

RETURN


*******************
FUNCTION GETEVENT()
*******************
PRIVATE nTheEvent

STORE '' TO sTheButton, sTheKey
nTheEvent = -1

* Get an event  
DO WHILE nTheEvent = -1
	nTheEvent = MODALEVENT(.F.)
ENDDO

* Set the global variables
sTheButton = BUTTON()
sTheKey    = LASTKEY()
RETURN(nTheEvent)


*************************
FUNCTION TRANSLATEEVENT()
*************************
PARAMETER nTheEvent
PRIVATE nTheAction

nTheAction = aNone

DO CASE
	CASE nTheEvent = eKybd
		IF LASTKEY() = kESC
			nTheAction = aDone
		ENDIF
      
	CASE nTheEvent = eClose
		nTheAction = aDone
      
	CASE nTheEvent = eButton
		IF sTheButton = bDone
			nTheAction = aDone
		ENDIF
      
ENDCASE
RETURN(nTheAction)


***********************
PROCEDURE PROCESSACTION
***********************
PARAMETER nTheAction

DO CASE
	CASE nTheAction = aDone
		*: Already handled in the DO WHILE loop above
ENDCASE
RETURN


******************
FUNCTION ADDLOAN()
******************

STORE '' TO sName, sAcct_Num, sCategory
STORE DTOC(DATE()) TO sDate_Open
STORE '0.00' TO sBeg_Amount

CREATE WINDOW 'New Loan' FROM 5,8 TO 18,72 ;
	STYLE HIDDEN
 
CREATE BUTTON 'OK'     AT 0,52 SIZE 1,10
CREATE BUTTON 'Cancel' AT 2,52 SIZE 1,10 PLAIN

@ 2,2 SAY "Customer's Name:"
CREATE CONTROL EDITBOX 'EB.Name' AT 2,20 SIZE 1,30 ;
	SAVE TO sName

@ 4,2 SAY " Account Number:"
CREATE CONTROL EDITBOX 'EB.AcctNum' AT 4,20 ;
	SIZE 1,14 SAVE TO sAcct_Num

@ 6,2 SAY "      Loan Date:"
CREATE CONTROL EDITBOX 'EB.DateOpen' AT 6,20 ;
	SIZE 1,8 SAVE TO sDate_Open

@ 8,2 SAY "    Loan Amount:"
CREATE CONTROL EDITBOX 'EB.BegAmt' AT 8,20 ;
	SIZE 1,14 SAVE TO sBeg_Amount

@ 10,2 SAY "  Loan Category:"
CREATE CONTROL EDITBOX 'EB.Category' AT 10,20 ;
	SIZE 1,10 SAVE TO sCategory

SHOW WINDOW 'New Loan'
SELECT CONTROL 'EB.Name'
  
DO WHILE .T.    
	nEvent = GetEvent()
	IF nEvent = eButton 
		IF BUTTON() = 'OK'
			APPEND BLANK
		    REPLACE Name WITH sName
		    REPLACE Acct_No WITH sAcct_Num
		    REPLACE Date_Open WITH CTOD(sDate_Open)
		    REPLACE Beg_Amount WITH VAL(sBeg_Amount)
		    REPLACE Balance WITH 0.00
		    REPLACE Category WITH sCategory
			COMMIT
		ENDIF
		EXIT
	ENDIF
ENDDO

CLOSE WINDOW 'New Loan'
RETURN(.F.)
