echo off
cls
echo Installation for Quattro Pro's Notebook Template Collection

if "%1"=="" goto fail
if "%2"=="" goto destination_bad

:check_source
if exist %1\NTC.PAK goto check_target
goto destination_bad

:check_target
copy %1\README.NTC %2
cls
echo Installation for Quattro Pro's Notebook Template Collection
if NOT exist %2\README.NTC goto destination_bad
goto start

:start
echo Copying %1\README.NTC to %2...
copy %1\README.NTC %2

if exist %2\README.COM goto next_copy
echo Copying %1\README.COM to %2...
copy %1\README.COM %2

:next_copy
echo Copying %1\FILELIST.DOC to %2...
copy %1\FILELIST.DOC %2
%1\unpak x %1\NTC.PAK %2
goto end 

:destination_bad
echo EITHER [%1] OR [%2] IS INVALID.  
echo DON'T USE TRAILING BACKSLASH.
echo CHECK SOURCE & TARGET AND TRY AGAIN.

:fail
echo -----------------------------------------------------------
echo Format:  INSTALL [Source] [Target]
echo Example: INSTALL A: C:\QPRO
echo -----------------------------------------------------------
goto done

:end
echo ***********************************************************
echo                 Installation complete!
echo ***********************************************************
:done
