//========================================================================================
//
//     File:			ToolPane.cp
//     Release Version:	$Revision$
//
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef TOOLPANE_H
#include "ToolPane.h"
#endif

#ifndef TOOLPAL_H
#include "ToolPal.h"
#endif

#ifndef LINEGRID_H
#include "LineGrid.h"
#endif


DEFINE_CLASS(cToolPane, BR_CView)

//----------------------------------------------------------------------------------------
// cToolPane::cToolPane
//----------------------------------------------------------------------------------------

cToolPane::cToolPane(BR_CView* enclosure,
					 BR_CBureaucrat* supervisor,
					 cDrawState* State) :
	BR_CView(enclosure, supervisor, kDefaultViewId, kPixelUnits, 0, 0, 0, 0, 0, kFixedLeft, kFixedTop, BR_CColor(kRGBLightGray))
{
	cLineGrid * pLineGrid;
	cToolPalette * pToolPalette;

	pToolPalette = new cToolPalette(this, this, State);

	//
	//	Adjust the size of the Pane
	//
	BR_CRectangle PaneRect;
	pToolPalette->GetFrame(PaneRect);

	PaneRect.Set(0, 0, PaneRect.GetWidth(), PaneRect.GetHeight() + cLineGrid::eGridHeight);

	ViewToEnclosure(PaneRect);

	SetFrame(PaneRect, FALSE);

	//
	//	Add the Line selector grid to this pane.
	//
	pLineGrid = new cLineGrid(this, this, State);
}

//----------------------------------------------------------------------------------------
// cToolPane::~cToolPane
//----------------------------------------------------------------------------------------

cToolPane::~cToolPane()
{
}
