//========================================================================================
//
//     File:			StatRect.cp
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include <BRView.h>
#endif

#ifndef PAINT_H
#include "Paint.h"
#endif

#ifndef PAINTAPP_H
#include "PaintApp.h"
#endif

#ifndef STATRECT_H
#include "StatRect.h"
#endif

#ifndef PNTSTABR_H
#include "PntStaBr.h"
#endif

DEFINE_CLASS(cStatusRect, BR_CRectangleAdorner)

//----------------------------------------------------------------------------------------
// cStatusRect::cStatusRect
//----------------------------------------------------------------------------------------

cStatusRect::cStatusRect(BR_CRectangle& rNewBounds,
						 unsigned short wNewThickness,
						 BR_CColor penColor,
						 BR_CPen::PenStyle newPenStyle,
						 BR_CColor clrNewFill) :
	BR_CRectangleAdorner(-1, FALSE, FALSE, rNewBounds, wNewThickness, penColor, newPenStyle, clrNewFill)
{
}

//----------------------------------------------------------------------------------------
// cStatusRect::~cStatusRect
//----------------------------------------------------------------------------------------

cStatusRect::~cStatusRect()
{
}

//----------------------------------------------------------------------------------------
// cStatusRect::Draw
//
// Draws the rectangle on the status bar.
//----------------------------------------------------------------------------------------

void cStatusRect::Draw(BR_CView *view, const BR_CRectangle &rBounds)
{
	BR_Boolean fPrepare;				// flag used in Prepare method
	BR_CPen whitePen(kRGBWhite);	// The white pen
	BR_CPen blackPen(kRGBDarkGray);	// The Dark Gray Pen

	// Draw the border of the rectangle
	BR_CCanvas *pCanvas = view->GetCanvas();
	pCanvas->SetCurrentPen(&blackPen);

	pCanvas->MovePenTo(rBounds.fLeft, rBounds.fTop);
	pCanvas->DrawLineTo(rBounds.fRight, rBounds.fTop);
	pCanvas->MovePenTo(rBounds.fLeft, rBounds.fTop);
	pCanvas->DrawLineTo(rBounds.fLeft, rBounds.fBottom);

	pCanvas->SetCurrentPen(&whitePen);
	
	pCanvas->MovePenTo(rBounds.fRight, rBounds.fBottom);
	pCanvas->DrawLineTo(rBounds.fRight, rBounds.fTop);
	pCanvas->MovePenTo(rBounds.fRight, rBounds.fBottom);
	pCanvas->DrawLineTo(rBounds.fLeft, rBounds.fBottom);

	// Draw the text in rectangle
	DrawText(*view);
}

//----------------------------------------------------------------------------------------
// cStatusRect::DrawText
//
// Draw the text in a cStatusRect, first erase the the background.
//----------------------------------------------------------------------------------------

void cStatusRect::DrawText(BR_CView& view)
{
	BR_Boolean fPrepare;						// flag used in the Prepare method
	BR_CRectangle rBounds;						// Bounds of the cStatusRect
	BR_CPen GrayPen(kRGBGray);					// Light gray pen to draw reactangle
	BR_CColor LtGray(kRGBLightGray);			// Light gray color for inside of rect

	view.GetFrame(rBounds);

	// Make sure the text doesn't over write the border
	rBounds.Set(rBounds.fLeft + 3, rBounds.fTop + 2, rBounds.fRight - 3, rBounds.fBottom - 2);

	//
	//	Erase background
	//
	{
		BR_CGraphicsToolSelector PenSelector(&view, &GrayPen);
		BR_CDrawInitiator DrawInitiator(&view);
		view.GetCanvas()->DrawRectangle(rBounds, LtGray);
	}

	//
	//	Draw new text
	//
	view.GetCanvas()->DrawText(rBounds, fRectText, BEDDT_LEFT);
}

//----------------------------------------------------------------------------------------
// cStatusRect::SetText
//
// Sets the text for the cStatusRect
//----------------------------------------------------------------------------------------

void cStatusRect::SetText(BR_TString<BR_Char>& text)
{
	cMyStatusBar *myStatusBar	= ((cPaintApp *)BR_CApplication::GetCurrentApplication())->GetStatusBar() ;
	fRectText	= text;
	DrawText(*myStatusBar);
}
