//========================================================================================
//
//     File:			PntTools.cp
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRGRHELP_H
#include <BRGrHelp.h>
#endif

#ifndef PNTTOOLS_H
#include "PntTools.h"
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

//----------------------------------------------------------------------------------------
// cPaintTool::cPaintTool
//----------------------------------------------------------------------------------------

cPaintTool::cPaintTool(cDrawState* State,
					   int BitmapResourceId,
					   int CursorResId) :
	BR_CMouseAction(NULL, (BR_Boolean)FALSE, (BR_Boolean)FALSE),
	fDrawState(State),
	fBitmapResId(BitmapResourceId),
	fCursorId(CursorResId),
	fInitiator(NULL)
{
}

//----------------------------------------------------------------------------------------
// cPaintTool::~cPaintTool
//----------------------------------------------------------------------------------------

cPaintTool::~cPaintTool()
{
}

//----------------------------------------------------------------------------------------
// cPaintTool::BeginTracking
//
// Create a draw initiator at the begining of tracking so that one does not have to be
// created each time the mouse tracks.
//----------------------------------------------------------------------------------------

void cPaintTool::BeginTracking(const BR_CPoint &p)
{
	BR_CMouseAction::BeginTracking(p);
	fDrawState->fIsDrawing	= TRUE;
	fInitiator 	= new BR_CDrawInitiator(GetPane());
}

//----------------------------------------------------------------------------------------
// cPaintTool::EndTracking
//
// Delete the draw initiator.
//----------------------------------------------------------------------------------------

void cPaintTool::EndTracking(const BR_CPoint &p)
{
	BR_CMouseAction::EndTracking(p);

	delete fInitiator;
	fInitiator = NULL;
	fDrawState->fIsDrawing	= FALSE;
}

//----------------------------------------------------------------------------------------
// cPaintTool::GetBitmapId
//----------------------------------------------------------------------------------------

int cPaintTool::GetBitmapId()
{
	return fBitmapResId;
}

//----------------------------------------------------------------------------------------
// cPaintTool::GetCursorId
//----------------------------------------------------------------------------------------

int cPaintTool::GetCursorId()
{
	return fCursorId; 
}
