#ifndef PNTSTABR_H
#define PNTSTABR_H
//========================================================================================
//
//     File:			PntStaBr.h
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSTATUS_H
#include <BRStatus.h>
#endif

#ifndef STATRECT_H
#include "StatRect.h"
#endif

//========================================================================================
// class cMyStatusBar
//
// A class derived from BR_CStatusBar which uses cStatusRect's to display the help status,
// current row and column.
//========================================================================================

class cMyStatusBar : public BR_CStatusBar
{
public:
					cMyStatusBar(BR_CAppDesktop* enclosure,
						  		 long thickness,
						 		 long xTextOffset);
					~cMyStatusBar();
	cStatusRect& 	GetHelpRect(); 
	cStatusRect& 	GetColumnRect();
	cStatusRect& 	GetRowRect();

private:
	cStatusRect		*fHelpRect;    // Pointer to the Help Status Rectangle
	cStatusRect		*fColumnRect;  // Pointer to the Column Rectangle
	cStatusRect		*fRowRect;	   // Pointer to the Row Rectangle

					BR_SETCLASSNAME(cStatusRect);
};

//----------------------------------------------------------------------------------------
// cMyStatusBar::GetHelpRect
//----------------------------------------------------------------------------------------

inline cStatusRect& cMyStatusBar::GetHelpRect()
{
	return *fHelpRect;
}

//----------------------------------------------------------------------------------------
// cMyStatusBar::GetColumnRect
//----------------------------------------------------------------------------------------

inline cStatusRect& cMyStatusBar::GetColumnRect()
{
	return *fColumnRect;
}

//----------------------------------------------------------------------------------------
// cMyStatusBar::GetRowRect
//----------------------------------------------------------------------------------------

inline cStatusRect& cMyStatusBar::GetRowRect()
{
	return *fRowRect;
}

#endif
