//========================================================================================
//
//     File:			PntBtMap.cp
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRAPPLIC_H
#include <BRApplic.h>
#endif

#ifndef BRCARET_H
#include <BRCaret.h>
#endif

#ifndef BRMNUBAR_H
#include <BRMnuBar.h>
#endif

#ifndef BRCMDIDS_H
#include <BRCmdIds.h>
#endif

#ifndef BRSYSTEM_K
#include <BRSystem.k>
#endif

#ifndef PAINTAPP_H
#include "PaintApp.h"
#endif

#ifndef PNTBTMAP_H
#include "PntBtMap.h"
#endif

#ifndef PNTSTABR_H
#include "PntStaBr.h"
#endif

#ifndef STATRECT_H
#include "StatRect.h"
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

#ifndef PNTTOOLS_H
#include "PntTools.h"
#endif

DEFINE_CLASS(cPaintBitmapPane, BR_CView)

//----------------------------------------------------------------------------------------
// cPaintBitmapPane::cPaintBitmapPane
//----------------------------------------------------------------------------------------

cPaintBitmapPane::cPaintBitmapPane(BR_CView* enclosure,
								   BR_CBureaucrat* supervisor,
								   cDrawState* State) :
	BR_CView(enclosure, supervisor, kDefaultViewId, kPixelUnits, 0, 0, 0, 0, 0, kFitEnclosure, kFitEnclosure, BR_CColor(kRGBWhite)),
	fCursor(NULL),
	fDrawState(State)
{
}

//----------------------------------------------------------------------------------------
// cPaintBitmapPane::~cPaintBitmapPane
//----------------------------------------------------------------------------------------

cPaintBitmapPane::~cPaintBitmapPane()
{
	delete fCursor;
}

//----------------------------------------------------------------------------------------
// cPaintBitmapPane::UpdateMenus
//
// Called to activate menu options.
//----------------------------------------------------------------------------------------

void cPaintBitmapPane::UpdateMenus(BR_CMenuBar& menuBar, BR_Boolean fCallSupervisor)
{
	UpdateMenus(menuBar, fCallSupervisor);
}

//----------------------------------------------------------------------------------------
// cPaintBitmapPane::DoCommand
//
// Called to process command options.
//----------------------------------------------------------------------------------------

BR_Boolean cPaintBitmapPane::DoCommand(unsigned short cmdId,
									   BR_CObject* notifier,
									   BR_Boolean fCallSupervisor)
{
	BR_Boolean bCommandHandled = TRUE;			// Return value

	switch (cmdId)
	{
			// Clear the selection rectangle
		case cmdClear:
			break;
		default:
			bCommandHandled = BR_CView::DoCommand(cmdId, notifier, fCallSupervisor);
	}
	return (bCommandHandled);
}

//----------------------------------------------------------------------------------------
// cPaintBitmapPane::DoClick
//
// Called when the cPaintBitmapPane is clicked on.
//----------------------------------------------------------------------------------------

void cPaintBitmapPane::DoClick(const BR_CPoint& ptMouse, KeyModifiers keys)
{
	//
	//	Only do something if we are not already drawing
	//
	if (fDrawState->fIsDrawing == FALSE)
	{
		//
		//	Set the Pane for the Current tool and set the Bitmap pane
		//	to have the mouseaction if a Current tool exists.
		//
		if (fDrawState->fCurrentTool != NULL)
		{
			fDrawState->fCurrentTool->SetPane(this);
			fDrawState->fCurrentBitmap = pBitmap;
			SetMouseAction(fDrawState->fCurrentTool);
		}
		BR_CView::DoClick(ptMouse, keys);
	}
}

//----------------------------------------------------------------------------------------
// cPaintBitmapPane::Draw
//
// Draws the current bitmap pane.
//----------------------------------------------------------------------------------------

void cPaintBitmapPane::Draw(BR_CCanvas &canvas, const BR_CRectangle& area)
{
	if (pBitmap != NULL)
	{
		BR_CRectangle interior;
		GetInterior(interior);
		
		canvas.DrawBitmap(interior.fLeft, interior.fTop, *pBitmap, BEDDM_COPYPEN);
	}

	BR_CView::Draw(canvas, area);
}

//----------------------------------------------------------------------------------------
// cPaintBitmapPane::ReceiveFocus
//
// Called when the pane receives focus.  Set the cursor.
//----------------------------------------------------------------------------------------

void cPaintBitmapPane::ReceiveFocus()
{
	// Change the cursor in the active cPaintBitmapPane
	BR_Boolean caught = FALSE;
	BR_VOLATILE(caught);

	BR_CCursor *tempCursor=fCursor;
	BR_TRY
	{
		fCursor = new BR_CCursor(*GetApplication(), fDrawState->fCurrentTool->GetCursorId());
	}
	BR_CATCH_BEGIN
	BR_CATCH_EVERYTHING()
	{
		caught = TRUE;
	}
	BR_CATCH_END
	
	if (caught) {
		BR_CView::ReceiveFocus();
		return;
	}
		
	SetCursor(fCursor, FALSE);
	if (tempCursor != NULL)
	{
		delete tempCursor;
	}
	BR_CView::ReceiveFocus();
}

//----------------------------------------------------------------------------------------
// cPaintBitmapPane::LoseFocus
//
// Called when the pane looses focus
//----------------------------------------------------------------------------------------

void cPaintBitmapPane::LoseFocus(BR_CView *viewReceivingFocus)
{
	SetCursor(kArrowCursor);
	if (fCursor != NULL)
	{
		delete fCursor;
		fCursor = NULL;
	}
	BR_CView::LoseFocus(viewReceivingFocus);
}

//----------------------------------------------------------------------------------------
// cPaintBitmapPane::SetBitmap
//
// Assign the pointer to the Bitmap.
//----------------------------------------------------------------------------------------

void  cPaintBitmapPane::SetBitmap(BR_CBitmap* Bitmap)
{
    pBitmap = Bitmap;
}
