#ifndef PAINTDOC_H
#define PAINTDOC_H
//========================================================================================
//
//     File:			PaintDoc.h
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDOCUME_H
#include <BRDocume.h>
#endif

struct cDrawState;
class cPaintBitmapPane;

//========================================================================================
// class cPaintDoc
//
// The bitmap editor Document.
//========================================================================================

class cPaintDoc : public BR_CDocument
{
public:
						cPaintDoc(BR_CApplication* applicaiton, cDrawState *);
	virtual				~cPaintDoc();

	// Overriden methods
	virtual void   		NewWindow();
	virtual BR_Boolean  NewFile();
	virtual BR_Boolean 	OpenFile(const BR_CFileSpecification&);
	virtual BR_Boolean  DoSave();
	virtual BR_Boolean	DoSaveAs(const BR_CFileSpecification&);
	virtual void   		DoRevert();
	virtual void   		UpdateMenus (BR_CMenuBar& menuBar, BR_Boolean fCallSupervisor);
	virtual BR_Boolean  DoCommand (unsigned short cmdId, 
								   BR_CObject* notifier,
								   BR_Boolean fCallSupervisor);

private:
	cDrawState			*fDrawState;		// Pointer to the Draw State
	cPaintBitmapPane 	*fPaintBitmapPane;	// Pointer to the documents
	BR_CBitmap			*fBitmap;			// Pointer to the bitmap
	
	BR_Boolean 			SetBitmapFileName(BR_CFileSpecification& fileSpec);
	
						BR_SETCLASSNAME(cPaintDoc);
};
#endif
