//========================================================================================
//
//     File:			PaintDoc.cp
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRAPPLIC_H
#include <BRApplic.h>
#endif

#ifndef BRVIEW_H
#include <BRView.h>
#endif

#ifndef BRDOCUME_H
#include <BRDocume.h>
#endif

#ifndef BRCOLOR_H
#include <BRColor.h>
#endif

#ifndef BRCONDLG_H
#include <BRConDlg.h>
#endif

#ifndef BRDOCWIN_H
#include <BRDocWin.h>
#endif

#ifndef BRDLGDIR_H
#include <BRDlgDir.h>
#endif

#ifndef BREDITTX_H
#include <BREditTx.h>
#endif

#ifndef BRMDIDES_H
#include <BRMDIDes.h>
#endif

#ifndef BRSCROLL_H
#include <BRScroll.h>
#endif

#ifndef BRSTATUS_H
#include <BRStatus.h>
#endif

#ifndef BRFILESP_H
#include <BRFileSp.h>
#endif

#ifndef BRFONT_H
#include <BRFont.h>
#endif

#ifndef BRFONTCH_H
#include <BRFontCh.h>
#endif

#ifndef BRBITMAP_H
#include <BRBitmap.h>
#endif

#ifndef BRMNUBAR_H
#include <BRMnuBar.h>
#endif

#ifndef BRFILE_H
#include <BRFile.h>
#endif

#ifndef PAINT_H
#include "Paint.h"
#endif

#ifndef PAINTAPP_H
#include "PaintApp.h"
#endif

#ifndef PAINTDOC_H
#include "PaintDoc.h"
#endif

#ifndef PNTSTABR_H
#include "PntStaBr.h"
#endif

#ifndef PNTBTMAP_H
#include "PntBtMap.h"
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

DEFINE_CLASS(cPaintDoc,BR_CDocument)

//----------------------------------------------------------------------------------------
// cPaintDoc::cPaintDoc
//----------------------------------------------------------------------------------------

cPaintDoc::cPaintDoc(BR_CApplication* application,
					 cDrawState* State) :
	BR_CDocument(application, TRUE)
{
	//	Inititialize member variables
	fDrawState = State;
	fPaintBitmapPane = NULL;
	fBitmap = NULL;

}

//----------------------------------------------------------------------------------------
// cPaintDoc::~cPaintDoc
//----------------------------------------------------------------------------------------

cPaintDoc::~cPaintDoc()
{
	delete fBitmap;
}

//----------------------------------------------------------------------------------------
// cPaintDoc::NewWindow
//
// Creates a new Paint window on the MDI desktop.
//----------------------------------------------------------------------------------------

void cPaintDoc::NewWindow()
{
	BR_CApplication * Application = GetApplication();
	BR_CMDIAppDesktop * Desktop = (BR_CMDIAppDesktop *)Application->GetAppDesktop();

	// Create a new document window   
	BR_CDocWindow * pWindow = new BR_CDocWindow(Desktop, this);
	BR_CColor Gray = kRGBGray;
	BR_SScrollerInfo ScrollerInfo;

	BR_CScroller * pScroller = new BR_CScroller(pWindow, (BR_CBureaucrat *)this, -1, kPixelUnits, BR_CHelp::kNone, 1000, 1000, 0, 0, kScrollerFitEnclosure, kScrollerFitEnclosure, Gray, ScrollerInfo, ScrollerInfo);

	// Create a new bitmap pane to put the bitmap in
	fPaintBitmapPane = new cPaintBitmapPane(pWindow, pWindow, fDrawState);


	// Create a new bitmap for the bitmap pane
	fBitmap = new BR_CBitmap(fPaintBitmapPane, 1000, 1000, kPixelUnits);
	fPaintBitmapPane->SetBitmap(fBitmap);

	pWindow->Show();
}

//----------------------------------------------------------------------------------------
// cPaintDoc::NewFile
//
// Initializes the printer and sets the title for a new window.
//----------------------------------------------------------------------------------------

BR_Boolean cPaintDoc::NewFile()
{
	return TRUE;
}

//----------------------------------------------------------------------------------------
// cPaintDoc::OpenFile
//
// Called when a existing bitmap file is to be loaded into bitmap editor.
//----------------------------------------------------------------------------------------

BR_Boolean cPaintDoc::OpenFile(const BR_CFileSpecification&)
{
	BR_CDialogDirector notImplementedDialog((BR_CBureaucrat *)this, (BR_CView *)this, (BR_CModule &) * GetApplication(), IDD_NOT_IMPLEMENTED_DIALOG);
	notImplementedDialog.ShowDialog();

	return (FALSE);
}

//----------------------------------------------------------------------------------------
// cPaintDoc::DoSave
//
// Save the current bitmap to a bitmap file
//----------------------------------------------------------------------------------------

BR_Boolean cPaintDoc::DoSave()
{
	BR_CDialogDirector notImplementedDialog( (BR_CBureaucrat *)this,
											 (BR_CView *)this,
											 (BR_CModule &) *GetApplication(),
											 IDD_NOT_IMPLEMENTED_DIALOG);
   	notImplementedDialog.ShowDialog();

	return (FALSE);
}

//----------------------------------------------------------------------------------------
// cPaintDoc::DoSaveAs
//
// Save the bitmap to a new file name.
//----------------------------------------------------------------------------------------

BR_Boolean cPaintDoc::DoSaveAs(const BR_CFileSpecification&)
{
	BR_CDialogDirector notImplementedDialog((BR_CBureaucrat *)this, (BR_CView *)this, (BR_CModule &) * GetApplication(), IDD_NOT_IMPLEMENTED_DIALOG);
	notImplementedDialog.ShowDialog();
	return FALSE;
}

//----------------------------------------------------------------------------------------
// cPaintDoc::DoRevert
//
// Reloads the bitmap file from disk and discards any changes made to the copy in memory.
//----------------------------------------------------------------------------------------

void cPaintDoc::DoRevert()
{
	BR_CDialogDirector notImplementedDialog((BR_CBureaucrat *)this, (BR_CView *)this, (BR_CModule &) * GetApplication(), IDD_NOT_IMPLEMENTED_DIALOG);
	notImplementedDialog.ShowDialog();
	return;
}

//----------------------------------------------------------------------------------------
// cPaintDoc::SetBitmapFileName
//
// Sets the name of the bitmap file for the current editor.
//----------------------------------------------------------------------------------------

BR_Boolean cPaintDoc::SetBitmapFileName(BR_CFileSpecification& fileSpec)
{
	BR_CCharString255	aFileName ;
	BR_CFileStream*		fileStream = new BR_CFileStream(fileSpec) ;
	if (!fileStream)
	{
		return FALSE;
	}
	
	SetFileStream(fileStream);
	fileSpec.GetName(aFileName) ;
	GetWindow(0)->SetText(aFileName);
 	
 	return TRUE;
}

//----------------------------------------------------------------------------------------
// cPaintDoc::UpdateMenus
//
// Called to activate menu options.
//----------------------------------------------------------------------------------------

void cPaintDoc::UpdateMenus(BR_CMenuBar& menuBar, BR_Boolean fCallSupervisor)
{
	BR_CDocument::UpdateMenus(menuBar, fCallSupervisor);

	menuBar.EnableCmd(cmdRevert);
	menuBar.EnableCmd(cmdSave);
	menuBar.EnableCmd(cmdSaveAs);
	menuBar.EnableCmd(cmdPrint);
	menuBar.EnableCmd(cmdPrinterPrintSetup);
	menuBar.EnableCmd(cmdSetFont);
}

//----------------------------------------------------------------------------------------
// cPaintDoc::DoCommand
//----------------------------------------------------------------------------------------

BR_Boolean cPaintDoc::DoCommand(unsigned short cmdId,
								BR_CObject* notifier,
								BR_Boolean fCallSupervisor)
{
	BR_Boolean bCommandHandled = TRUE;			// Return value

	switch (cmdId)
	{
		case cmdRevert:
			DoRevert();
			break;
		case cmdPrint:
			{
				BR_CDialogDirector notImplementedDialog((BR_CBureaucrat *)this, (BR_CView *)this, (BR_CModule &) * GetApplication(), IDD_NOT_IMPLEMENTED_DIALOG);
				notImplementedDialog.ShowDialog();
			}
			break;
		case cmdPrinterPrintSetup:
			DoPrinterPrintSetup();
			break;
		default:
			bCommandHandled = BR_CDocument::DoCommand(cmdId, notifier, fCallSupervisor);
	}
	return (bCommandHandled);
}
