#ifndef PAINTAPP_H
#define PAINTAPP_H
//========================================================================================
//
//     File:			PaintApp.h
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRAPPLIC_H
#include <BRApplic.h>
#endif

#ifndef PNTSTABR_H
#include "PntStaBr.h"
#endif

#ifndef COLORWIN_H
#include "ColorWin.h"
#endif

class cToolWindow;
struct cDrawState;


//========================================================================================
// class cPaintApp
//
// This is the application class for the Bedrock Paint Program.
//========================================================================================

class cPaintApp : public BR_CApplication
{
public:
                      	 	cPaintApp(BR_CSystem* system);
	virtual            	 	~cPaintApp();
	cMyStatusBar*       	GetStatusBar();

	//Overriden methods
	virtual	void 			SetUpFileParameters();
	virtual BR_CAppDesktop* MakeAppDesktop();
	virtual BR_CDocument* 	CreateDocument();
	virtual BR_CDocument* 	OpenDocument(BR_CFileSpecification &fileSpec);
	virtual void       	 	UpdateMenus(BR_CMenuBar &menuBar, BR_Boolean fCallSupervisor);
	virtual BR_Boolean    	DoCommand(unsigned short cmdId,
										BR_CObject* notifier,
										BR_Boolean fCallSupervisor);
	virtual BR_Boolean      ShowHelpStatusString(const BR_TString<BR_Char> &helpStatusString);
	
private:
	cDrawState				*fDrawState;	// Pointer to the draw state
	cMyStatusBar        	*fStatusBar;  	// Pointer to the Status Bar
	cToolWindow				*fToolWindow;	// Pointer to the Tool Pane
	cColorWindow			*fColorWindow;	// Pointer to the Color Window
	
	void 					DoAboutBox();

							BR_SETCLASSNAME(cPaintApp);
};

//----------------------------------------------------------------------------------------
// cPaintApp::GetStatusBar
//----------------------------------------------------------------------------------------

inline cMyStatusBar* cPaintApp::GetStatusBar()
{
   return fStatusBar;
}

#endif
