#ifndef LINEGRID_H
#define LINEGRID_H
//========================================================================================
//
//     File:			LineGrid.h
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include <BRView.h>
#endif

struct cDrawState;

//========================================================================================
// class cLineGrid
//
// The line grid class used to select the current line width.
//========================================================================================

class cLineGrid : public BR_CView
{
public:
	enum
	{
		eNumLines = 10, eSpaceBetweenLines = 5, eTopOffset = 10, eGridHeight = 152
	};

					cLineGrid(BR_CView *enclosure,
							  BR_CBureaucrat *supervisor,
							  cDrawState *);
					~cLineGrid();
	int				GetLineWidth();

	// Overriden methods
	virtual void	Draw(BR_CCanvas &canvas, const BR_CRectangle &area);
	virtual void	DoClick(const BR_CPoint& aPoint, KeyModifiers keys);

private:
	static int	 	flineWidthArray[eNumLines];
	short			flineWidthIndex;				// Current line index in array
	cDrawState*		fDrawState;
	
	void			SetLineWidthIndex(unsigned short newLineWidthIndex);
	void 			DrawPointer(BR_CColor& pointerColor);
	LONG 			GetLinePixelOffset();

					BR_SETCLASSNAME(cLineGrid);
};

//----------------------------------------------------------------------------------------
// cLineGrid::GetLineWidth
//----------------------------------------------------------------------------------------

inline int cLineGrid::GetLineWidth()
{
	return flineWidthArray[flineWidthIndex];
}

#endif
