//========================================================================================
//
//     File:			LineGrid.cp
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRGRHELP_H
#include <BRGrHelp.h>
#endif

#ifndef BRRECT_H
#include <BRRect.h>
#endif

#ifndef BRPEN_H
#include <BRpen.h>
#endif

#ifndef BRCANVAS_H
#include <BRCanvas.h>
#endif

#ifndef BRWALLPA_H
#include <BRWallpa.h>
#endif

#ifndef PAINT_H
#include "Paint.h"
#endif

#ifndef LINEGRID_H
#include "LineGrid.h"
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

DEFINE_CLASS(cLineGrid, BR_CView)


//----------------------------------------------------------------------------------------
// cLineGrid::flineWidthArray
//
// Array containing the width in pixels of each line choice.
//----------------------------------------------------------------------------------------

int cLineGrid::flineWidthArray[cLineGrid::eNumLines] = 
	{ 1, 2, 4, 6, 8, 10, 12, 14, 16, 18 } ;

//----------------------------------------------------------------------------------------
// cLineGrid::cLineGrid
//----------------------------------------------------------------------------------------

cLineGrid::cLineGrid(BR_CView* enclosure,
					 BR_CBureaucrat* supervisor,
					 cDrawState* State) :
	BR_CView(enclosure, supervisor, kDefaultViewId, kPixelUnits, 0, enclosure->GetFrameWidth(), eGridHeight, 0, enclosure->GetFrameHeight() - eGridHeight, kFixedLeft, kFixedTop, BR_CColor(kRGBWhite)),
	flineWidthIndex(2),
	fDrawState(State)
{
	fDrawState->fCurrentLineWidth = GetLineWidth();
}

//----------------------------------------------------------------------------------------
// cLineGrid::~cLineGrid
//----------------------------------------------------------------------------------------

cLineGrid::~cLineGrid()
{
}

//----------------------------------------------------------------------------------------
// cLineGrid::Draw
//
// Draws the line grid.
//----------------------------------------------------------------------------------------

void cLineGrid::Draw(BR_CCanvas& canvas,
					 const BR_CRectangle& area)
{
	LONG width, height;
	BR_CPen blackPen(1, kRGBBlack);

	width = GetFrameWidth();
	height = GetFrameHeight();
	{
		BR_CDrawInitiator d1(this);
		BR_CGraphicsToolSelector s1(this, &blackPen);

		// Draw outline of pane
		GetCanvas()->DrawRectangle(1, 1, width - 1, height - 1);

		// Draw all the rectangles of different widths
		int curOffset = eTopOffset;
		for (int lineNum = 0; lineNum < eNumLines; lineNum++)
		{
			GetCanvas()->DrawRectangle(30, curOffset, width - 10, curOffset + flineWidthArray[lineNum], kRGBBlack);
			curOffset += flineWidthArray[lineNum] + eSpaceBetweenLines;
		}
	}

	// Draw the pointer to the current rectangle
	BR_CColor ColorBlack(kRGBBlack);
	DrawPointer(ColorBlack);
}

//----------------------------------------------------------------------------------------
// cLineGrid::DoClick
//
// Called when the LineGrid is click on.
//----------------------------------------------------------------------------------------

void cLineGrid::DoClick(const BR_CPoint& aPoint, KeyModifiers keys)
{
	int curOffset=eTopOffset;

	BR_CView::DoClick(aPoint, keys);

	// Find which rectangle was clicked on and make it active
	for(int lineNum=0; lineNum < eNumLines; lineNum++)
	{
	    if ( aPoint.fY > (curOffset-eSpaceBetweenLines/2) &&
			 aPoint.fY < curOffset + flineWidthArray[lineNum] + 
			 			eSpaceBetweenLines/2 )
		{
		   SetLineWidthIndex(lineNum);
		   break;
		}
		curOffset+=flineWidthArray[lineNum]+eSpaceBetweenLines;
	}
	fDrawState->fCurrentLineWidth = GetLineWidth();
}

//----------------------------------------------------------------------------------------
// cLineGrid::SetLineWidthIndex
//
// Set the current index for the line width array.
//----------------------------------------------------------------------------------------

void cLineGrid::SetLineWidthIndex(unsigned short newLineWidthIndex)
{
	BR_CColor TempColor(kRGBWhite);
	DrawPointer(TempColor);
 
	flineWidthIndex = newLineWidthIndex ;
	
	TempColor = kRGBBlack;
	DrawPointer(TempColor);
} 

//----------------------------------------------------------------------------------------
// cLineGrid::GetLinePixelOffset
//
// Get the pixel offset of the currently selected line width.
//----------------------------------------------------------------------------------------

long cLineGrid::GetLinePixelOffset()
{
	LONG curOffset=eTopOffset;

	for(LONG lineNum=0; lineNum < flineWidthIndex; lineNum++)
	{
		curOffset+=flineWidthArray[lineNum]+eSpaceBetweenLines;
	}
	return (curOffset);
}

//----------------------------------------------------------------------------------------
// cLineGrid::DrawPointer
//
// Draws the pointer on the left of the currently selected line.
//----------------------------------------------------------------------------------------

void cLineGrid::DrawPointer(BR_CColor& pointerColor)
{
	LONG curOffset = GetLinePixelOffset() + 
					 (flineWidthArray[flineWidthIndex]-1)/2;

	BR_CPen thePen(pointerColor);
	BR_CWallPaper theWallPaper(pointerColor);

	BR_CDrawInitiator d1(this);
	BR_CGraphicsToolSelector s1(this, &thePen);
	BR_CGraphicsToolSelector s2(this, &theWallPaper);
	GetCanvas()->DrawPie(25, curOffset, 20, 255, 30);
}
